/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.palette;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteSeparator;
import org.eclipse.jface.resource.ImageDescriptor;

public class PaletteContainer
extends PaletteEntry {
    public static final String PROPERTY_CHILDREN = "Children Changed";
    protected List children = new ArrayList();

    protected PaletteContainer(String label, String desc, ImageDescriptor icon, Object type) {
        super(label, desc, icon, null, type);
    }

    public boolean acceptsType(Object type) {
        return true;
    }

    public void add(PaletteEntry entry) {
        this.add(-1, entry);
    }

    public void add(int index, PaletteEntry entry) {
        if (!this.acceptsType(entry.getType())) {
            throw new IllegalArgumentException("This container can not contain this type of child: " + entry.getType());
        }
        ArrayList oldChildren = new ArrayList(this.getChildren());
        int actualIndex = index < 0 ? this.getChildren().size() : index;
        this.getChildren().add(actualIndex, entry);
        entry.setParent(this);
        this.listeners.firePropertyChange(PROPERTY_CHILDREN, oldChildren, this.getChildren());
    }

    public void addAll(List list) {
        ArrayList oldChildren = new ArrayList(this.getChildren());
        int i = 0;
        while (i < list.size()) {
            PaletteEntry child = (PaletteEntry)list.get(i);
            if (!this.acceptsType(child.getType())) {
                throw new IllegalArgumentException("This container can not contain this type of child: " + child.getType());
            }
            this.getChildren().add(child);
            child.setParent(this);
            ++i;
        }
        this.listeners.firePropertyChange(PROPERTY_CHILDREN, oldChildren, this.getChildren());
    }

    public void appendToSection(String id, PaletteEntry entry) {
        boolean found = false;
        int i = 0;
        while (i < this.getChildren().size()) {
            PaletteEntry currEntry = (PaletteEntry)this.getChildren().get(i);
            if (currEntry.getId().equals(id)) {
                found = true;
            } else if (found && currEntry instanceof PaletteSeparator) {
                this.add(i, entry);
                return;
            }
            ++i;
        }
        if (!found) {
            throw new IllegalArgumentException("Section not found: " + id);
        }
        this.add(entry);
    }

    public List getChildren() {
        return this.children;
    }

    private boolean move(PaletteEntry entry, boolean up) {
        PaletteContainer container;
        int index = this.getChildren().indexOf(entry);
        if (index < 0) {
            return false;
        }
        int n = index = up ? index - 1 : index + 1;
        if (index < 0 || index >= this.getChildren().size()) {
            return false;
        }
        if (this.getChildren().get(index) instanceof PaletteContainer && this.getUserModificationPermission() == 15 && (container = (PaletteContainer)this.getChildren().get(index)).acceptsType(entry.getType()) && container.getUserModificationPermission() == 15) {
            this.remove(entry);
            if (up) {
                container.add(entry);
            } else {
                container.add(0, entry);
            }
            return true;
        }
        ArrayList oldChildren = new ArrayList(this.getChildren());
        this.getChildren().remove(entry);
        this.getChildren().add(index, entry);
        this.listeners.firePropertyChange(PROPERTY_CHILDREN, oldChildren, this.getChildren());
        return true;
    }

    public boolean moveDown(PaletteEntry entry) {
        return this.move(entry, false);
    }

    public boolean moveUp(PaletteEntry entry) {
        return this.move(entry, true);
    }

    public void remove(PaletteEntry entry) {
        ArrayList oldChildren = new ArrayList(this.getChildren());
        if (this.getChildren().remove(entry)) {
            entry.setParent(null);
            this.listeners.firePropertyChange(PROPERTY_CHILDREN, oldChildren, this.getChildren());
        }
    }

    public void setChildren(List list) {
        PaletteEntry entry;
        List oldChildren = this.children;
        int i = 0;
        while (i < oldChildren.size()) {
            entry = (PaletteEntry)oldChildren.get(i);
            entry.setParent(null);
            ++i;
        }
        this.children = list;
        i = 0;
        while (i < this.children.size()) {
            entry = (PaletteEntry)this.children.get(i);
            entry.setParent(this);
            ++i;
        }
        this.listeners.firePropertyChange(PROPERTY_CHILDREN, oldChildren, this.getChildren());
    }

    public String toString() {
        return "Palette Container (" + (this.getLabel() != null ? this.getLabel() : "") + ")";
    }
}

