/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.ui.runner;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.File;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.utils.URIUtils;
import org.eclipse.n4js.xpect.ui.N4IDEXpectUIPlugin;
import org.eclipse.n4js.xpect.ui.runner.N4IDEXpectFileNameUtil;
import org.eclipse.xpect.runner.IXpectURIProvider;
import org.eclipse.xpect.runner.XpectURIProvider;
import org.eclipse.xpect.util.IBundleInfo;
import org.junit.runner.Description;

@Inherited
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
@XpectURIProvider(value=N4IDEXpectTestURIProvider.class)
public @interface N4IDEXpectTestFilesCollector {

    @Deprecated
    public static enum FileRoot {
        CLASS,
        CURRENT,
        PROJECT,
        SOURCE;

    }

    public static class N4IDEXpectTestURIProvider
    implements IXpectURIProvider {
        protected final N4IDEXpectTestFilesCollector ctx;
        protected final Class<?> owner;
        protected IBundleInfo project;
        private final List<String> testFilesLocations = Lists.newArrayList();

        public void addTestFileLocation(String testFileDescriptor) {
            this.testFilesLocations.add(testFileDescriptor);
        }

        protected N4IDEXpectTestURIProvider(Class<?> owner, N4IDEXpectTestFilesCollector ctx) {
            this.owner = owner;
            this.ctx = ctx;
        }

        protected URI createURI(File file) {
            return URIUtils.toFileUri((File)file);
        }

        public URI deresolveToProject(URI uri) {
            return uri.deresolve(this.getProject().getRootURI());
        }

        public String findRawLocation(Description description) {
            String filePath = N4IDEXpectFileNameUtil.getFilePath(description);
            List<String> testFilesRawLocations = this.testFilesLocations.stream().filter(testFileLocation -> testFileLocation.endsWith(filePath)).collect(Collectors.toList());
            RuntimeException re = null;
            switch (testFilesRawLocations.size()) {
                case 0: {
                    re = new RuntimeException("unexpected number of files for provided description");
                    N4IDEXpectUIPlugin.logError("no files mathching " + filePath + " found in known URIs", re);
                    throw re;
                }
                case 1: {
                    return URI.createURI((String)((String)testFilesRawLocations.get(0))).toFileString();
                }
            }
            re = new RuntimeException("unexpected number of files for provided description");
            StringBuilder sb = new StringBuilder("multiple files matching " + filePath + " found");
            testFilesRawLocations.forEach(testFileLocation -> sb.append("\n file : " + testFileLocation));
            N4IDEXpectUIPlugin.logError(sb.toString(), re);
            throw re;
        }

        public Collection<URI> getAllURIs() {
            ArrayList result = Lists.newArrayList();
            this.testFilesLocations.forEach(xtFileLocation -> {
                URI xtFIleURI = URI.createURI((String)xtFileLocation);
                result.add(xtFIleURI);
            });
            return result;
        }

        protected IBundleInfo getBundle() {
            IBundleInfo.Registry registry = IBundleInfo.Registry.INSTANCE;
            return registry.getBundle(URIUtils.toFileUri((String)new File(".").getAbsolutePath()));
        }

        protected IBundleInfo getProject() {
            if (this.project == null) {
                this.project = IBundleInfo.Registry.INSTANCE.getBundle(this.owner);
            }
            return this.project;
        }

        protected URI resolvePlatformResourceURI(URI uri) {
            List segments = uri.segmentsList();
            if (segments.size() < 2) {
                throw new RuntimeException("URI " + uri + " has an invalid format");
            }
            String symbolicName = (String)segments.get(1);
            IBundleInfo bundle = IBundleInfo.Registry.INSTANCE.getBundle(symbolicName);
            if (bundle == null) {
                throw new RuntimeException("Bundle " + symbolicName + " not found.");
            }
            URI uriInBundle = URI.createURI((String)Joiner.on((char)'/').join(segments.subList(2, segments.size())));
            return uriInBundle.resolve(bundle.getRootURI());
        }

        protected URI resolveProjectRelativeURI(URI uri) {
            List segments = uri.segmentsList();
            URI uriInProject = URI.createURI((String)Joiner.on((char)'/').join((Iterable)segments));
            return uriInProject.resolve(this.getProject().getRootURI());
        }

        public URI resolveURI(URI base, String newURI) {
            URI uri = URI.createURI((String)newURI);
            if (uri.isPlatformResource()) {
                return this.resolvePlatformResourceURI(uri);
            }
            if (uri.hasAbsolutePath()) {
                return this.resolveProjectRelativeURI(uri);
            }
            return uri.resolve(base);
        }
    }
}

