/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.navigator.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import java.util.LinkedList;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.IN4JSSourceContainer;
import org.eclipse.n4js.projectModel.locations.SafeURI;
import org.eclipse.n4js.ui.ImageDescriptorCache;
import org.eclipse.n4js.ui.navigator.internal.Node;
import org.eclipse.n4js.ui.navigator.internal.NodeAdapter;
import org.eclipse.n4js.ui.navigator.internal.ResourceNode;
import org.eclipse.n4js.utils.collections.Arrays2;
import org.eclipse.swt.graphics.Image;

class BuiltInProjectNode
extends NodeAdapter {
    private static final Image EXT_LIB_IMG = (Image)ImageDescriptorCache.ImageRef.EXTERNAL_LIB_PROJECT.asImage().orNull();
    private final IN4JSProject project;

    BuiltInProjectNode(Node parent, IN4JSProject project) {
        super(parent);
        Preconditions.checkNotNull((Object)project, (Object)"project");
        Preconditions.checkArgument((boolean)project.exists(), (Object)("Project '" + project.getProjectName() + "' does not exist."));
        this.project = project;
    }

    @Override
    public Image getImage() {
        return EXT_LIB_IMG;
    }

    @Override
    public String getText() {
        return this.project.getProjectName().getRawName();
    }

    @Override
    public Object[] getChildren() {
        ResourceNode manifestNode = this.getManifestResourceNode();
        LinkedList<ResourceNode> childrenList = new LinkedList<ResourceNode>();
        for (IN4JSSourceContainer srcContainer : this.project.getSourceContainers()) {
            String label;
            SafeURI location = srcContainer.getLocation();
            ResourceNode resourceNode = ResourceNode.create(this, location, label = srcContainer.getRelativeLocation());
            if (resourceNode == null) continue;
            childrenList.add(resourceNode);
        }
        Object[] children = childrenList.toArray(new ResourceNode[0]);
        return manifestNode != null ? Arrays2.add((Object[])children, (Object[])new ResourceNode[]{manifestNode}) : children;
    }

    private ResourceNode getManifestResourceNode() {
        SafeURI manifestLocation;
        ResourceNode manifestNode = null;
        if (!FluentIterable.from((Iterable)this.project.getSourceContainers()).transform(src -> src.getRelativeLocation()).contains((Object)"") && (manifestLocation = this.project.getProjectDescriptionLocation()) != null && manifestLocation.isFile()) {
            manifestNode = ResourceNode.create(this, manifestLocation);
        }
        return manifestNode;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.project.getProjectName() == null ? 0 : this.project.getProjectName().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BuiltInProjectNode)) {
            return false;
        }
        BuiltInProjectNode other = (BuiltInProjectNode)obj;
        return !(this.project.getProjectName() == null ? other.project.getProjectName() != null : !this.project.getProjectName().equals((Object)other.project.getProjectName()));
    }
}

