/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.navigator.internal;

import com.google.inject.Inject;
import java.io.File;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.n4js.projectModel.locations.SafeURI;
import org.eclipse.n4js.ts.ui.navigation.IURIBasedStorage;
import org.eclipse.n4js.ts.ui.navigation.URIBasedStorage;
import org.eclipse.n4js.ui.navigator.internal.N4JSProjectExplorerHelper;
import org.eclipse.n4js.ui.navigator.internal.Node;
import org.eclipse.n4js.ui.navigator.internal.ResourceNode;
import org.eclipse.n4js.utils.collections.Arrays2;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.navigator.resources.workbench.ResourceLinkHelper;
import org.eclipse.xtext.ui.editor.LanguageSpecificURIEditorOpener;
import org.eclipse.xtext.ui.editor.XtextReadonlyEditorInput;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;

public class N4JSResourceLinkHelper
extends ResourceLinkHelper {
    private static final Logger LOGGER = Logger.getLogger(N4JSResourceLinkHelper.class);
    @Inject
    private LanguageSpecificURIEditorOpener languageSpecificURIEditorOpener;
    @Inject
    private N4JSProjectExplorerHelper helper;

    public void activateEditor(IWorkbenchPage page, IStructuredSelection selection) {
        SafeURI<?> nodeLocation;
        Object firstElement;
        if (selection != null && !selection.isEmpty() && (firstElement = selection.getFirstElement()) instanceof ResourceNode && (nodeLocation = ((ResourceNode)firstElement).getLocation()).isFile()) {
            URI uri = nodeLocation.toURI();
            IEditorInput editorInput = EditorUtils.createEditorInput((IStorage)new URIBasedStorage(uri));
            IEditorPart editor = page.findEditor(editorInput);
            if (editor != null) {
                page.bringToTop((IWorkbenchPart)editor);
            } else {
                this.languageSpecificURIEditorOpener.open(uri, true);
            }
            return;
        }
        super.activateEditor(page, selection);
    }

    public IStructuredSelection findSelection(IEditorInput input) {
        IStructuredSelection selection = super.findSelection(input);
        if (selection == null || selection.isEmpty() && input instanceof XtextReadonlyEditorInput) {
            try {
                Node node;
                File file;
                URI uri;
                IStorage storage = ((XtextReadonlyEditorInput)input).getStorage();
                if (storage instanceof IURIBasedStorage && (uri = ((IURIBasedStorage)storage).getURI()).isFile() && (file = new File(uri.toFileString())).isFile() && (node = this.getResourceNode(file)) != null) {
                    return new StructuredSelection((Object)node);
                }
            }
            catch (CoreException e) {
                LOGGER.error((Object)"Error while extracting storage from read-only Xtext editor input.", (Throwable)e);
                return StructuredSelection.EMPTY;
            }
        }
        return selection;
    }

    private Node getResourceNode(File fileResource) {
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Node node;
            IProject project = iProjectArray[n2];
            Object[] nodes = this.helper.getVirtualNodesForProject(project);
            if (!Arrays2.isEmpty((Object[])nodes) && (node = nodes[0].findChild(fileResource)) != null) {
                return node;
            }
            ++n2;
        }
        return null;
    }
}

