/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.model.elements;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IExpressionManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DefaultLabelProvider;
import org.eclipse.debug.internal.ui.model.elements.ElementContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementEditor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;

public class ExpressionManagerContentProvider
extends ElementContentProvider {
    private static final AddNewExpressionElement ADD_NEW_EXPRESSION_ELEMENT = new AddNewExpressionElement();

    @Override
    protected int getChildCount(Object element, IPresentationContext context, IViewerUpdate monitor) throws CoreException {
        return ((IExpressionManager)element).getExpressions().length + (context.getColumns() != null ? 1 : 0);
    }

    @Override
    protected Object[] getChildren(Object parent, int index, int length, IPresentationContext context, IViewerUpdate monitor) throws CoreException {
        if (context.getColumns() != null) {
            return this.getElements(((IExpressionManager)parent).getExpressions(), ADD_NEW_EXPRESSION_ELEMENT, index, length);
        }
        return this.getElements(((IExpressionManager)parent).getExpressions(), index, length);
    }

    private Object[] getElements(Object[] elements, Object lastElement, int index, int length) {
        int max = elements.length + 1;
        if (index < max && index + length > max) {
            length = max - index;
        }
        if (index + length <= max) {
            Object[] sub = new Object[length];
            System.arraycopy(elements, index, sub, 0, Math.min(elements.length - index, length));
            if (index + length > elements.length) {
                sub[length - 1] = lastElement;
            }
            return sub;
        }
        return null;
    }

    @Override
    protected boolean supportsContextId(String id) {
        return id.equals("org.eclipse.debug.ui.ExpressionView");
    }

    @Override
    protected boolean hasChildren(Object element, IPresentationContext context, IViewerUpdate monitor) throws CoreException {
        return true;
    }

    private static class AddNewExpressionElement
    implements IElementLabelProvider,
    IElementEditor,
    ICellModifier {
        private AddNewExpressionElement() {
        }

        @Override
        public void update(ILabelUpdate[] updates) {
            int i = 0;
            while (i < updates.length) {
                String[] columnIds = updates[i].getColumnIds();
                if (columnIds == null) {
                    this.updateLabel(updates[i], 0);
                } else {
                    int j = 0;
                    while (j < columnIds.length) {
                        if ("org.eclipse.debug.ui.VARIALBE_COLUMN_PRESENTATION.COL_VAR_NAME".equals(columnIds[j])) {
                            this.updateLabel(updates[i], j);
                        } else {
                            updates[i].setLabel("", j);
                        }
                        ++j;
                    }
                }
                updates[i].done();
                ++i;
            }
        }

        private void updateLabel(ILabelUpdate update, int columnIndex) {
            update.setLabel(DebugUIMessages.ExpressionManagerContentProvider_1, columnIndex);
            update.setImageDescriptor(DebugUITools.getImageDescriptor("IMG_LCL_MONITOR_EXPRESSION"), columnIndex);
            FontData fontData = JFaceResources.getFontDescriptor((String)"org.eclipse.debug.ui.VariableTextFont").getFontData()[0];
            fontData.setStyle(2);
            update.setFontData(fontData, columnIndex);
        }

        @Override
        public CellEditor getCellEditor(IPresentationContext context, String columnId, Object element, Composite parent) {
            return new TextCellEditor(parent);
        }

        @Override
        public ICellModifier getCellModifier(IPresentationContext context, Object element) {
            return this;
        }

        public boolean canModify(Object element, String property) {
            return "org.eclipse.debug.ui.VARIALBE_COLUMN_PRESENTATION.COL_VAR_NAME".equals(property);
        }

        public Object getValue(Object element, String property) {
            return "";
        }

        public void modify(Object element, String property, Object value) {
            if (value instanceof String && !"".equals(((String)value).trim())) {
                String expressionText = DefaultLabelProvider.encodeEsacpedChars((String)value);
                IWatchExpression newExpression = DebugPlugin.getDefault().getExpressionManager().newWatchExpression(expressionText);
                DebugPlugin.getDefault().getExpressionManager().addExpression((IExpression)newExpression);
                newExpression.setExpressionContext(this.getContext());
            }
        }

        private IDebugElement getContext() {
            IAdaptable object = DebugUITools.getDebugContext();
            IDebugElement context = null;
            if (object instanceof IDebugElement) {
                context = (IDebugElement)object;
            } else if (object instanceof ILaunch) {
                context = ((ILaunch)object).getDebugTarget();
            }
            return context;
        }
    }
}

