/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui;

import org.eclipse.ant.internal.ui.AntUIImages;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.Point;

public class AntImageDescriptor
extends CompositeImageDescriptor {
    public static final int HAS_ERRORS = 1;
    public static final int IMPORTED = 2;
    public static final int HAS_WARNINGS = 4;
    private ImageDescriptor fBaseImage;
    private int fFlags;
    private Point fSize;

    public AntImageDescriptor(ImageDescriptor baseImage, int flags) {
        this.setBaseImage(baseImage);
        this.setFlags(flags);
    }

    protected Point getSize() {
        if (this.fSize == null) {
            CompositeImageDescriptor.CachedImageDataProvider provider = this.createCachedImageDataProvider(this.getBaseImage());
            this.setSize(new Point(provider.getWidth(), provider.getHeight()));
        }
        return this.fSize;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AntImageDescriptor)) {
            return false;
        }
        AntImageDescriptor other = (AntImageDescriptor)((Object)object);
        return this.getBaseImage().equals(other.getBaseImage()) && this.getFlags() == other.getFlags();
    }

    public int hashCode() {
        return this.getBaseImage().hashCode() | this.getFlags();
    }

    protected void drawCompositeImage(int width, int height) {
        this.drawImage((ImageDataProvider)this.createCachedImageDataProvider(this.getBaseImage()), 0, 0);
        this.drawOverlays();
    }

    protected void drawOverlays() {
        CompositeImageDescriptor.CachedImageDataProvider provider;
        int flags = this.getFlags();
        int y = 0;
        if ((flags & 2) != 0) {
            provider = this.createCachedImageDataProvider(AntUIImages.getImageDescriptor("org.eclipse.ant.ui.ovrImport"));
            this.drawImage((ImageDataProvider)provider, 0, 0);
        }
        if ((flags & 1) != 0) {
            y = this.getSize().y;
            provider = this.createCachedImageDataProvider(AntUIImages.getImageDescriptor("org.eclipse.ant.ui.ovrError"));
            this.drawImage((ImageDataProvider)provider, 0, y -= provider.getHeight());
        } else if ((flags & 4) != 0) {
            y = this.getSize().y;
            provider = this.createCachedImageDataProvider(AntUIImages.getImageDescriptor("org.eclipse.ant.ui.ovrWarning"));
            this.drawImage((ImageDataProvider)provider, 0, y -= provider.getHeight());
        }
    }

    protected ImageDescriptor getBaseImage() {
        return this.fBaseImage;
    }

    protected void setBaseImage(ImageDescriptor baseImage) {
        this.fBaseImage = baseImage;
    }

    protected int getFlags() {
        return this.fFlags;
    }

    protected void setFlags(int flags) {
        this.fFlags = flags;
    }

    protected void setSize(Point size) {
        this.fSize = size;
    }
}

