/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.utils;

import java.util.function.Consumer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;

public class DelegatingSelectionAdapter
extends SelectionAdapter {
    private final Consumer<SelectionEvent> selectedHandler;
    private final Consumer<SelectionEvent> defaultSelectedHandler;

    public DelegatingSelectionAdapter(Consumer<SelectionEvent> selectedHandler, Consumer<SelectionEvent> defaultSelectedHandler) {
        this.selectedHandler = selectedHandler != null ? selectedHandler : selectionEvent -> super.widgetSelected(selectionEvent);
        this.defaultSelectedHandler = defaultSelectedHandler != null ? defaultSelectedHandler : selectionEvent -> super.widgetDefaultSelected(selectionEvent);
    }

    public void widgetSelected(SelectionEvent e) {
        this.selectedHandler.accept(e);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.defaultSelectedHandler.accept(e);
    }

    public static DelegatingSelectionAdapter createSelectionListener(Consumer<SelectionEvent> handler) {
        return new DelegatingSelectionAdapter(handler, null);
    }

    public static DelegatingSelectionAdapter createDefaultSelectionListener(Consumer<SelectionEvent> handler) {
        return new DelegatingSelectionAdapter(null, handler);
    }
}

