/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.text;

import org.eclipse.xpect.text.CharSequences;
import org.eclipse.xpect.text.IRegion;

public class RegionToString {
    private IRegion region;
    private int vicinityChars = 16;

    public RegionToString with(IRegion region) {
        this.region = region;
        return this;
    }

    public RegionToString withVicinityChars(int vicinityChars) {
        this.vicinityChars = vicinityChars;
        return this;
    }

    public String toString() {
        CharSequence document = this.region.getDocument();
        int offset = this.region.getOffset();
        int end = offset + this.region.getLength();
        if (offset >= 0 && end <= document.length()) {
            String prefix = CharSequences.getPrefix(document, offset, this.vicinityChars);
            CharSequence infix = document.subSequence(offset, end);
            String postfix = CharSequences.getPostfix(document, end, this.vicinityChars);
            String result = prefix + ">>>" + infix + "<<<" + postfix;
            return result.replace("\n", "\\n");
        }
        return "Invalid Region! offset:" + offset + " end: " + end + " Document:" + document;
    }
}

