/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.n4js.generator.GeneratorOption;
import org.eclipse.n4js.generator.UnresolvedProxyInSubGeneratorException;
import org.eclipse.n4js.n4JS.ExportedVariableDeclaration;
import org.eclipse.n4js.n4JS.FunctionOrFieldAccessor;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.ImportSpecifier;
import org.eclipse.n4js.n4JS.JSXElementName;
import org.eclipse.n4js.n4JS.LocalArgumentsVariable;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.N4MemberDeclaration;
import org.eclipse.n4js.n4JS.N4TypeDeclaration;
import org.eclipse.n4js.n4JS.NamedElement;
import org.eclipse.n4js.n4JS.NamedImportSpecifier;
import org.eclipse.n4js.n4JS.NamespaceImportSpecifier;
import org.eclipse.n4js.n4JS.ParameterizedPropertyAccessExpression;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.n4JS.Variable;
import org.eclipse.n4js.n4idl.transpiler.utils.N4IDLTranspilerUtils;
import org.eclipse.n4js.n4idl.versioning.MigrationUtils;
import org.eclipse.n4js.n4idl.versioning.VersionHelper;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.transpiler.InformationRegistry;
import org.eclipse.n4js.transpiler.Tracer;
import org.eclipse.n4js.transpiler.TranspilerState;
import org.eclipse.n4js.transpiler.im.IdentifierRef_IM;
import org.eclipse.n4js.transpiler.im.ImFactory;
import org.eclipse.n4js.transpiler.im.ImPackage;
import org.eclipse.n4js.transpiler.im.ParameterizedPropertyAccessExpression_IM;
import org.eclipse.n4js.transpiler.im.ReferencingElement_IM;
import org.eclipse.n4js.transpiler.im.Script_IM;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryOriginal;
import org.eclipse.n4js.transpiler.im.VersionedNamedImportSpecifier_IM;
import org.eclipse.n4js.transpiler.operations.SymbolTableManagement;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRefsPackage;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.ModuleNamespaceVirtualType;
import org.eclipse.n4js.ts.types.SyntaxRelatedTElement;
import org.eclipse.n4js.ts.types.TExportableElement;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.TVersionable;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.utils.ContainerTypesHelper;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.Arrays;
import org.eclipse.xtext.util.LineAndColumn;

public class PreparationStep {
    private static final ImmutableMap<EClass, EClass> ECLASS_REPLACEMENT = ImmutableMap.builder().put((Object)N4JSPackage.eINSTANCE.getScript(), (Object)ImPackage.eINSTANCE.getScript_IM()).put((Object)N4JSPackage.eINSTANCE.getIdentifierRef(), (Object)ImPackage.eINSTANCE.getIdentifierRef_IM()).put((Object)N4JSPackage.eINSTANCE.getParameterizedPropertyAccessExpression(), (Object)ImPackage.eINSTANCE.getParameterizedPropertyAccessExpression_IM()).put((Object)N4JSPackage.eINSTANCE.getVersionedIdentifierRef(), (Object)ImPackage.eINSTANCE.getVersionedIdentifierRef_IM()).put((Object)TypeRefsPackage.eINSTANCE.getParameterizedTypeRef(), (Object)ImPackage.eINSTANCE.getParameterizedTypeRef_IM()).put((Object)TypeRefsPackage.eINSTANCE.getParameterizedTypeRefStructural(), (Object)ImPackage.eINSTANCE.getParameterizedTypeRefStructural_IM()).put((Object)TypeRefsPackage.eINSTANCE.getVersionedParameterizedTypeRef(), (Object)ImPackage.eINSTANCE.getVersionedParameterizedTypeRef_IM()).put((Object)TypeRefsPackage.eINSTANCE.getVersionedParameterizedTypeRefStructural(), (Object)ImPackage.eINSTANCE.getVersionedParameterizedTypeRefStructural_IM()).build();
    private static final EReference[] REWIRED_REFERENCES = new EReference[]{N4JSPackage.eINSTANCE.getIdentifierRef_Id(), N4JSPackage.eINSTANCE.getParameterizedPropertyAccessExpression_Property(), TypeRefsPackage.eINSTANCE.getParameterizedTypeRef_DeclaredType()};
    @Inject
    private IN4JSCore n4jsCore;
    @Inject
    private ContainerTypesHelper containerTypesHelper;
    @Inject
    private VersionHelper versionHelper;

    public TranspilerState prepare(Script script, GeneratorOption[] options) {
        N4JSResource resource = (N4JSResource)script.eResource();
        IN4JSProject project = (IN4JSProject)this.n4jsCore.findProject(resource.getURI()).orNull();
        ContainerTypesHelper.MemberCollector memberCollector = this.containerTypesHelper.fromContext((Resource)resource);
        Tracer tracer = new Tracer();
        InformationRegistry info = new InformationRegistry();
        TranspilerState.STECache steCache = this.createIM(script, tracer, info);
        return new TranspilerState(resource, project, options, memberCollector, steCache.im, steCache, tracer, info);
    }

    private TranspilerState.STECache createIM(Script script, Tracer tracer, InformationRegistry info) {
        TranspilerState.STECache steCache;
        AST2IMCopier copier = new AST2IMCopier(script, tracer, info);
        EObject result = copier.copy((EObject)script);
        copier.steCache = steCache = new TranspilerState.STECache((Script_IM)result);
        copier.copyReferences();
        copier.createRemainingSymbolTableEntries();
        return steCache;
    }

    <T extends EObject> T copyForIM(TranspilerState state, T someASTNode) {
        AST2IMCopier copier = new AST2IMCopier(state);
        EObject result = copier.copy(someASTNode);
        copier.copyReferences();
        EObject resultCasted = result;
        return (T)resultCasted;
    }

    private static final IdentifiableElement getOriginalTargetOfNodeToRewire(EObject nodeInOriginalAST) {
        if (nodeInOriginalAST instanceof IdentifierRef) {
            return ((IdentifierRef)nodeInOriginalAST).getId();
        }
        if (nodeInOriginalAST instanceof ParameterizedPropertyAccessExpression) {
            return ((ParameterizedPropertyAccessExpression)nodeInOriginalAST).getProperty();
        }
        if (nodeInOriginalAST instanceof ParameterizedTypeRef) {
            return ((ParameterizedTypeRef)nodeInOriginalAST).getDeclaredType();
        }
        throw new IllegalArgumentException("not an AST node that requires rewiring: " + nodeInOriginalAST);
    }

    private final class AST2IMCopier
    extends EcoreUtil.Copier {
        private final Tracer tracer;
        private final InformationRegistry info;
        private final Script script;
        private Script_IM script_IM;
        private TranspilerState.STECache steCache;
        private final Map<IdentifiableElement, NamedImportSpecifier> importedElements;
        private final Map<TModule, NamespaceImportSpecifier> importedModules;

        public AST2IMCopier(Script script, Tracer tracer, InformationRegistry info) {
            super(true, false);
            this.importedElements = new HashMap<IdentifiableElement, NamedImportSpecifier>();
            this.importedModules = new HashMap<TModule, NamespaceImportSpecifier>();
            if (!tracer.isEmpty()) {
                throw new IllegalArgumentException("so far, IMCopier assumes given tracer to be empty; if that is not desired, please refactor");
            }
            this.script = script;
            this.tracer = tracer;
            this.info = info;
        }

        public AST2IMCopier(TranspilerState state) {
            super(true, false);
            this.importedElements = new HashMap<IdentifiableElement, NamedImportSpecifier>();
            this.importedModules = new HashMap<TModule, NamespaceImportSpecifier>();
            this.script = (Script)state.tracer.getOriginalASTNode((EObject)state.im);
            this.tracer = state.tracer;
            this.info = state.info;
            this.script_IM = state.im;
            this.steCache = state.steCache;
        }

        private void initializeScript_IM(Script_IM sim) {
            if (this.script_IM != null) {
                throw new IllegalStateException("script copied twice");
            }
            this.script_IM = sim;
            this.script_IM.setSymbolTable(ImFactory.eINSTANCE.createSymbolTable());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected EObject createCopy(EObject eObject) {
            EObject copy = super.createCopy(eObject);
            this.tracer.setOriginalASTNode_internal(copy, eObject);
            if (copy instanceof Script_IM) {
                this.initializeScript_IM((Script_IM)copy);
                return copy;
            } else if (copy instanceof ImportDeclaration) {
                this.info.setImportedModule_internal((ImportDeclaration)copy, ((ImportDeclaration)eObject).getModule());
                return copy;
            } else if (copy instanceof ImportSpecifier) {
                if (copy instanceof NamedImportSpecifier) {
                    this.handleCopyNamedImportSpecifier((NamedImportSpecifier)eObject);
                    return copy;
                } else {
                    if (!(copy instanceof NamespaceImportSpecifier)) throw new IllegalStateException("unsupported sub-class of ImportSpecifier: " + copy.eClass());
                    this.importedModules.put(((ImportDeclaration)eObject.eContainer()).getModule(), (NamespaceImportSpecifier)eObject);
                }
                return copy;
            } else if (copy instanceof N4TypeDeclaration) {
                this.info.setOriginalDefinedType_internal((N4TypeDeclaration)copy, ((N4TypeDeclaration)eObject).getDefinedType());
                return copy;
            } else {
                if (!(copy instanceof N4MemberDeclaration)) return copy;
                this.info.setOriginalDefinedMember_internal((N4MemberDeclaration)copy, ((N4MemberDeclaration)eObject).getDefinedTypeElement());
            }
            return copy;
        }

        protected EClass getTarget(EClass eClass) {
            EClass replacement = (EClass)ECLASS_REPLACEMENT.get((Object)eClass);
            return replacement != null ? replacement : super.getTarget(eClass);
        }

        protected EClass getTarget(EObject eObject) {
            if (eObject instanceof NamedImportSpecifier && N4IDLTranspilerUtils.isVersionedImportSpecifier((NamedImportSpecifier)eObject)) {
                return ImPackage.eINSTANCE.getVersionedNamedImportSpecifier_IM();
            }
            return super.getTarget(eObject);
        }

        protected void copyReference(EReference eReference, EObject eObject, EObject copyEObject) {
            boolean needsRewiring = Arrays.contains((Object[])REWIRED_REFERENCES, (Object)eReference);
            if (needsRewiring) {
                if (!(copyEObject instanceof ReferencingElement_IM)) {
                    throw new IllegalStateException("an EObject with a cross-reference that requires rewiring must have a copy of type ReferencingElement_IM;\nin object: " + eObject + "\nin resource: " + eObject.eResource().getURI());
                }
                this.rewire(eObject, (ReferencingElement_IM)copyEObject);
            } else {
                super.copyReference(eReference, eObject, copyEObject);
            }
        }

        private void createRemainingSymbolTableEntries() {
            TreeIterator iter1 = this.script.getModule().eAllContents();
            while (iter1.hasNext()) {
                EObject obj = (EObject)iter1.next();
                if (!(obj instanceof IdentifiableElement)) continue;
                this.getSymbolTableEntry((IdentifiableElement)obj, true);
            }
            TreeIterator iter2 = this.script.eAllContents();
            while (iter2.hasNext()) {
                boolean isExported;
                EObject obj = (EObject)iter2.next();
                if (!(obj instanceof Variable) || (isExported = obj instanceof ExportedVariableDeclaration)) continue;
                this.getSymbolTableEntry((IdentifiableElement)((Variable)obj), true);
            }
        }

        private void handleCopyNamedImportSpecifier(NamedImportSpecifier namedImportSpecifier) {
            TExportableElement importedElement = namedImportSpecifier.getImportedElement();
            if (importedElement instanceof Type) {
                Iterable versions = PreparationStep.this.versionHelper.findTypeVersions((Type)importedElement);
                versions.forEach(v -> this.importedElements.put((IdentifiableElement)v, namedImportSpecifier));
            } else {
                this.importedElements.put((IdentifiableElement)importedElement, namedImportSpecifier);
            }
        }

        private void rewire(EObject eObject, ReferencingElement_IM copyEObject) {
            IdentifiableElement originalTarget = PreparationStep.getOriginalTargetOfNodeToRewire(eObject);
            if (!originalTarget.eIsProxy()) {
                SymbolTableEntryOriginal rewiredTarget = this.getSymbolTableEntry(originalTarget, true);
                copyEObject.setRewiredTarget(rewiredTarget);
            } else if (eObject instanceof ParameterizedPropertyAccessExpression) {
                String propName = this.getPropertyAsString((ParameterizedPropertyAccessExpression)eObject);
                ((ParameterizedPropertyAccessExpression_IM)copyEObject).setAnyPlusAccess(true);
                ((ParameterizedPropertyAccessExpression_IM)copyEObject).setNameOfAnyPlusProperty(propName);
            } else if (!this.isDynamicNamespaceReference(eObject)) {
                if (eObject instanceof IdentifierRef && eObject.eContainer() instanceof JSXElementName) {
                    String tagName = ((IdentifierRef)eObject).getIdAsText();
                    ((IdentifierRef_IM)copyEObject).setIdAsText(tagName);
                } else if (!MigrationUtils.isMigrateCall((EObject)eObject.eContainer())) {
                    ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)eObject);
                    LineAndColumn pos = NodeModelUtils.getLineAndColumn((INode)node, (int)node.getOffset());
                    throw new UnresolvedProxyInSubGeneratorException(eObject.eResource(), pos.getLine(), pos.getColumn());
                }
            }
        }

        private boolean isDynamicNamespaceReference(EObject eObject) {
            ParameterizedTypeRef ptr;
            ModuleNamespaceVirtualType astNamespace;
            if (eObject instanceof ParameterizedTypeRef && (astNamespace = (ptr = (ParameterizedTypeRef)eObject).getAstNamespace()) != null) {
                return astNamespace.isDeclaredDynamic();
            }
            return false;
        }

        private SymbolTableEntryOriginal getSymbolTableEntry(IdentifiableElement elem, boolean create) {
            SymbolTableEntryOriginal e = this.steCache.mapOriginal.get(elem);
            if (e != null) {
                return e;
            }
            if (create) {
                String versionedName = N4IDLTranspilerUtils.getVersionedInternalName(elem);
                return this.createSymbolTableEntry(versionedName, elem);
            }
            return null;
        }

        private SymbolTableEntryOriginal createSymbolTableEntry(String name, IdentifiableElement elem) {
            EObject copy;
            SymbolTableEntryOriginal entry = ImFactory.eINSTANCE.createSymbolTableEntryOriginal();
            entry.setName(name);
            entry.setOriginalTarget(elem);
            if (elem instanceof Variable) {
                EObject copy2 = this.getCopyOf((EObject)elem);
                entry.getElementsOfThisName().add((Object)((Variable)copy2));
            } else {
                EObject astElement = this.getASTElementIfInSameResource(elem);
                if (astElement instanceof NamespaceImportSpecifier) {
                    copy = this.getCopyOf(astElement);
                    entry.setImportSpecifier((ImportSpecifier)((NamespaceImportSpecifier)copy));
                } else if (astElement instanceof NamedElement) {
                    copy = this.getCopyOf(astElement);
                    entry.getElementsOfThisName().add((Object)((NamedElement)copy));
                }
            }
            ImportSpecifier impSpec = this.getImportSpecifierForImportedElement(elem);
            if (impSpec != null) {
                copy = this.getCopyOf((EObject)impSpec);
                entry.setImportSpecifier((ImportSpecifier)copy);
                if (impSpec instanceof NamedImportSpecifier) {
                    String alias = ((NamedImportSpecifier)impSpec).getAlias();
                    if (alias != null) {
                        entry.setName(alias);
                    }
                    if (N4IDLTranspilerUtils.refersToVersionedType(entry)) {
                        ((VersionedNamedImportSpecifier_IM)copy).getImportedTypeVersions().add((Object)entry);
                        if (alias != null) {
                            entry.setName(N4IDLTranspilerUtils.getVersionedInternalAlias(entry.getName(), (TVersionable)entry.getOriginalTarget()));
                        }
                    }
                }
            }
            SymbolTableManagement.addOriginal(this.steCache, entry);
            return entry;
        }

        private final EObject getASTElementIfInSameResource(IdentifiableElement elem) {
            if (elem instanceof SyntaxRelatedTElement && elem.eResource() == this.script.eResource()) {
                return ((SyntaxRelatedTElement)elem).getAstElement();
            }
            return null;
        }

        private final ImportSpecifier getImportSpecifierForImportedElement(IdentifiableElement element) {
            TModule module;
            ImportSpecifier impSpec = (ImportSpecifier)this.importedElements.get(element);
            if (impSpec == null && (module = (TModule)EcoreUtil2.getContainerOfType((EObject)element, TModule.class)) != null) {
                impSpec = (ImportSpecifier)this.importedModules.get(module);
            }
            return impSpec;
        }

        private String getPropertyAsString(ParameterizedPropertyAccessExpression propAccessExpr) {
            StringBuilder sb = new StringBuilder();
            for (INode node : NodeModelUtils.findNodesForFeature((EObject)propAccessExpr, (EStructuralFeature)N4JSPackage.eINSTANCE.getParameterizedPropertyAccessExpression_Property())) {
                sb.append(NodeModelUtils.getTokenText((INode)node));
            }
            return sb.toString();
        }

        private final EObject getCopyOf(EObject obj) {
            EObject copy;
            Iterator<EObject> iterator = this.tracer.getIntermediateModelElements(obj).iterator();
            EObject eObject = copy = iterator.hasNext() ? iterator.next() : null;
            if (copy == null && obj instanceof LocalArgumentsVariable) {
                LocalArgumentsVariable lav = ((FunctionOrFieldAccessor)this.getCopyOf(obj.eContainer())).getLocalArgumentsVariable();
                this.tracer.setOriginalASTNode_internal((EObject)lav, obj);
                return lav;
            }
            if (copy == null) {
                throw new IllegalStateException("copy of given object has not been created yet: " + obj);
            }
            return copy;
        }
    }
}

