/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.building.instructions;

import com.google.common.collect.Sets;
import com.google.inject.Injector;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.generator.GeneratorException;
import org.eclipse.n4js.generator.ICompositeGenerator;
import org.eclipse.n4js.internal.RaceDetectionHelper;
import org.eclipse.n4js.ui.building.instructions.AbstractBuildParticipantInstruction;
import org.eclipse.n4js.ui.generator.GeneratorMarkerSupport;
import org.eclipse.n4js.ui.internal.N4JSActivator;
import org.eclipse.xtext.builder.EclipseResourceFileSystemAccess2;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.ui.generator.IDerivedResourceMarkers;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.util.Pair;

public class BuildInstruction
extends AbstractBuildParticipantInstruction {
    private static final Logger logger = Logger.getLogger(BuildInstruction.class);
    private final EclipseResourceFileSystemAccess2 access;
    private final Map<OutputConfiguration, Iterable<IMarker>> generatorMarkers;
    private final IStorage2UriMapper storage2UriMapper;
    private final Injector injector;
    private final Set<IFile> derivedResources = Sets.newLinkedHashSet();
    private final ICompositeGenerator compositeGenerator;

    public BuildInstruction(IProject project, Map<String, OutputConfiguration> outputConfigurations, IDerivedResourceMarkers derivedResourceMarkers, EclipseResourceFileSystemAccess2 access, Map<OutputConfiguration, Iterable<IMarker>> generatorMarkers, IStorage2UriMapper storage2UriMapper, ICompositeGenerator compositeGenerator, Injector injector) {
        super(project, outputConfigurations, derivedResourceMarkers);
        this.access = access;
        this.generatorMarkers = generatorMarkers;
        this.storage2UriMapper = storage2UriMapper;
        this.compositeGenerator = compositeGenerator;
        this.injector = injector;
    }

    @Override
    public void finish(List<IResourceDescription.Delta> deltas, IProgressMonitor progressMonitor) throws CoreException {
        for (IResourceDescription.Delta delta : deltas) {
            if (delta.getNew() != null) continue;
            String uri = delta.getUri().toString();
            this.recordDerivedResources(uri);
            this.deleteObsoleteResources(uri, progressMonitor);
        }
        this.deleteEmptyDirectories(progressMonitor);
    }

    @Override
    public void process(IResourceDescription.Delta delta, ResourceSet resourceSet, IProgressMonitor progressMonitor) throws CoreException {
        this.access.setMonitor(progressMonitor);
        final String uri = delta.getUri().toString();
        this.recordDerivedResources(uri);
        this.access.setPostProcessor(new EclipseResourceFileSystemAccess2.IFileCallback(){

            public boolean beforeFileDeletion(IFile file) {
                BuildInstruction.this.derivedResources.remove(file);
                BuildInstruction.this.needRebuild();
                RaceDetectionHelper.log((String)"beforeFileDeletion: %s", (Object)file);
                return true;
            }

            public void afterFileUpdate(IFile file) {
                RaceDetectionHelper.log((String)"afterFileUpdate: %s", (Object)file);
                this.handleFileAccess(file);
            }

            public void afterFileCreation(IFile file) {
                RaceDetectionHelper.log((String)"afterFileCreation: %s", (Object)file);
                this.handleFileAccess(file);
            }

            protected void handleFileAccess(IFile file) {
                try {
                    BuildInstruction.this.derivedResources.remove(file);
                    BuildInstruction.this.derivedResourceMarkers.installMarker(file, uri);
                    BuildInstruction.this.needRebuild();
                }
                catch (CoreException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        if (delta.getNew() != null) {
            try {
                RaceDetectionHelper.log((String)"About to handleChangedContents of %s", (Object)delta.getUri());
                this.handleChangedContents(delta, this.project, resourceSet);
                RaceDetectionHelper.log((String)"Did handleChangedContents of %s", (Object)delta.getUri());
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                logger.error((Object)("Error during compilation of '" + delta.getUri() + "'."), (Throwable)e);
            }
        }
        this.access.flushSourceTraces();
        this.deleteObsoleteResources(uri, progressMonitor);
    }

    private void deleteEmptyDirectories(IProgressMonitor progressMonitor) throws CoreException {
        for (OutputConfiguration config : this.outputConfigurations.values()) {
            IFolder folder;
            if (".".equals(config.getOutputDirectory()) || (folder = this.project.getFolder(config.getOutputDirectory())) == null || !folder.exists()) continue;
            this.deleteEmptyDirectories(folder, progressMonitor);
            folder.getParent().refreshLocal(2, progressMonitor);
        }
    }

    private void deleteObsoleteResources(String uri, IProgressMonitor progressMonitor) throws CoreException {
        SubMonitor deleteMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)this.derivedResources.size());
        for (IFile iFile : Sets.newLinkedHashSet(this.derivedResources)) {
            IMarker marker = this.derivedResourceMarkers.findDerivedResourceMarker(iFile, uri);
            if (marker != null) {
                marker.delete();
            }
            if (this.derivedResourceMarkers.findDerivedResourceMarkers((IResource)iFile).length != 0) continue;
            for (String outputName : this.outputConfigurations.keySet()) {
                this.access.deleteFile(iFile, outputName, (IProgressMonitor)deleteMonitor);
            }
            this.needRebuild();
        }
    }

    private void recordDerivedResources(String uri) {
        for (OutputConfiguration config : this.outputConfigurations.values()) {
            Iterable<IMarker> markers;
            if (!config.isCleanUpDerivedResources() || (markers = this.generatorMarkers.get(config)) == null) continue;
            for (IMarker marker : markers) {
                String source = this.derivedResourceMarkers.getSource(marker);
                if (source == null || !source.equals(uri)) continue;
                this.derivedResources.add((IFile)marker.getResource());
            }
        }
    }

    private void deleteEmptyDirectories(IFolder folder, IProgressMonitor progressMonitor) throws CoreException {
        IResource[] iResourceArray = folder.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource member = iResourceArray[n2];
            if (member instanceof IFolder) {
                this.deleteEmptyDirectories((IFolder)member, progressMonitor);
            }
            ++n2;
        }
        if (folder.members().length == 0) {
            folder.delete(true, progressMonitor);
        }
    }

    private void handleChangedContents(IResourceDescription.Delta delta, IProject aProject, ResourceSet resourceSet) throws CoreException {
        Resource resource = resourceSet.getResource(delta.getUri(), true);
        if (this.shouldGenerate(resource, aProject)) {
            try {
                this.compositeGenerator.doGenerate(resource, (IFileSystemAccess)this.access);
            }
            catch (RuntimeException e) {
                if (e instanceof GeneratorException) {
                    N4JSActivator.getInstance().getLog().log((IStatus)new Status(4, N4JSActivator.getInstance().getBundle().getSymbolicName(), e.getMessage(), e.getCause()));
                }
                if (e.getCause() instanceof CoreException) {
                    throw (CoreException)e.getCause();
                }
                throw e;
            }
        }
    }

    private boolean shouldGenerate(Resource resource, IProject aProject) {
        try {
            Iterable storages = this.storage2UriMapper.getStorages(resource.getURI());
            for (Pair pair : storages) {
                if (!(pair.getFirst() instanceof IFile) || !((IProject)pair.getSecond()).equals((Object)aProject)) continue;
                IFile file = (IFile)pair.getFirst();
                int findMaxProblemSeverity = file.findMaxProblemSeverity(null, true, 2);
                if (findMaxProblemSeverity == 2) {
                    GeneratorMarkerSupport generatorMarkerSupport = (GeneratorMarkerSupport)this.injector.getInstance(GeneratorMarkerSupport.class);
                    generatorMarkerSupport.deleteMarker(resource);
                    findMaxProblemSeverity = file.findMaxProblemSeverity(null, true, 2);
                }
                return findMaxProblemSeverity != 2;
            }
            return false;
        }
        catch (CoreException exc) {
            throw new WrappedException((Exception)((Object)exc));
        }
    }
}

