/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.core;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy2;
import org.eclipse.debug.internal.core.DebugCoreMessages;

public class NullStreamsProxy
implements IStreamsProxy2 {
    private NullStreamMonitor outputStreamMonitor;
    private NullStreamMonitor errorStreamMonitor;

    public NullStreamsProxy(Process process) {
        this.outputStreamMonitor = new NullStreamMonitor(process.getInputStream());
        this.errorStreamMonitor = new NullStreamMonitor(process.getErrorStream());
    }

    @Override
    public void closeInputStream() throws IOException {
    }

    @Override
    public IStreamMonitor getErrorStreamMonitor() {
        return this.errorStreamMonitor;
    }

    @Override
    public IStreamMonitor getOutputStreamMonitor() {
        return this.outputStreamMonitor;
    }

    @Override
    public void write(String input) throws IOException {
    }

    private class NullStreamMonitor
    implements IStreamMonitor {
        private InputStream fStream;

        public NullStreamMonitor(InputStream stream) {
            this.fStream = stream;
            this.startReaderThread();
        }

        private void startReaderThread() {
            Thread thread = new Thread(() -> {
                byte[] bytes = new byte[1024];
                try {
                    while (this.fStream.read(bytes) >= 0) {
                    }
                }
                catch (IOException iOException) {}
            }, DebugCoreMessages.NullStreamsProxy_0);
            thread.setDaemon(true);
            thread.start();
        }

        @Override
        public void addListener(IStreamListener listener) {
        }

        @Override
        public String getContents() {
            return "";
        }

        @Override
        public void removeListener(IStreamListener listener) {
        }
    }
}

