/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils;

import java.util.ArrayList;
import java.util.List;

public class MemoryTracker {
    private static final Runtime RUNTIME = Runtime.getRuntime();
    private final List<List<Long>> usedMemory = new ArrayList<List<Long>>();
    private final List<List<String>> labels = new ArrayList<List<String>>();
    private final boolean recordData;
    private final boolean verbose;
    private int counter = -1;
    private int longestLabel = 0;

    public MemoryTracker() {
        this(true, false);
    }

    public MemoryTracker(boolean recordData) {
        this(recordData, false);
    }

    public MemoryTracker(boolean recordData, boolean verbose) {
        this.recordData = recordData;
        this.verbose = verbose;
    }

    public void startSeries(String label) {
        if (!this.recordData) {
            return;
        }
        this.usedMemory.add(new ArrayList());
        this.labels.add(new ArrayList());
        ++this.counter;
        this.recordMemoryData(label);
    }

    public void addSeriesPoint(String label) {
        if (!this.recordData) {
            return;
        }
        this.recordMemoryData(label);
    }

    private void recordMemoryData(String label) {
        this.usedMemory.get(this.counter).add(MemoryTracker.getUsedMemory());
        this.labels.get(this.counter).add(label);
        if (label.length() > this.longestLabel) {
            this.longestLabel = label.length();
        }
        if (this.verbose) {
            List<String> seriesLabels = this.labels.get(this.counter);
            List<Long> seriesUsed = this.usedMemory.get(this.counter);
            StringBuilder sb = new StringBuilder("\nrecording memory " + seriesLabels.get(0));
            int current = seriesUsed.size() - 1;
            int prevPoint = current > 1 ? current - 1 : 0;
            sb.append(String.format("\n| %s | %s | %s |", this.formatLabel(" mem diff"), MemoryTracker.formatMemory("used delta"), MemoryTracker.formatMemory("used total")));
            sb.append(String.format("\n| %s | %s | %s |", this.formatLabel(" " + label), MemoryTracker.formatMemory(MemoryTracker.bytesToHuman(seriesUsed.get(current) - seriesUsed.get(prevPoint))), MemoryTracker.formatMemory(MemoryTracker.bytesToHuman(seriesUsed.get(current)))));
            System.out.println(sb);
        }
    }

    public String dataTable() {
        if (this.counter < 0) {
            return "no memory data recorded";
        }
        StringBuilder sb = new StringBuilder("\n");
        long pUsed = 0L;
        int series = 0;
        int points = 0;
        int point = 0;
        while (series <= this.counter) {
            List<String> seriesLabels = this.labels.get(series);
            List<Long> seriesUsed = this.usedMemory.get(series);
            points = seriesLabels.size();
            sb.append(String.format("\n| %s | %s | %s |", this.formatLabel(seriesLabels.get(0)), MemoryTracker.formatMemory("used delta"), MemoryTracker.formatMemory("used total")));
            sb.append(String.format("\n| %s | %s | %s |", this.formatLabel(" mem diff"), MemoryTracker.formatMemory(MemoryTracker.bytesToHuman(seriesUsed.get(points - 1) - seriesUsed.get(0))), MemoryTracker.formatMemory(MemoryTracker.bytesToHuman(seriesUsed.get(points - 1)))));
            sb.append(String.format("\n    | %s | %s | %s |", this.formatLabel("details"), MemoryTracker.formatMemory("used delta"), MemoryTracker.formatMemory("used total")));
            while (point < points) {
                long used = seriesUsed.get(point);
                sb.append(String.format("\n    | %s | %s | %s |", this.formatLabel(seriesLabels.get(point)), MemoryTracker.formatMemory(MemoryTracker.bytesToHuman(used - pUsed)), MemoryTracker.formatMemory(MemoryTracker.bytesToHuman(used))));
                pUsed = used;
                ++point;
            }
            sb.append("\n");
            point = 0;
            ++series;
        }
        return sb.toString();
    }

    public static void printCurrentMemoryUsage(String label) {
        System.out.println(String.format("| %s | %s |", MemoryTracker.formatLabelToWidth(" " + label, label.length() + 2), MemoryTracker.formatMemory(MemoryTracker.bytesToHuman(MemoryTracker.getUsedMemory()))));
    }

    public static void runGC() {
        Runtime.getRuntime().runFinalization();
        Runtime.getRuntime().gc();
        Thread.yield();
    }

    private static long getUsedMemory() {
        return RUNTIME.totalMemory() - RUNTIME.freeMemory();
    }

    private String formatLabel(String label) {
        return MemoryTracker.formatLabelToWidth(label, this.longestLabel);
    }

    private static String formatLabelToWidth(String label, int width) {
        return String.format("%1$-" + width + "s", label);
    }

    private static String formatMemory(String mem) {
        return String.format("%1$10s", mem);
    }

    private static String bytesToHuman(long value) {
        long abs = Math.abs(value);
        if (abs < 1024L) {
            return String.valueOf(value) + " B";
        }
        int z = (63 - Long.numberOfLeadingZeros(abs)) / 10;
        return String.format("%.1f %sB", (double)value / (double)(1L << z * 10), Character.valueOf(" KMGTPE".charAt(z)));
    }
}

