/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.workingsets.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.n4js.ui.ImageDescriptorCache;
import org.eclipse.n4js.ui.workingsets.WorkingSet;
import org.eclipse.n4js.ui.workingsets.WorkingSetDiffBuilder;
import org.eclipse.n4js.ui.workingsets.WorkingSetManager;
import org.eclipse.n4js.utils.Diff;
import org.eclipse.n4js.utils.collections.Arrays2;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.SelectionListenerAction;

public class HideWorkingSetAction
extends SelectionListenerAction
implements ActionFactory.IWorkbenchAction {
    public HideWorkingSetAction() {
        super("Hide Selected Working Set");
        this.setImageDescriptor((ImageDescriptor)ImageDescriptorCache.ImageRef.CLEAR.asImageDescriptor().orNull());
    }

    public void run() {
        IStructuredSelection selection = this.getStructuredSelection();
        Object[] selectionElements = selection.toArray();
        WorkingSet[] selectedWorkingSets = (WorkingSet[])Arrays2.filter((Object[])selectionElements, WorkingSet.class);
        WorkingSetManager manager = selectedWorkingSets[0].getWorkingSetManager();
        WorkingSetDiffBuilder builder = new WorkingSetDiffBuilder(manager);
        Object[] newAllItems = manager.getAllWorkingSets();
        ArrayList newItems = Lists.newArrayList((Object[])manager.getWorkingSets());
        WorkingSet[] workingSetArray = selectedWorkingSets;
        int n = selectedWorkingSets.length;
        int n2 = 0;
        while (n2 < n) {
            WorkingSet toHide = workingSetArray[n2];
            newItems.remove(toHide);
            ++n2;
        }
        Diff diff = builder.build((WorkingSet[])Iterables.toArray((Iterable)newItems, WorkingSet.class), newAllItems);
        if (!diff.isEmpty()) {
            manager.updateState((Diff<WorkingSet>)diff);
            manager.saveState((IProgressMonitor)new NullProgressMonitor());
            manager.getWorkingSetManagerBroker().refreshNavigator();
        }
    }

    public void dispose() {
    }

    @VisibleForTesting
    public boolean updateSelection(IStructuredSelection selection) {
        WorkingSet[] selectedWorkingSets;
        if (selection == null || selection.isEmpty()) {
            return false;
        }
        Object[] selectionElements = selection.toArray();
        if (selectionElements.length != (selectedWorkingSets = (WorkingSet[])Arrays2.filter((Object[])selectionElements, WorkingSet.class)).length) {
            return false;
        }
        WorkingSetManager manager = selectedWorkingSets[0].getWorkingSetManager();
        return manager.getWorkingSets().length > selectedWorkingSets.length;
    }
}

