/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.organize.imports;

import com.google.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.n4js.organize.imports.FileContainerFilter;
import org.eclipse.n4js.organize.imports.FileExtensionFilter;
import org.eclipse.n4js.ui.organize.imports.ErrorDialogWithStackTraceUtil;
import org.eclipse.n4js.ui.organize.imports.Interaction;
import org.eclipse.n4js.ui.organize.imports.OrganizeImportsService;
import org.eclipse.n4js.ui.organize.imports.SelectionFilesCollector;
import org.eclipse.n4js.ui.utils.AutobuildUtils;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;

public class N4JSOrganizeImportsHandler
extends AbstractHandler {
    private static final Logger LOGGER = Logger.getLogger(N4JSOrganizeImportsHandler.class);
    @Inject
    private FileExtensionFilter extensionFilter;
    @Inject
    private FileContainerFilter containerFilter;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        boolean nonEmptyStructuredSelection;
        Collection callingMenus = HandlerUtil.getActiveMenus((ExecutionEvent)event);
        boolean fromTextContext = callingMenus != null && callingMenus.contains("#TextEditorContext");
        boolean fromShortCut = callingMenus == null || callingMenus.isEmpty();
        XtextEditor editor = EditorUtils.getActiveXtextEditor((ExecutionEvent)event);
        boolean haveActiveEditor = editor != null;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        boolean bl = nonEmptyStructuredSelection = selection != null && selection instanceof IStructuredSelection && !selection.isEmpty();
        if (haveActiveEditor && (fromTextContext || fromShortCut)) {
            OrganizeImportsService.organizeImportsInEditor(editor, Interaction.queryUser);
            return null;
        }
        if (!nonEmptyStructuredSelection) return null;
        SelectionFilesCollector filesCollector = new SelectionFilesCollector(this::filter);
        List<IFile> collectedFiles = filesCollector.collectFiles((IStructuredSelection)selection);
        if (collectedFiles.isEmpty()) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var13_15 = null;
            try (AutobuildUtils.ClosableAutobuild ca = AutobuildUtils.suppressAutobuild();){
                IWorkbench wbench = PlatformUI.getWorkbench();
                IWorkbenchWindow activeWorkbenchWindow = wbench.getActiveWorkbenchWindow();
                boolean allSaved = wbench.saveAll((IShellProvider)activeWorkbenchWindow, (IRunnableContext)activeWorkbenchWindow, null, true);
                if (!allSaved) {
                    LOGGER.warn((Object)"Optimize imports cannot save editors, aborting.");
                    return null;
                }
                this.batchOrganize(HandlerUtil.getActiveShell((ExecutionEvent)event), collectedFiles);
                return null;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (InvocationTargetException e) {
            throw new ExecutionException("Error during organizing imports", (Throwable)e);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    private boolean filter(IFile iFile) {
        return this.extensionFilter.test(iFile) && this.containerFilter.test(iFile);
    }

    private void batchOrganize(Shell shell, List<IFile> collectedFiles) throws InvocationTargetException, InterruptedException {
        new ProgressMonitorDialog(shell).run(true, true, this.createOrganizingRunnable(collectedFiles));
    }

    private IRunnableWithProgress createOrganizingRunnable(final List<IFile> collectedFiles) {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor mon) throws InvocationTargetException, InterruptedException {
                int totalWork = collectedFiles.size();
                SubMonitor subMon = SubMonitor.convert((IProgressMonitor)mon, (String)"Organize imports.", (int)totalWork);
                int i = 0;
                while (!subMon.isCanceled() && i < totalWork) {
                    block4: {
                        IFile currentFile = (IFile)collectedFiles.get(i);
                        subMon.setTaskName("Organize imports. - File (" + (i + 1) + " of " + totalWork + ")");
                        try {
                            OrganizeImportsService.organizeImportsInFile(currentFile, Interaction.breakBuild, subMon);
                        }
                        catch (RuntimeException | CoreException e) {
                            String msg = "Exception in file " + currentFile.getFullPath().toString() + ".";
                            LOGGER.error((Object)msg, e);
                            boolean errorDialogShowed = ErrorDialogWithStackTraceUtil.showErrorDialogWithStackTrace(String.valueOf(msg) + " Hit OK to continue.", e);
                            if (errorDialogShowed) break block4;
                            throw new InvocationTargetException(e);
                        }
                    }
                    ++i;
                }
                if (subMon.isCanceled()) {
                    throw new InterruptedException();
                }
            }
        };
        return op;
    }
}

