/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation.validators;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.compileTime.CompileTimeEvaluationError;
import org.eclipse.n4js.compileTime.CompileTimeEvaluator;
import org.eclipse.n4js.compileTime.CompileTimeValue;
import org.eclipse.n4js.n4JS.AdditiveExpression;
import org.eclipse.n4js.n4JS.AdditiveOperator;
import org.eclipse.n4js.n4JS.Argument;
import org.eclipse.n4js.n4JS.ArrayElement;
import org.eclipse.n4js.n4JS.ArrayLiteral;
import org.eclipse.n4js.n4JS.ArrowFunction;
import org.eclipse.n4js.n4JS.AssignmentExpression;
import org.eclipse.n4js.n4JS.AwaitExpression;
import org.eclipse.n4js.n4JS.BinaryLogicalExpression;
import org.eclipse.n4js.n4JS.BooleanLiteral;
import org.eclipse.n4js.n4JS.CastExpression;
import org.eclipse.n4js.n4JS.ConditionalExpression;
import org.eclipse.n4js.n4JS.EqualityExpression;
import org.eclipse.n4js.n4JS.EqualityOperator;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ExpressionStatement;
import org.eclipse.n4js.n4JS.FunctionDefinition;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.n4JS.IndexedAccessExpression;
import org.eclipse.n4js.n4JS.LiteralOrComputedPropertyName;
import org.eclipse.n4js.n4JS.MemberAccess;
import org.eclipse.n4js.n4JS.MultiplicativeExpression;
import org.eclipse.n4js.n4JS.N4FieldDeclaration;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.N4MemberDeclaration;
import org.eclipse.n4js.n4JS.N4MethodDeclaration;
import org.eclipse.n4js.n4JS.NewExpression;
import org.eclipse.n4js.n4JS.NumericLiteral;
import org.eclipse.n4js.n4JS.ObjectLiteral;
import org.eclipse.n4js.n4JS.ParameterizedCallExpression;
import org.eclipse.n4js.n4JS.ParameterizedPropertyAccessExpression;
import org.eclipse.n4js.n4JS.ParenExpression;
import org.eclipse.n4js.n4JS.PostfixExpression;
import org.eclipse.n4js.n4JS.PromisifyExpression;
import org.eclipse.n4js.n4JS.PropertyAssignment;
import org.eclipse.n4js.n4JS.RelationalExpression;
import org.eclipse.n4js.n4JS.RelationalOperator;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.n4JS.ShiftExpression;
import org.eclipse.n4js.n4JS.StringLiteral;
import org.eclipse.n4js.n4JS.SuperLiteral;
import org.eclipse.n4js.n4JS.ThisArgProvider;
import org.eclipse.n4js.n4JS.ThisLiteral;
import org.eclipse.n4js.n4JS.UnaryExpression;
import org.eclipse.n4js.n4JS.UnaryOperator;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.n4JS.extensions.ExpressionExtensions;
import org.eclipse.n4js.postprocessing.ASTMetaInfoUtils;
import org.eclipse.n4js.scoping.members.MemberScopingHelper;
import org.eclipse.n4js.ts.scoping.builtin.BuiltInTypeScope;
import org.eclipse.n4js.ts.typeRefs.BoundThisTypeRef;
import org.eclipse.n4js.ts.typeRefs.ComposedTypeRef;
import org.eclipse.n4js.ts.typeRefs.ExistentialTypeRef;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExprOrRef;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.IntersectionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.ThisTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRefsFactory;
import org.eclipse.n4js.ts.typeRefs.TypeTypeRef;
import org.eclipse.n4js.ts.typeRefs.UnionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.UnknownTypeRef;
import org.eclipse.n4js.ts.typeRefs.Wildcard;
import org.eclipse.n4js.ts.types.BuiltInType;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.FieldAccessor;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.MemberAccessModifier;
import org.eclipse.n4js.ts.types.ModuleNamespaceVirtualType;
import org.eclipse.n4js.ts.types.NullType;
import org.eclipse.n4js.ts.types.PrimitiveType;
import org.eclipse.n4js.ts.types.TAnnotableElement;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TEnum;
import org.eclipse.n4js.ts.types.TExportableElement;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TFormalParameter;
import org.eclipse.n4js.ts.types.TFunction;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.TN4Classifier;
import org.eclipse.n4js.ts.types.TObjectPrototype;
import org.eclipse.n4js.ts.types.TSetter;
import org.eclipse.n4js.ts.types.TStructuralType;
import org.eclipse.n4js.ts.types.TVariable;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypeDefs;
import org.eclipse.n4js.ts.types.TypeVariable;
import org.eclipse.n4js.ts.types.TypingStrategy;
import org.eclipse.n4js.ts.types.UndefinedType;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.n4js.typesystem.utils.TypeSystemHelper;
import org.eclipse.n4js.utils.ContainerTypesHelper;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.n4js.utils.PromisifyHelper;
import org.eclipse.n4js.validation.AbstractN4JSDeclarativeValidator;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.n4js.validation.JavaScriptVariantHelper;
import org.eclipse.n4js.validation.N4JSElementKeywordProvider;
import org.eclipse.n4js.validation.ValidatorMessageHelper;
import org.eclipse.n4js.validation.validators.ConstBoolean;
import org.eclipse.n4js.xtext.scoping.IEObjectDescriptionWithError;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class N4JSExpressionValidator
extends AbstractN4JSDeclarativeValidator {
    @Inject
    protected N4JSTypeSystem ts;
    @Inject
    protected TypeSystemHelper tsh;
    @Inject
    @Extension
    private N4JSElementKeywordProvider _n4JSElementKeywordProvider;
    @Inject
    @Extension
    private ValidatorMessageHelper _validatorMessageHelper;
    @Inject
    private ContainerTypesHelper containerTypesHelper;
    @Inject
    private MemberScopingHelper memberScopingHelper;
    @Inject
    private PromisifyHelper promisifyHelper;
    @Inject
    private JavaScriptVariantHelper jsVariantHelper;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;

    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void checkAwaitExpression(AwaitExpression awaitExpression) {
        Expression _expression;
        boolean _tripleEquals;
        FunctionDefinition containerFunDef = (FunctionDefinition)EcoreUtil2.getContainerOfType((EObject)awaitExpression, FunctionDefinition.class);
        if (containerFunDef == null || Boolean.valueOf(containerFunDef.isAsync()) == Boolean.valueOf(false)) {
            String message = IssueCodes.getMessageForEXP_MISPLACED_AWAIT_EXPRESSION("await", "async");
            this.addIssue(message, (EObject)awaitExpression, "EXP_MISPLACED_AWAIT_EXPRESSION");
        }
        boolean bl = _tripleEquals = (_expression = awaitExpression.getExpression()) == null;
        if (_tripleEquals) {
            return;
        }
        this.internalCheckAwaitingAPromise(awaitExpression);
    }

    private void internalCheckAwaitingAPromise(AwaitExpression awaitExpression) {
        Expression subExpr = awaitExpression.getExpression();
        if (subExpr == null) {
            return;
        }
        TypeRef typeRef = this.ts.tau((TypableElement)subExpr, (EObject)awaitExpression);
        if (typeRef == null) {
            return;
        }
        RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)awaitExpression);
        BuiltInTypeScope scope = RuleEnvironmentExtensions.getPredefinedTypes((RuleEnvironment)G).builtInTypeScope;
        TypeRefsFactory einst = TypeRefsFactory.eINSTANCE;
        UnionTypeExpression union1 = einst.createUnionTypeExpression();
        union1.getTypeRefs().add((Object)scope.getVoidTypeRef());
        union1.getTypeRefs().add((Object)scope.getAnyTypeRef());
        UnionTypeExpression union2 = einst.createUnionTypeExpression();
        union2.getTypeRefs().add((Object)scope.getVoidTypeRef());
        union2.getTypeRefs().add((Object)scope.getAnyTypeRef());
        ParameterizedTypeRef promUni = TypeUtils.createPromiseTypeRef((BuiltInTypeScope)scope, (TypeArgument)union1, (TypeArgument)union2);
        boolean stUnions = this.ts.subtypeSucceeded(G, (TypeArgument)typeRef, (TypeArgument)promUni);
        Type _declaredType = typeRef.getDeclaredType();
        UndefinedType _undefinedType = RuleEnvironmentExtensions.undefinedType(G);
        boolean isUndef = Objects.equal((Object)_declaredType, (Object)_undefinedType);
        Type _declaredType_1 = typeRef.getDeclaredType();
        NullType _nullType = RuleEnvironmentExtensions.nullType(G);
        boolean isNull = Objects.equal((Object)_declaredType_1, (Object)_nullType);
        if (!stUnions) {
            String message = IssueCodes.getMessageForEXP_AWAIT_NON_ASYNC();
            this.addIssue(message, (EObject)awaitExpression, "EXP_AWAIT_NON_ASYNC");
        }
        if (isUndef || isNull) {
            String message_1 = IssueCodes.getMessageForEXP_AWAIT_NON_ASYNC_SPECIAL(typeRef.getDeclaredType().getName());
            this.addIssue(message_1, (EObject)awaitExpression, "EXP_AWAIT_NON_ASYNC_SPECIAL");
        }
    }

    @Check
    public void checkPropertyAccesssExpression(ParameterizedPropertyAccessExpression propAccessExpression) {
        IdentifiableElement _property;
        boolean _tripleEquals_1;
        boolean _tripleEquals;
        boolean _or = false;
        Expression _target = null;
        if (propAccessExpression != null) {
            _target = propAccessExpression.getTarget();
        }
        boolean bl = _tripleEquals = _target == null;
        _or = _tripleEquals ? true : (_tripleEquals_1 = (_property = propAccessExpression.getProperty()) == null);
        if (_or) {
            return;
        }
        IdentifiableElement prop = propAccessExpression.getProperty();
        EList _xifexpression = null;
        _xifexpression = prop instanceof Type ? ((Type)prop).getTypeVars() : Collections.unmodifiableList(CollectionLiterals.newArrayList());
        EList typeVars = _xifexpression;
        this.internalCheckTypeArguments((List<? extends TypeVariable>)typeVars, (List<? extends TypeArgument>)propAccessExpression.getTypeArgs(), true, prop, (EObject)propAccessExpression, (EStructuralFeature)N4JSPackage.eINSTANCE.getParameterizedPropertyAccessExpression_Property());
        this.internalCheckTargetSubtypeOfDeclaredThisType(propAccessExpression);
        this.internalCheckMethodReference(propAccessExpression);
        this.internalCheckAccessToStaticMemberOfInterface(propAccessExpression);
    }

    private void internalCheckTargetSubtypeOfDeclaredThisType(ParameterizedPropertyAccessExpression propAccessExpr) {
        TypeRef declThisTypeRef;
        IdentifiableElement prop = propAccessExpr.getProperty();
        boolean _eIsProxy = prop.eIsProxy();
        if (_eIsProxy) {
            return;
        }
        TypeRef _switchResult = null;
        boolean _matched = false;
        if (prop instanceof TMethod) {
            _matched = true;
            _switchResult = ((TMethod)prop).getDeclaredThisType();
        }
        if (!_matched && prop instanceof FieldAccessor) {
            _matched = true;
            _switchResult = ((FieldAccessor)prop).getDeclaredThisType();
        }
        if ((declThisTypeRef = _switchResult) != null) {
            boolean _not;
            TypeRef targetTypeRef;
            RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)propAccessExpr);
            boolean _subtypeSucceeded = this.ts.subtypeSucceeded(G, (TypeArgument)(targetTypeRef = this.ts.type(G, (TypableElement)propAccessExpr.getTarget())), (TypeArgument)declThisTypeRef);
            boolean bl = _not = !_subtypeSucceeded;
            if (_not) {
                String msg = IssueCodes.getMessageForEXP_ACCESS_INVALID_TYPE_OF_TARGET(this._validatorMessageHelper.description((EObject)prop), targetTypeRef.getTypeRefAsString(), declThisTypeRef.getTypeRefAsString());
                this.addIssue(msg, (EObject)propAccessExpr, (EStructuralFeature)N4JSPackage.eINSTANCE.getParameterizedPropertyAccessExpression_Property(), "TYS_NO_SUBTYPE", new String[0]);
            }
        }
    }

    private void internalCheckMethodReference(ParameterizedPropertyAccessExpression propAccessExpression) {
        boolean shouldWarn;
        boolean _not;
        boolean _checkMethodReference = this.jsVariantHelper.checkMethodReference((EObject)propAccessExpression);
        boolean bl = _not = !_checkMethodReference;
        if (_not) {
            return;
        }
        IdentifiableElement prop = propAccessExpression.getProperty();
        if (!(prop instanceof TMethod)) {
            return;
        }
        TMethod method = (TMethod)prop;
        if (!method.isStatic() && Objects.equal((Object)"constructor", (Object)method.getName())) {
            return;
        }
        EObject enclosing = propAccessExpression.eContainer();
        boolean _switchResult = false;
        boolean _matched = false;
        if (enclosing instanceof ParameterizedCallExpression) {
            _matched = true;
            Expression _target = ((ParameterizedCallExpression)enclosing).getTarget();
            boolean bl2 = _switchResult = _target != propAccessExpression;
        }
        if (!_matched && enclosing instanceof ParameterizedPropertyAccessExpression) {
            _matched = true;
            _switchResult = false;
        }
        if (!_matched && enclosing instanceof UnaryExpression) {
            _matched = true;
            UnaryOperator _op = ((UnaryExpression)enclosing).getOp();
            boolean bl3 = _switchResult = _op != UnaryOperator.TYPEOF;
        }
        if (!_matched && enclosing instanceof EqualityExpression) {
            _matched = true;
            _switchResult = false;
        }
        if (!_matched && enclosing instanceof ExpressionStatement) {
            _matched = true;
            _switchResult = false;
        }
        if (!_matched) {
            _switchResult = true;
        }
        if (!(shouldWarn = _switchResult)) {
            return;
        }
        if (this.isMethodEffectivelyFinal(method) && method.isLacksThisOrSuperUsage()) {
            return;
        }
        String message = IssueCodes.getMessageForEXP_METHOD_REF_UNATTACHED_FROM_RECEIVER(method.getName());
        ParameterizedPropertyAccessExpression source = propAccessExpression;
        EReference feature = N4JSPackage.eINSTANCE.getParameterizedPropertyAccessExpression_Property();
        this.warning(message, (EObject)source, (EStructuralFeature)feature, "EXP_METHOD_REF_UNATTACHED_FROM_RECEIVER", new String[0]);
    }

    private boolean isMethodEffectivelyFinal(TMethod method) {
        if (method.isFinal() || Objects.equal((Object)method.getMemberAccessModifier(), (Object)MemberAccessModifier.PRIVATE)) {
            return true;
        }
        ContainerType containingType = method.getContainingType();
        return containingType != null && containingType.isFinal();
    }

    private void internalCheckAccessToStaticMemberOfInterface(ParameterizedPropertyAccessExpression propAccessExpr) {
        IdentifiableElement prop = propAccessExpr.getProperty();
        if (prop instanceof TMember && prop != null && ((TMember)prop).isStatic() && ((TMember)prop).eContainer() instanceof TInterface) {
            EObject _eContainer;
            boolean _tripleNotEquals;
            Expression target = propAccessExpr.getTarget();
            IdentifierRef _xifexpression = null;
            _xifexpression = target instanceof IdentifierRef ? (IdentifierRef)target : null;
            IdentifierRef targetIdRef = _xifexpression;
            boolean isExceptionCase = target instanceof ThisLiteral;
            boolean _and = false;
            IdentifiableElement _id = null;
            if (targetIdRef != null) {
                _id = targetIdRef.getId();
            }
            boolean bl = _tripleNotEquals = _id != (_eContainer = ((TMember)prop).eContainer());
            if (!_tripleNotEquals) {
                _and = false;
            } else {
                boolean bl2 = _and = !isExceptionCase;
            }
            if (_and) {
                String message = IssueCodes.getMessageForCLF_INVALID_ACCESS_OF_STATIC_MEMBER_OF_INTERFACE();
                this.addIssue(message, (EObject)propAccessExpr, (EStructuralFeature)N4JSPackage.eINSTANCE.getParameterizedPropertyAccessExpression_Target(), "CLF_INVALID_ACCESS_OF_STATIC_MEMBER_OF_INTERFACE", new String[0]);
            }
        }
    }

    @Check
    public void checkCallExpression(ParameterizedCallExpression callExpression) {
        boolean _tripleEquals;
        boolean _not;
        boolean _checkCallExpression = this.jsVariantHelper.checkCallExpression((EObject)callExpression);
        boolean bl = _not = !_checkCallExpression;
        if (_not) {
            return;
        }
        Expression _target = null;
        if (callExpression != null) {
            _target = callExpression.getTarget();
        }
        boolean bl2 = _tripleEquals = _target == null;
        if (_tripleEquals) {
            return;
        }
        TypeRef typeRef = this.ts.tau((TypableElement)callExpression.getTarget());
        if (typeRef == null) {
            return;
        }
        if (typeRef instanceof UnknownTypeRef) {
            return;
        }
        RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)callExpression);
        if (!(callExpression.getTarget() instanceof SuperLiteral) && !this.tsh.isCallable(G, typeRef)) {
            if (this.tsh.isClassConstructorFunction(G, typeRef) || this.isClassifierTypeRefToAbstractClass(G, typeRef)) {
                String message = IssueCodes.getMessageForEXP_CALL_CLASS_CTOR();
                this.addIssue(message, (EObject)callExpression.getTarget(), null, "EXP_CALL_CLASS_CTOR", new String[0]);
            } else {
                String message_1 = IssueCodes.getMessageForEXP_CALL_NOT_A_FUNCTION(typeRef.getTypeRefAsString());
                this.addIssue(message_1, (EObject)callExpression.getTarget(), null, "EXP_CALL_NOT_A_FUNCTION", new String[0]);
            }
            return;
        }
        if (typeRef instanceof FunctionTypeExprOrRef) {
            this.internalCheckTypeArguments((List<? extends TypeVariable>)((FunctionTypeExprOrRef)typeRef).getTypeVars(), (List<? extends TypeArgument>)callExpression.getTypeArgs(), true, (IdentifiableElement)((FunctionTypeExprOrRef)typeRef).getDeclaredType(), (EObject)callExpression, (EStructuralFeature)N4JSPackage.eINSTANCE.getParameterizedCallExpression_Target());
            this.internalCheckCallingAsyncFunWithoutAwaitingForIt((FunctionTypeExprOrRef)typeRef, callExpression);
            Expression trgt = callExpression.getTarget();
            boolean _matched = false;
            if (trgt instanceof IdentifierRef) {
                _matched = true;
                Procedures.Procedure4 _function = (message_2, source, feature, issueCode) -> this.addIssue((String)message_2, (EObject)source, (EStructuralFeature)feature, (String)issueCode, new String[0]);
                N4JSExpressionValidator.internalCheckNameRestrictionInMethodBodies((IdentifierRef)trgt, (Procedures.Procedure4<? super String, ? super EObject, ? super EStructuralFeature, ? super String>)_function);
            }
        }
    }

    private boolean isClassifierTypeRefToAbstractClass(RuleEnvironment G, TypeRef typeRef) {
        Type staticType;
        if (typeRef instanceof TypeTypeRef && (staticType = this.tsh.getStaticType(G, (TypeTypeRef)typeRef)) instanceof TClass) {
            return ((TClass)staticType).isAbstract();
        }
        return false;
    }

    public void internalCheckCallingAsyncFunWithoutAwaitingForIt(FunctionTypeExprOrRef fteor, ParameterizedCallExpression callExpression) {
        boolean shouldWarn;
        boolean isTopLevel;
        boolean _not;
        RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)callExpression);
        boolean _isAsync = N4JSLanguageUtils.isAsync(fteor, G);
        boolean bl = _not = !_isAsync;
        if (_not) {
            return;
        }
        EObject container = callExpression.eContainer();
        while (container instanceof ParenExpression) {
            container = ((ParenExpression)container).eContainer();
        }
        boolean isAwaitedFor = container instanceof AwaitExpression;
        boolean bl2 = isTopLevel = container instanceof ExpressionStatement && container.eContainer() instanceof Script;
        if (isAwaitedFor || isTopLevel) {
            return;
        }
        boolean _xifexpression = false;
        if (container instanceof VariableDeclaration) {
            _xifexpression = ((VariableDeclaration)container).getExpression() == callExpression && ((VariableDeclaration)container).getDeclaredTypeRef() != null;
        } else {
            boolean _xifexpression_1 = false;
            if (container instanceof AssignmentExpression) {
                Expression _rhs = ((AssignmentExpression)container).getRhs();
                _xifexpression_1 = _rhs == callExpression;
            } else {
                boolean _xifexpression_2 = false;
                boolean _isArgumentToPromiseUtilityMethod = this.isArgumentToPromiseUtilityMethod(callExpression, container, G);
                _xifexpression_2 = _isArgumentToPromiseUtilityMethod;
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        boolean isPromiseExplict = _xifexpression;
        boolean bl3 = shouldWarn = !isPromiseExplict;
        if (shouldWarn) {
            String message = IssueCodes.getMessageForEXP_MISSNG_AWAIT_FOR_ASYNC_TARGET();
            this.addIssue(message, (EObject)callExpression.getTarget(), "EXP_MISSNG_AWAIT_FOR_ASYNC_TARGET");
        }
    }

    private boolean isArgumentToPromiseUtilityMethod(ParameterizedCallExpression asyncInvocation, EObject container, RuleEnvironment G) {
        Expression _target_1;
        ParameterizedPropertyAccessExpression utilityAccess;
        boolean _isPromiseUtilityPropertyAccess;
        Expression _target;
        boolean isArrayElem;
        EObject utilityCall = container;
        boolean bl = isArrayElem = container instanceof ArrayElement && container.eContainer() instanceof ArrayLiteral;
        if (isArrayElem) {
            utilityCall = container.eContainer().eContainer();
        }
        if (utilityCall instanceof Argument) {
            utilityCall = ((Argument)utilityCall).eContainer();
        }
        if (utilityCall instanceof ParameterizedCallExpression && (_target = ((ParameterizedCallExpression)utilityCall).getTarget()) instanceof ParameterizedPropertyAccessExpression && (_isPromiseUtilityPropertyAccess = this.isPromiseUtilityPropertyAccess(utilityAccess = (ParameterizedPropertyAccessExpression)(_target_1 = ((ParameterizedCallExpression)utilityCall).getTarget()), G))) {
            Functions.Function1 _function = arg -> {
                Expression _expression = arg.getExpression();
                return _expression == asyncInvocation;
            };
            boolean isDirectArg = IterableExtensions.exists((Iterable)((ParameterizedCallExpression)utilityCall).getArguments(), (Functions.Function1)_function);
            if (isDirectArg) {
                return true;
            }
            String name = utilityAccess.getProperty().getName();
            if (isArrayElem && (Objects.equal((Object)name, (Object)"all") || Objects.equal((Object)name, (Object)"race"))) {
                Functions.Function1 _function_1 = arg -> {
                    EObject _eContainer;
                    Expression _expression = arg.getExpression();
                    return _expression == (_eContainer = container.eContainer());
                };
                boolean argOccursInArray = IterableExtensions.exists((Iterable)((ParameterizedCallExpression)utilityCall).getArguments(), (Functions.Function1)_function_1);
                return argOccursInArray;
            }
        }
        return false;
    }

    private boolean isPromiseUtilityPropertyAccess(ParameterizedPropertyAccessExpression utilityAccess, RuleEnvironment G) {
        IdentifiableElement invokedUtility = utilityAccess.getProperty();
        if (invokedUtility instanceof TMethod) {
            boolean isStaticUtility = ((TMethod)invokedUtility).isStatic();
            boolean hasNameOfInterest = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"all", "race", "resolve"})).contains(((TMethod)invokedUtility).getName());
            if (isStaticUtility && hasNameOfInterest) {
                BuiltInTypeScope tscope = RuleEnvironmentExtensions.getPredefinedTypes((RuleEnvironment)G).builtInTypeScope;
                TypeRef tr = this.ts.type(G, (TypableElement)utilityAccess.getTarget());
                if (tr instanceof TypeTypeRef) {
                    TypeArgument str = ((TypeTypeRef)tr).getTypeArg();
                    boolean _xifexpression = false;
                    _xifexpression = str instanceof TypeRef ? TypeUtils.isPromise((TypeRef)((TypeRef)str), (BuiltInTypeScope)tscope) : false;
                    boolean isReceiverPromise = _xifexpression;
                    return isReceiverPromise;
                }
            }
        }
        return false;
    }

    public static void internalCheckNameRestrictionInMethodBodies(IdentifierRef trgt, Procedures.Procedure4<? super String, ? super EObject, ? super EStructuralFeature, ? super String> g) {
        N4MethodDeclaration containingMethod;
        boolean _endsWith;
        if (trgt.getId() instanceof TFunction && !(trgt.getId() instanceof TMethod) && (_endsWith = trgt.getId().getName().endsWith("___n4")) && (containingMethod = (N4MethodDeclaration)EcoreUtil2.getContainerOfType((EObject)trgt, N4MethodDeclaration.class)) != null) {
            String msg = IssueCodes.getMessageForCLF_METHOD_BODY_FORBIDDEN_REFERENCE_NAME();
            g.apply((Object)msg, (Object)trgt, (Object)N4JSPackage.eINSTANCE.getIdentifierRef_Id(), (Object)"CLF_METHOD_BODY_FORBIDDEN_REFERENCE_NAME");
        }
    }

    @Check
    public void checkNew(NewExpression newExpression) {
        boolean _tripleEquals_1;
        boolean _tripleEquals;
        boolean _not;
        boolean _requireCheckNewExpression = this.jsVariantHelper.requireCheckNewExpression((EObject)newExpression);
        boolean bl = _not = !_requireCheckNewExpression;
        if (_not) {
            return;
        }
        Expression _callee = null;
        if (newExpression != null) {
            _callee = newExpression.getCallee();
        }
        boolean bl2 = _tripleEquals = _callee == null;
        if (_tripleEquals) {
            return;
        }
        Expression callee = newExpression.getCallee();
        TypeRef typeRef = this.ts.tau((TypableElement)callee);
        if (typeRef == null) {
            return;
        }
        if (typeRef instanceof UnknownTypeRef) {
            return;
        }
        RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)newExpression);
        if (!(typeRef instanceof TypeTypeRef)) {
            TypeTypeRef constrOfWildcard;
            boolean _isDynamic = typeRef.isDynamic();
            if (_isDynamic && (this.ts.subtypeSucceeded(G, (TypeArgument)typeRef, (TypeArgument)(constrOfWildcard = TypeUtils.createTypeTypeRef((TypeArgument)TypeUtils.createWildcard(), (boolean)true))) || this.ts.subtypeSucceeded(G, (TypeArgument)constrOfWildcard, (TypeArgument)typeRef))) {
                return;
            }
            this.issueNotACtor(typeRef, newExpression);
            return;
        }
        TypeTypeRef classifierTypeRef = (TypeTypeRef)typeRef;
        TypeArgument typeArg = classifierTypeRef.getTypeArg();
        Type staticType = this.changeToCovariantUpperBoundIfTypeVar(this.tsh.getStaticType(G, classifierTypeRef));
        if (staticType != null && staticType.eIsProxy()) {
            return;
        }
        boolean isCtor = classifierTypeRef.isConstructorRef();
        boolean isDirectRef = callee instanceof IdentifierRef && ((IdentifierRef)callee).getId() == staticType;
        boolean isConcreteOrCovariant = !(typeArg instanceof Wildcard) && !(typeArg instanceof ExistentialTypeRef) && !(typeArg instanceof ThisTypeRef) || staticType instanceof TClassifier && N4JSLanguageUtils.hasCovariantConstructor((TClassifier)staticType);
        TObjectPrototype _symbolObjectType = RuleEnvironmentExtensions.symbolObjectType(G);
        boolean bl3 = _tripleEquals_1 = staticType == _symbolObjectType;
        if (_tripleEquals_1) {
            String message = IssueCodes.getMessageForBIT_SYMBOL_NOT_A_CTOR();
            this.addIssue(message, (EObject)newExpression, (EStructuralFeature)N4JSPackage.eINSTANCE.getNewExpression_Callee(), "BIT_SYMBOL_NOT_A_CTOR", new String[0]);
            return;
        }
        if (!isCtor && staticType instanceof TInterface && isDirectRef) {
            String message_1 = IssueCodes.getMessageForEXP_NEW_CANNOT_INSTANTIATE(this._n4JSElementKeywordProvider.keyword(staticType), staticType.getName());
            this.addIssue(message_1, (EObject)newExpression, (EStructuralFeature)N4JSPackage.eINSTANCE.getNewExpression_Callee(), "EXP_NEW_CANNOT_INSTANTIATE", new String[0]);
            return;
        }
        if (!isCtor && staticType instanceof TClass && ((TClass)staticType).isAbstract() && isDirectRef) {
            String message_2 = IssueCodes.getMessageForEXP_NEW_CANNOT_INSTANTIATE("abstract class", staticType.getName());
            this.addIssue(message_2, (EObject)newExpression, (EStructuralFeature)N4JSPackage.eINSTANCE.getNewExpression_Callee(), "EXP_NEW_CANNOT_INSTANTIATE", new String[0]);
            return;
        }
        if (isCtor && !isConcreteOrCovariant && staticType instanceof TClassifier) {
            String message_3 = IssueCodes.getMessageForEXP_NEW_WILDCARD_NO_COVARIANT_CTOR(typeArg.getTypeRefAsString(), staticType.getTypeAsString());
            this.addIssue(message_3, (EObject)newExpression, (EStructuralFeature)N4JSPackage.eINSTANCE.getNewExpression_Callee(), "EXP_NEW_WILDCARD_NO_COVARIANT_CTOR", new String[0]);
            return;
        }
        if (staticType instanceof TEnum) {
            String message_4 = IssueCodes.getMessageForEXP_NEW_CANNOT_INSTANTIATE("enum", ((TEnum)staticType).getName());
            this.addIssue(message_4, (EObject)newExpression, (EStructuralFeature)N4JSPackage.eINSTANCE.getNewExpression_Callee(), "EXP_NEW_CANNOT_INSTANTIATE", new String[0]);
            return;
        }
        if (staticType instanceof TypeVariable) {
            String message_5 = IssueCodes.getMessageForEXP_NEW_CANNOT_INSTANTIATE("type variable", ((TypeVariable)staticType).getName());
            this.addIssue(message_5, (EObject)newExpression, (EStructuralFeature)N4JSPackage.eINSTANCE.getNewExpression_Callee(), "EXP_NEW_CANNOT_INSTANTIATE", new String[0]);
            return;
        }
        if (staticType == null || !isCtor || !isConcreteOrCovariant) {
            String name = classifierTypeRef.getTypeRefAsString();
            String message_6 = IssueCodes.getMessageForEXP_NEW_WILDCARD_OR_TYPEVAR(name);
            this.addIssue(message_6, (EObject)newExpression, (EStructuralFeature)N4JSPackage.eINSTANCE.getNewExpression_Callee(), "EXP_NEW_WILDCARD_OR_TYPEVAR", new String[0]);
            return;
        }
        this.internalCheckTypeArguments((List<? extends TypeVariable>)staticType.getTypeVars(), (List<? extends TypeArgument>)newExpression.getTypeArgs(), false, (IdentifiableElement)staticType, (EObject)newExpression, (EStructuralFeature)N4JSPackage.eINSTANCE.getNewExpression_Callee());
        if (staticType instanceof TClassifier) {
            this.internalCheckNewParameters(newExpression, (TClassifier)staticType);
        }
    }

    private Type changeToCovariantUpperBoundIfTypeVar(Type type) {
        boolean _hasCovariantConstructor;
        Type declType;
        TypeRef ub;
        if (type instanceof TypeVariable && (ub = ((TypeVariable)type).getDeclaredUpperBound()) instanceof ParameterizedTypeRef && (declType = ((ParameterizedTypeRef)ub).getDeclaredType()) instanceof TClassifier && (_hasCovariantConstructor = N4JSLanguageUtils.hasCovariantConstructor((TClassifier)declType))) {
            return declType;
        }
        return type;
    }

    private void issueNotACtor(TypeRef typeRef, NewExpression newExpression) {
        String message = IssueCodes.getMessageForEXP_NEW_NOT_A_CTOR(typeRef.getTypeRefAsString());
        this.addIssue(message, (EObject)newExpression, (EStructuralFeature)N4JSPackage.eINSTANCE.getNewExpression_Callee(), "EXP_NEW_NOT_A_CTOR", new String[0]);
    }

    @Check
    public void checkRelationalExpression(RelationalExpression relationalExpression) {
        RuleEnvironment G;
        Type staticType;
        TypeRef typeRef;
        if (relationalExpression.getRhs() != null && relationalExpression.getOp() == RelationalOperator.INSTANCEOF && (typeRef = this.ts.tau((TypableElement)relationalExpression.getRhs())) instanceof TypeTypeRef && (staticType = this.tsh.getStaticType(G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)relationalExpression), (TypeTypeRef)typeRef)) instanceof TN4Classifier) {
            boolean _tripleNotEquals;
            TypingStrategy _typingStrategy = ((TN4Classifier)staticType).getTypingStrategy();
            boolean bl = _tripleNotEquals = _typingStrategy != TypingStrategy.DEFAULT;
            if (_tripleNotEquals) {
                String message = IssueCodes.getMessageForTYS_INSTANCEOF_NOT_SUPPORTED_FOR_STRUCTURAL_TYPES(((TN4Classifier)staticType).getName());
                this.addIssue(message, (EObject)relationalExpression, (EStructuralFeature)N4JSPackage.eINSTANCE.getRelationalExpression_Rhs(), "TYS_INSTANCEOF_NOT_SUPPORTED_FOR_STRUCTURAL_TYPES", new String[0]);
            } else if (staticType instanceof TInterface && EcoreUtil.getRootContainer((EObject)staticType) instanceof TypeDefs) {
                String message_1 = IssueCodes.getMessageForTYS_INSTANCEOF_NOT_SUPPORTED_FOR_BUILT_IN_INTERFACES(((TN4Classifier)staticType).getName());
                this.addIssue(message_1, (EObject)relationalExpression, (EStructuralFeature)N4JSPackage.eINSTANCE.getRelationalExpression_Rhs(), "TYS_INSTANCEOF_NOT_SUPPORTED_FOR_BUILT_IN_INTERFACES", new String[0]);
            }
        }
    }

    @Check
    public boolean checkPostfixExpression(PostfixExpression postfixExpression) {
        boolean _xblockexpression = false;
        Expression expression = postfixExpression.getExpression();
        _xblockexpression = this.holdsWritabelePropertyAccess(expression) && this.holdsWritableIdentifier(expression) && this.holdsLefthandsideNotConst(expression);
        return _xblockexpression;
    }

    @Check
    public boolean checkUnaryExpressionWithWriteAccess(UnaryExpression unaryExpression) {
        boolean _xifexpression = false;
        if (UnaryOperator.DEC == unaryExpression.getOp() || UnaryOperator.INC == unaryExpression.getOp()) {
            _xifexpression = this.holdsWritabelePropertyAccess(unaryExpression.getExpression()) && this.holdsWritableIdentifier(unaryExpression.getExpression()) && this.holdsLefthandsideNotConst(unaryExpression.getExpression());
        }
        return _xifexpression;
    }

    private boolean holdsWritabelePropertyAccess(Expression expression) {
        IdentifiableElement property;
        if (expression instanceof ParameterizedPropertyAccessExpression && (property = ((ParameterizedPropertyAccessExpression)expression).getProperty()) instanceof TGetter) {
            Type declaredType;
            TypeRef propertyTargetType = this.ts.tau((TypableElement)((ParameterizedPropertyAccessExpression)expression).getTarget());
            Type _declaredType = null;
            if (propertyTargetType != null) {
                _declaredType = propertyTargetType.getDeclaredType();
            }
            if ((declaredType = _declaredType) instanceof TClassifier) {
                Functions.Function1 _function = it -> it.getName().equals(((TGetter)property).getName());
                boolean setterExists = IterableExtensions.exists((Iterable)Iterables.filter(this.containerTypesHelper.fromContext((EObject)expression).members((ContainerType)declaredType), TSetter.class), (Functions.Function1)_function);
                if (!setterExists) {
                    String msg = IssueCodes.getMessageForTYS_PROPERTY_HAS_NO_SETTER(((TGetter)property).getName());
                    this.addIssue(msg, (EObject)expression, (EStructuralFeature)N4JSPackage.Literals.PARAMETERIZED_PROPERTY_ACCESS_EXPRESSION__PROPERTY, "TYS_PROPERTY_HAS_NO_SETTER", new String[0]);
                    return false;
                }
            }
        }
        return true;
    }

    private boolean holdsWritableIdentifier(Expression expression) {
        if (expression instanceof IdentifierRef) {
            IdentifiableElement id = ((IdentifierRef)expression).getId();
            boolean _matched = false;
            if (id instanceof TExportableElement) {
                boolean _notEquals;
                _matched = true;
                TModule module = ((Script)EcoreUtil2.getContainerOfType((EObject)expression, Script.class)).getModule();
                TModule _containingModule = ((TExportableElement)id).getContainingModule();
                boolean bl = _notEquals = !Objects.equal((Object)_containingModule, (Object)module);
                if (_notEquals) {
                    this.addIssue(IssueCodes.getMessageForIMP_IMPORTED_ELEMENT_READ_ONLY(((IdentifierRef)expression).getIdAsText()), (EObject)expression, "IMP_IMPORTED_ELEMENT_READ_ONLY");
                    return false;
                }
            }
        } else {
            if (expression instanceof ParenExpression) {
                return this.holdsWritableIdentifier(((ParenExpression)expression).getExpression());
            }
            if (expression instanceof ParameterizedPropertyAccessExpression) {
                IdentifiableElement id_1;
                Expression target = ((ParameterizedPropertyAccessExpression)expression).getTarget();
                if (((ParameterizedPropertyAccessExpression)expression).getProperty() != null && !((ParameterizedPropertyAccessExpression)expression).getProperty().eIsProxy() && target instanceof IdentifierRef && (id_1 = ((IdentifierRef)target).getId()) instanceof ModuleNamespaceVirtualType) {
                    TModule _module_1;
                    boolean _notEquals;
                    TModule _module = ((ModuleNamespaceVirtualType)id_1).getModule();
                    boolean bl = _notEquals = !Objects.equal((Object)_module, (Object)(_module_1 = ((Script)EcoreUtil2.getContainerOfType((EObject)expression, Script.class)).getModule()));
                    if (_notEquals) {
                        String importedElmentText = NodeModelUtils.getTokenText((INode)NodeModelUtils.findActualNodeFor((EObject)expression));
                        this.addIssue(IssueCodes.getMessageForIMP_IMPORTED_ELEMENT_READ_ONLY(importedElmentText), (EObject)expression, "IMP_IMPORTED_ELEMENT_READ_ONLY");
                        return false;
                    }
                }
            }
        }
        return true;
    }

    @Check
    public void checkCallExpressionParameters(ParameterizedCallExpression callExpression) {
        TypeRef targetTypeRef;
        boolean _not;
        boolean _checkCallExpression = this.jsVariantHelper.checkCallExpression((EObject)callExpression);
        boolean bl = _not = !_checkCallExpression;
        if (_not) {
            return;
        }
        Expression target = callExpression.getTarget();
        if (target != null && (targetTypeRef = this.ts.tau((TypableElement)target)) instanceof FunctionTypeExprOrRef) {
            boolean isPromisified;
            EList _fpars = ((FunctionTypeExprOrRef)targetTypeRef).getFpars();
            ArrayList<TFormalParameter> fpars = new ArrayList<TFormalParameter>((Collection<TFormalParameter>)_fpars);
            EObject parent = callExpression.eContainer();
            boolean bl2 = isPromisified = parent instanceof AwaitExpression && this.promisifyHelper.isAutoPromisify((AwaitExpression)parent) || parent instanceof PromisifyExpression;
            if (isPromisified) {
                int _size = fpars.size();
                int _minus = _size - 1;
                fpars.remove(_minus);
            }
            this.internalCheckNumberOfArguments(fpars, (List<Argument>)callExpression.getArguments(), (Expression)callExpression);
        }
    }

    private void internalCheckNewParameters(NewExpression newExpression, TClassifier staticType) {
        TMethod maybeConstructor = this.containerTypesHelper.fromContext((EObject)newExpression).findConstructor((ContainerType<?>)staticType);
        if (maybeConstructor != null) {
            this.internalCheckNumberOfArguments((List<TFormalParameter>)maybeConstructor.getFpars(), (List<Argument>)newExpression.getArguments(), (Expression)newExpression);
            return;
        }
    }

    private void internalCheckNumberOfArguments(List<TFormalParameter> fpars, List<Argument> args, Expression expr) {
        int cmp = this.compareNumberOfArgsWithNumberOfFPars(fpars, args);
        if (cmp < 0) {
            this.addIssue(IssueCodes.getMessageForEXP_NUM_OF_ARGS_TOO_FEW(fpars.size(), args.size()), (EObject)expr, "EXP_NUM_OF_ARGS_TOO_FEW");
        } else if (cmp > 0) {
            this.addIssue(IssueCodes.getMessageForEXP_NUM_OF_ARGS_TOO_MANY(fpars.size(), args.size()), (EObject)expr, "EXP_NUM_OF_ARGS_TOO_MANY");
        }
    }

    private int compareNumberOfArgsWithNumberOfFPars(List<TFormalParameter> fpars, List<Argument> args) {
        int _size_1;
        boolean _tripleEquals;
        int argCount = args.size();
        int fparCount = fpars.size();
        int _size = fpars.size();
        boolean bl = _tripleEquals = _size == (_size_1 = args.size());
        if (_tripleEquals) {
            return 0;
        }
        if (argCount > fparCount) {
            if (fparCount == 0) {
                return 1;
            }
            boolean _isVariadic = ((TFormalParameter)IterableExtensions.last(fpars)).isVariadic();
            if (_isVariadic) {
                return 0;
            }
            return 1;
        }
        boolean _isVariadicOrOptional = fpars.get(argCount).isVariadicOrOptional();
        if (_isVariadicOrOptional) {
            return 0;
        }
        return -1;
    }

    @Check
    public void checkAdditiveExpressionForNonADDs(AdditiveExpression ae) {
        AdditiveOperator _op = ae.getOp();
        boolean _equals = Objects.equal((Object)_op, (Object)AdditiveOperator.SUB);
        if (_equals) {
            this.doCheckMathOperandTypes(ae.getLhs(), ae.getRhs());
        } else {
            this.doCheckMathOperandTypeSymbol(ae.getLhs(), ae.getRhs());
        }
    }

    @Check
    public void checkMultiplicativeExpression(MultiplicativeExpression me) {
        this.doCheckMathOperandTypes(me.getLhs(), me.getRhs());
    }

    @Check
    public void checkShiftExpression(ShiftExpression se) {
        this.doCheckMathOperandTypes(se.getLhs(), se.getRhs());
    }

    public void doCheckMathOperandTypes(Expression lhs, Expression rhs) {
        PrimitiveType _symbolType_1;
        Type _declaredType_5;
        boolean _equals_1;
        PrimitiveType _symbolType;
        Type _declaredType_4;
        boolean _equals;
        NullType _nullType_1;
        Type _declaredType_3;
        boolean _tripleEquals_3;
        NullType _nullType;
        Type _declaredType_2;
        boolean _tripleEquals_2;
        UndefinedType _undefinedType_1;
        Type _declaredType_1;
        boolean _tripleEquals_1;
        UndefinedType _undefinedType;
        boolean _tripleEquals;
        if (lhs == null || rhs == null) {
            return;
        }
        TypeRef tlhs = this.ts.tau((TypableElement)lhs);
        if (tlhs == null) {
            return;
        }
        TypeRef trhs = this.ts.tau((TypableElement)rhs);
        if (trhs == null) {
            return;
        }
        BuiltInTypeScope bits = BuiltInTypeScope.get((ResourceSet)lhs.eResource().getResourceSet());
        Type _declaredType = tlhs.getDeclaredType();
        boolean bl = _tripleEquals = _declaredType == (_undefinedType = bits.getUndefinedType());
        if (_tripleEquals) {
            this.issueMathResultIsConstant("of type undefined", "NaN", lhs);
        }
        boolean bl2 = _tripleEquals_1 = (_declaredType_1 = trhs.getDeclaredType()) == (_undefinedType_1 = bits.getUndefinedType());
        if (_tripleEquals_1) {
            this.issueMathResultIsConstant("of type undefined", "NaN", rhs);
        }
        boolean bl3 = _tripleEquals_2 = (_declaredType_2 = tlhs.getDeclaredType()) == (_nullType = bits.getNullType());
        if (_tripleEquals_2) {
            this.issueMathOperandIsConstant("null", "0", lhs);
        }
        boolean bl4 = _tripleEquals_3 = (_declaredType_3 = trhs.getDeclaredType()) == (_nullType_1 = bits.getNullType());
        if (_tripleEquals_3) {
            this.issueMathOperandIsConstant("null", "0", rhs);
        }
        if (_equals = Objects.equal((Object)(_declaredType_4 = tlhs.getDeclaredType()), (Object)(_symbolType = bits.getSymbolType()))) {
            this.issueMathOperandTypeNotPermitted("symbol", lhs);
        }
        if (_equals_1 = Objects.equal((Object)(_declaredType_5 = trhs.getDeclaredType()), (Object)(_symbolType_1 = bits.getSymbolType()))) {
            this.issueMathOperandTypeNotPermitted("symbol", rhs);
        }
    }

    public void doCheckMathOperandTypeSymbol(Expression lhs, Expression rhs) {
        PrimitiveType _symbolType_1;
        Type _declaredType_1;
        boolean _equals_1;
        PrimitiveType _symbolType;
        if (lhs == null || rhs == null) {
            return;
        }
        TypeRef tlhs = this.ts.tau((TypableElement)lhs);
        if (tlhs == null) {
            return;
        }
        TypeRef trhs = this.ts.tau((TypableElement)rhs);
        if (trhs == null) {
            return;
        }
        BuiltInTypeScope bits = BuiltInTypeScope.get((ResourceSet)lhs.eResource().getResourceSet());
        Type _declaredType = tlhs.getDeclaredType();
        boolean _equals = Objects.equal((Object)_declaredType, (Object)(_symbolType = bits.getSymbolType()));
        if (_equals) {
            this.issueMathOperandTypeNotPermitted("symbol", lhs);
        }
        if (_equals_1 = Objects.equal((Object)(_declaredType_1 = trhs.getDeclaredType()), (Object)(_symbolType_1 = bits.getSymbolType()))) {
            this.issueMathOperandTypeNotPermitted("symbol", rhs);
        }
    }

    public void issueMathResultIsConstant(String operand, String constResult, Expression location) {
        this.addIssue(IssueCodes.getMessageForEXP_MATH_OPERATION_RESULT_IS_CONSTANT(operand, constResult), (EObject)location, "EXP_MATH_OPERATION_RESULT_IS_CONSTANT");
    }

    public void issueMathOperandIsConstant(String operandType, String constValue, Expression location) {
        this.addIssue(IssueCodes.getMessageForEXP_MATH_OPERAND_IS_CONSTANT(operandType, constValue), (EObject)location, "EXP_MATH_OPERAND_IS_CONSTANT");
    }

    public void issueMathOperandTypeNotPermitted(String operandType, Expression location) {
        this.addIssue(IssueCodes.getMessageForEXP_MATH_TYPE_NOT_PERMITTED(operandType), (EObject)location, "EXP_MATH_TYPE_NOT_PERMITTED");
    }

    @Check
    public void checkEqualityExpressionForConstantValues(EqualityExpression ee) {
        if (ee.getOp() == EqualityOperator.SAME || ee.getOp() == EqualityOperator.NSAME) {
            boolean _isExtendable_1;
            boolean _isExtendable;
            RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)ee);
            TypeRef tlhs = this.ts.type(G, (TypableElement)ee.getLhs());
            TypeRef trhs = this.ts.type(G, (TypableElement)ee.getRhs());
            tlhs = this.ts.upperBound(G, (TypeArgument)tlhs);
            trhs = this.ts.upperBound(G, (TypeArgument)trhs);
            boolean leftSubOfRight = this.ts.subtypeSucceeded(G, (TypeArgument)tlhs, (TypeArgument)trhs);
            boolean rightSubOfLeft = this.ts.subtypeSucceeded(G, (TypeArgument)trhs, (TypeArgument)tlhs);
            Set<Type> tdLhs = this.computeDeclaredTypeS(tlhs);
            Set<Type> tdRhs = this.computeDeclaredTypeS(trhs);
            boolean leftROI = this.hasInterface(tdLhs);
            boolean rightROI = this.hasInterface(tdRhs);
            if (leftROI && rightROI) {
                return;
            }
            if ((leftROI || rightROI) && (leftROI ? (_isExtendable = this.isExtendable(tdRhs)) : (_isExtendable_1 = this.isExtendable(tdLhs)))) {
                return;
            }
            if (!leftSubOfRight && !rightSubOfLeft) {
                String _warningNameOf = this.warningNameOf(tlhs);
                String _warningNameOf_1 = this.warningNameOf(trhs);
                EqualityOperator _op = ee.getOp();
                boolean _tripleEquals = _op == EqualityOperator.NSAME;
                this.addIssue(IssueCodes.getMessageForEXP_WARN_CONSTANT_EQUALITY_TEST(_warningNameOf, _warningNameOf_1, _tripleEquals), (EObject)ee, "EXP_WARN_CONSTANT_EQUALITY_TEST");
            }
        }
    }

    private boolean isExtendable(Set<Type> types) {
        Functions.Function1 _function = it -> this.isExtendable((Type)it);
        return IterableExtensions.exists(types, (Functions.Function1)_function);
    }

    private boolean isExtendable(Type t) {
        boolean _isNotExtendable = this.isNotExtendable(t);
        return !_isNotExtendable;
    }

    private boolean isNotExtendable(Type t) {
        return t instanceof PrimitiveType || t instanceof TEnum || t instanceof BuiltInType || t instanceof TFunction;
    }

    private boolean hasInterface(Set<Type> types) {
        Functions.Function1 _function = it -> this.hasInterface((Type)it);
        return IterableExtensions.exists(types, (Functions.Function1)_function);
    }

    private boolean hasInterface(Type type) {
        boolean _switchResult = false;
        boolean _matched = false;
        if (type instanceof TInterface) {
            _matched = true;
            _switchResult = true;
        }
        if (!_matched) {
            _switchResult = false;
        }
        return _switchResult;
    }

    private String warningNameOf(TypeRef typeRef) {
        String _xifexpression = null;
        if (typeRef instanceof TypeTypeRef) {
            _xifexpression = ((TypeTypeRef)typeRef).getTypeRefAsString();
        } else {
            String _xblockexpression = null;
            Set<Type> typeS = this.computeDeclaredTypeS(typeRef);
            _xifexpression = _xblockexpression = this.warningNameOf(typeS);
        }
        return _xifexpression;
    }

    private String warningNameOf(Set<Type> tset) {
        boolean _tripleEquals;
        String _xifexpression = null;
        int _size = tset.size();
        boolean bl = _tripleEquals = _size == 1;
        if (_tripleEquals) {
            _xifexpression = this.warningNameOf(tset.iterator().next());
        } else {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("{");
            boolean _hasElements = false;
            for (Type s : tset) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)",", "");
                }
                _builder.append(" ");
                String _warningNameOf = this.warningNameOf(s);
                _builder.append(_warningNameOf);
                _builder.append(" ");
            }
            _builder.append("}");
            _xifexpression = _builder.toString();
        }
        return _xifexpression;
    }

    private String warningNameOf(Type t) {
        String _string;
        String _xblockexpression = null;
        String _elvis = null;
        String _xifexpression = null;
        _xifexpression = t == null ? "<type null>" : t.getName();
        _elvis = _xifexpression != null ? _xifexpression : (_string = t.toString());
        String repr = _elvis;
        String _switchResult = null;
        boolean _matched = false;
        if (t instanceof TStructuralType) {
            _matched = true;
            _switchResult = "'structural type'";
        }
        if (!_matched && t instanceof TFunction) {
            _matched = true;
            _switchResult = "function " + repr;
        }
        if (!_matched) {
            _switchResult = repr;
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    private Set<Type> computeDeclaredTypeS(TypeRef tref) {
        if (tref instanceof ComposedTypeRef) {
            Comparator _function = (a, b) -> {
                int _xifexpression = 0;
                if (a == null) {
                    _xifexpression = 1;
                } else {
                    int _xifexpression_1 = 0;
                    if (b == null) {
                        _xifexpression_1 = -1;
                    } else {
                        Comparator<String> _nullsLast = Comparator.nullsLast(Comparator.naturalOrder());
                        String _typeAsString = null;
                        if (a != null) {
                            _typeAsString = a.getTypeAsString();
                        }
                        String _typeAsString_1 = null;
                        if (b != null) {
                            _typeAsString_1 = b.getTypeAsString();
                        }
                        _xifexpression_1 = _nullsLast.compare(_typeAsString, _typeAsString_1);
                    }
                    _xifexpression = _xifexpression_1;
                }
                return _xifexpression;
            };
            TreeSet retSet = CollectionLiterals.newTreeSet((Comparator)_function);
            Consumer<TypeRef> _function_1 = it -> retSet.addAll(this.computeDeclaredTypeS((TypeRef)it));
            ((ComposedTypeRef)tref).getTypeRefs().forEach(_function_1);
            return retSet;
        }
        if (tref instanceof BoundThisTypeRef) {
            return Collections.singleton(((BoundThisTypeRef)tref).getActualThisTypeRef().getDeclaredType());
        }
        return Collections.singleton(tref.getDeclaredType());
    }

    @Check
    public void checkBinaryLogicalExpression(BinaryLogicalExpression e) {
        if (e == null || e.getLhs() == null || e.getRhs() == null) {
            return;
        }
        RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)e);
        this.doCheckForbiddenType(e.getLhs(), (Type)RuleEnvironmentExtensions.nullType(G), "null");
        this.doCheckForbiddenType(e.getLhs(), (Type)RuleEnvironmentExtensions.undefinedType(G), "undefined");
    }

    private void doCheckForbiddenType(Expression e, Type forbidden, String typeName) {
        if (forbidden != null) {
            Type theType;
            TypeRef _tau = this.ts.tau((TypableElement)e);
            Type _declaredType = null;
            if (_tau != null) {
                _declaredType = _tau.getDeclaredType();
            }
            if ((theType = _declaredType) == forbidden) {
                this.addIssue(IssueCodes.getMessageForEXP_FORBIDDEN_TYPE_IN_BINARY_LOGICAL_EXPRESSION(typeName), (EObject)e, "EXP_FORBIDDEN_TYPE_IN_BINARY_LOGICAL_EXPRESSION");
            }
        }
    }

    @Check
    public void checkConditionalExpression(ConditionalExpression e) {
        Expression expressionToCheck = e.getExpression();
        if (expressionToCheck == null) {
            return;
        }
        RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)e);
        TypeRef _tau = this.ts.tau((TypableElement)expressionToCheck);
        Type _declaredType = null;
        if (_tau != null) {
            _declaredType = _tau.getDeclaredType();
        }
        Type declaredT = _declaredType;
        ConstBoolean cboolValue = ConstBoolean.NotPrecomputable;
        cboolValue = declaredT == RuleEnvironmentExtensions.nullType(G) || declaredT == RuleEnvironmentExtensions.voidType(G) || declaredT == RuleEnvironmentExtensions.undefinedType(G) ? ConstBoolean.CFalse : this.evalConstantBooleanExpression(expressionToCheck);
        if (cboolValue == ConstBoolean.NotPrecomputable) {
            return;
        }
        String msg1 = "?!?";
        String msg2 = "?!?";
        if (cboolValue == ConstBoolean.CTrue) {
            msg1 = "true";
            msg2 = "left-hand";
        } else {
            msg1 = "false";
            msg2 = "right-hand";
        }
        this.addIssue(IssueCodes.getMessageForEXP_WARN_DISPENSABLE_CONDITIONAL_EXPRESSION(NodeModelUtils.findActualNodeFor((EObject)expressionToCheck).getText().trim(), msg1, msg2), (EObject)expressionToCheck, "EXP_WARN_DISPENSABLE_CONDITIONAL_EXPRESSION");
    }

    private ConstBoolean evalConstantBooleanExpression(Expression e) {
        if (e instanceof BooleanLiteral) {
            boolean _isTrue = ((BooleanLiteral)e).isTrue();
            if (_isTrue) {
                return ConstBoolean.CTrue;
            }
            return ConstBoolean.CFalse;
        }
        if (e instanceof NumericLiteral) {
            BigDecimal v = ((NumericLiteral)e).getValue();
            boolean _equals = Objects.equal((Object)v, (Object)0);
            if (_equals) {
                return ConstBoolean.CFalse;
            }
            return ConstBoolean.CTrue;
        }
        if (e instanceof IdentifierRef) {
            boolean _equals_1;
            IdentifiableElement _id = null;
            if ((IdentifierRef)e != null) {
                _id = ((IdentifierRef)e).getId();
            }
            String _name = null;
            if (_id != null) {
                _name = _id.getName();
            }
            if (_equals_1 = Objects.equal((Object)_name, (Object)"NaN")) {
                return ConstBoolean.CFalse;
            }
        } else {
            if (e instanceof StringLiteral) {
                boolean _isEmpty = ((StringLiteral)e).getValue().isEmpty();
                if (_isEmpty) {
                    return ConstBoolean.CFalse;
                }
                return ConstBoolean.CTrue;
            }
            if (e instanceof ObjectLiteral) {
                return ConstBoolean.CTrue;
            }
        }
        return ConstBoolean.NotPrecomputable;
    }

    @Check
    public void checkCastExpression(CastExpression castExpression) {
        boolean _tripleEquals;
        Expression _expression = castExpression.getExpression();
        boolean bl = _tripleEquals = _expression == null;
        if (_tripleEquals) {
            return;
        }
        TypeRef S = this.ts.tau((TypableElement)castExpression.getExpression(), (EObject)castExpression);
        TypeRef T = castExpression.getTargetTypeRef();
        if (S == null || T == null || T instanceof UnknownTypeRef || S instanceof UnknownTypeRef) {
            return;
        }
        RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)castExpression);
        boolean _subtypeSucceeded = this.ts.subtypeSucceeded(G, (TypeArgument)S, (TypeArgument)T);
        if (_subtypeSucceeded) {
            this.addIssue(IssueCodes.getMessageForEXP_CAST_UNNECESSARY(S.getTypeRefAsString(), T.getTypeRefAsString()), (EObject)castExpression, "EXP_CAST_UNNECESSARY");
        } else {
            boolean specialChecks;
            boolean bl2 = specialChecks = T.getDeclaredType() instanceof ContainerType || T.getDeclaredType() instanceof TEnum || T.getDeclaredType() instanceof TypeVariable || T instanceof TypeTypeRef || T instanceof UnionTypeExpression || T instanceof FunctionTypeExpression || T instanceof IntersectionTypeExpression;
            if (specialChecks) {
                this.internalCheckCastExpression(G, S, T, castExpression, true, false);
            } else {
                this.addIssue(IssueCodes.getMessageForEXP_CAST_INVALID_TARGET(), (EObject)castExpression, "EXP_CAST_INVALID_TARGET");
            }
        }
    }

    private boolean internalCheckCastExpression(RuleEnvironment G, TypeRef S, TypeRef T, CastExpression castExpression, boolean addIssues, boolean actualSourceTypeIsCPOE) {
        if (T instanceof UnionTypeExpression) {
            boolean _not;
            Functions.Function1 _function = it -> this.internalCheckCastExpression(G, S, (TypeRef)it, castExpression, false, actualSourceTypeIsCPOE);
            boolean _exists = IterableExtensions.exists((Iterable)((UnionTypeExpression)T).getTypeRefs(), (Functions.Function1)_function);
            boolean bl = _not = !_exists;
            if (_not) {
                if (addIssues) {
                    this.addIssue(IssueCodes.getMessageForEXP_CAST_FAILED(S.getTypeRefAsString(), ((UnionTypeExpression)T).getTypeRefAsString()), (EObject)castExpression, "EXP_CAST_FAILED");
                }
                return false;
            }
        } else if (T instanceof IntersectionTypeExpression) {
            boolean _not_1;
            Functions.Function1 _function_1 = it -> this.internalCheckCastExpression(G, S, (TypeRef)it, castExpression, false, actualSourceTypeIsCPOE);
            boolean _forall = IterableExtensions.forall((Iterable)((IntersectionTypeExpression)T).getTypeRefs(), (Functions.Function1)_function_1);
            boolean bl = _not_1 = !_forall;
            if (_not_1) {
                if (addIssues) {
                    this.addIssue(IssueCodes.getMessageForEXP_CAST_FAILED(S.getTypeRefAsString(), ((IntersectionTypeExpression)T).getTypeRefAsString()), (EObject)castExpression, "EXP_CAST_FAILED");
                }
                return false;
            }
        } else if (S instanceof ComposedTypeRef) {
            if (!IterableExtensions.exists((Iterable)((ComposedTypeRef)S).getTypeRefs(), it -> this.internalCheckCastExpression(G, (TypeRef)it, T, castExpression, false, actualSourceTypeIsCPOE || S instanceof IntersectionTypeExpression && IterableExtensions.exists((Iterable)((ComposedTypeRef)S).getTypeRefs(), it_1 -> this.isCPOE(G, (TypeRef)it_1)))) && !IterableExtensions.exists((Iterable)((ComposedTypeRef)S).getTypeRefs(), it -> this.ts.subtypeSucceeded(G, (TypeArgument)it, (TypeArgument)T))) {
                if (addIssues) {
                    this.addIssue(IssueCodes.getMessageForEXP_CAST_FAILED(((ComposedTypeRef)S).getTypeRefAsString(), T.getTypeRefAsString()), (EObject)castExpression, "EXP_CAST_FAILED");
                }
                return false;
            }
        } else {
            boolean _canCheck = this.canCheck(G, S, T, actualSourceTypeIsCPOE);
            if (_canCheck) {
                boolean castOK = this.ts.subtypeSucceeded(G, (TypeArgument)T, (TypeArgument)S);
                if (!castOK && T instanceof ParameterizedTypeRef && S instanceof ParameterizedTypeRef) {
                    Type _declaredType_1;
                    ParameterizedTypeRef ptrT = (ParameterizedTypeRef)T;
                    ParameterizedTypeRef ptrS = (ParameterizedTypeRef)S;
                    Type _declaredType = ptrS.getDeclaredType();
                    boolean _equals = Objects.equal((Object)_declaredType, (Object)(_declaredType_1 = ptrT.getDeclaredType()));
                    if (_equals) {
                        int _size;
                        boolean _tripleEquals;
                        int to = ptrS.getTypeArgs().size();
                        boolean bl = _tripleEquals = to == (_size = ptrT.getTypeArgs().size());
                        if (_tripleEquals) {
                            int i = 0;
                            while (i < to && this.ts.subtypeSucceeded(G, (TypeArgument)ptrT.getTypeArgs().get(i), (TypeArgument)ptrS.getTypeArgs().get(i))) {
                                ++i;
                            }
                            if (i == to) {
                                castOK = true;
                            } else {
                                i = 0;
                                while (i < to && this.ts.subtypeSucceeded(G, (TypeArgument)ptrS.getTypeArgs().get(i), (TypeArgument)ptrT.getTypeArgs().get(i))) {
                                    ++i;
                                }
                                boolean bl2 = castOK = i == to;
                            }
                        }
                    }
                }
                if (!castOK) {
                    if (addIssues) {
                        this.addIssue(IssueCodes.getMessageForEXP_CAST_FAILED(S.getTypeRefAsString(), T.getTypeRefAsString()), (EObject)castExpression, "EXP_CAST_FAILED");
                    }
                    return false;
                }
            } else if (T.getDeclaredType() instanceof TypeVariable && ((TypeVariable)T.getDeclaredType()).getDeclaredUpperBound() != null) {
                boolean _not_2;
                Type _declaredType_2 = T.getDeclaredType();
                TypeVariable typeVariable = (TypeVariable)_declaredType_2;
                boolean _internalCheckCastExpression = this.internalCheckCastExpression(G, S, typeVariable.getDeclaredUpperBound(), castExpression, false, actualSourceTypeIsCPOE);
                boolean bl = _not_2 = !_internalCheckCastExpression;
                if (_not_2) {
                    if (addIssues) {
                        this.addIssue(IssueCodes.getMessageForEXP_CAST_FAILED(S.getTypeRefAsString(), T.getTypeRefAsString()), (EObject)castExpression, "EXP_CAST_FAILED");
                    }
                    return false;
                }
            }
        }
        return true;
    }

    private boolean canCheck(RuleEnvironment G, TypeRef S, TypeRef T, boolean actualSourceTypeIsCPOE) {
        return T instanceof FunctionTypeExpression || (actualSourceTypeIsCPOE || this.isCPOE(G, S)) && this.isCPOE(G, T) || S.getDeclaredType() instanceof TInterface && this.isActuallyFinal(T) || this.isActuallyFinal(S) && T.getDeclaredType() instanceof TInterface || S instanceof ParameterizedTypeRef && T instanceof ParameterizedTypeRef && TypeUtils.isRawSuperType((Type)T.getDeclaredType(), (Type)S.getDeclaredType());
    }

    private boolean isCPOE(RuleEnvironment G, TypeRef T) {
        Type d = null;
        if (T instanceof BoundThisTypeRef) {
            ParameterizedTypeRef _actualThisTypeRef = ((BoundThisTypeRef)T).getActualThisTypeRef();
            Type _declaredType = null;
            if (_actualThisTypeRef != null) {
                _declaredType = _actualThisTypeRef.getDeclaredType();
            }
            d = _declaredType;
        }
        if (T instanceof ParameterizedTypeRef) {
            d = ((ParameterizedTypeRef)T).getDeclaredType();
        }
        if (T instanceof TypeTypeRef) {
            d = this.tsh.getStaticType(G, (TypeTypeRef)T);
        }
        if (d != null) {
            boolean concreteMetaType = d instanceof TClass || d instanceof TEnum || d instanceof PrimitiveType || d instanceof TObjectPrototype;
            return concreteMetaType;
        }
        return false;
    }

    private boolean isActuallyFinal(TypeRef typeRef) {
        return typeRef.isFinalByType() && !(typeRef.getDeclaredType() instanceof TypeVariable);
    }

    @Check
    public void checkIndexedAccessExpression(IndexedAccessExpression indexedAccess) {
        boolean _not;
        boolean _requireCheckIndexedAccessExpression = this.jsVariantHelper.requireCheckIndexedAccessExpression((EObject)indexedAccess);
        boolean bl = _not = !_requireCheckIndexedAccessExpression;
        if (_not) {
            return;
        }
        Expression target = indexedAccess.getTarget();
        Expression index = indexedAccess.getIndex();
        if (target == null || index == null) {
            return;
        }
        if (index instanceof IdentifierRef && (((IdentifierRef)index).getId() == null || ((IdentifierRef)index).getId().eIsProxy())) {
            return;
        }
        if (index instanceof ParameterizedPropertyAccessExpression && (((ParameterizedPropertyAccessExpression)index).getProperty() == null || ((ParameterizedPropertyAccessExpression)index).getProperty().eIsProxy())) {
            return;
        }
        if (target instanceof SuperLiteral) {
            return;
        }
        RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)indexedAccess);
        TypeRef targetTypeRefRaw = this.ts.type(G, (TypableElement)target);
        if (targetTypeRefRaw instanceof UnknownTypeRef) {
            return;
        }
        TypeRef targetTypeRef = this.ts.resolveType(G, (TypeArgument)targetTypeRefRaw);
        TypeRef indexTypeRef = this.ts.type(G, (TypableElement)index);
        if (indexTypeRef instanceof UnknownTypeRef) {
            return;
        }
        Type targetDeclType = targetTypeRef.getDeclaredType();
        boolean targetIsLiteralOfStringBasedEnum = targetDeclType instanceof TEnum && AnnotationDefinition.STRING_BASED.hasAnnotation((TAnnotableElement)targetDeclType);
        TField accessedBuiltInSymbol = N4JSLanguageUtils.getAccessedBuiltInSymbol(G, index);
        Type _xifexpression = null;
        if (targetTypeRef instanceof TypeTypeRef) {
            _xifexpression = this.tsh.getStaticType(G, (TypeTypeRef)targetTypeRef);
        }
        Type accessedStaticType = _xifexpression;
        boolean indexIsNumeric = this.ts.subtypeSucceeded(G, (TypeArgument)indexTypeRef, (TypeArgument)RuleEnvironmentExtensions.numberTypeRef(G));
        CompileTimeValue indexValue = ASTMetaInfoUtils.getCompileTimeValue(index);
        boolean _isDynamic = targetTypeRef.isDynamic();
        if (!_isDynamic && (RuleEnvironmentExtensions.objectType(G) != targetDeclType || targetTypeRef.isUseSiteStructuralTyping())) {
            if (accessedStaticType instanceof TEnum) {
                this.addIssue(IssueCodes.getMessageForEXP_INDEXED_ACCESS_ENUM(), (EObject)indexedAccess, "EXP_INDEXED_ACCESS_ENUM");
            } else if (!indexIsNumeric || !targetTypeRef.isArrayLike() && !targetIsLiteralOfStringBasedEnum) {
                if (accessedBuiltInSymbol != null) {
                    this.internalCheckIndexedAccessWithSymbol(G, indexedAccess, targetTypeRef, accessedBuiltInSymbol);
                } else {
                    boolean _isValid = indexValue.isValid();
                    if (_isValid) {
                        this.internalCheckComputedIndexedAccess(G, indexedAccess, targetTypeRef, indexValue, indexIsNumeric);
                    } else {
                        this.createIssuesForEvalErrors((CompileTimeEvaluationError[])Conversions.unwrapArray(((CompileTimeValue.ValueInvalid)indexValue).getErrors(), CompileTimeEvaluationError.class));
                    }
                }
            }
        }
    }

    private void internalCheckComputedIndexedAccess(RuleEnvironment G, IndexedAccessExpression indexedAccess, TypeRef receiverTypeRef, CompileTimeValue indexValue, boolean indexIsNumeric) {
        EObject member;
        boolean isNonExistentMember;
        String memberName = N4JSLanguageUtils.derivePropertyNameFromCompileTimeValue(indexValue);
        boolean _equals = Objects.equal((Object)"#iterator", (Object)memberName);
        if (_equals) {
            this.addIssue(IssueCodes.getMessageForEXP_INDEXED_ACCESS_IMPL_RESTRICTION(), (EObject)indexedAccess, "EXP_INDEXED_ACCESS_IMPL_RESTRICTION");
            return;
        }
        boolean _isDynamic = receiverTypeRef.isDynamic();
        if (_isDynamic) {
            return;
        }
        boolean checkVisibility = true;
        boolean staticAccess = receiverTypeRef instanceof TypeTypeRef;
        TypingStrategy _typingStrategy = receiverTypeRef.getTypingStrategy();
        boolean structFieldInitMode = _typingStrategy == TypingStrategy.STRUCTURAL_FIELD_INITIALIZER;
        IScope scope = this.memberScopingHelper.createMemberScope(receiverTypeRef, (MemberAccess)indexedAccess, true, staticAccess, structFieldInitMode);
        IEObjectDescription _xifexpression = null;
        if (memberName != null && !memberName.isEmpty()) {
            _xifexpression = scope.getSingleElement(this.qualifiedNameConverter.toQualifiedName(memberName));
        }
        IEObjectDescription memberDesc = _xifexpression;
        EObject _eObjectOrProxy = null;
        if (memberDesc != null) {
            _eObjectOrProxy = memberDesc.getEObjectOrProxy();
        }
        boolean bl = isNonExistentMember = (member = _eObjectOrProxy) == null || member.eIsProxy();
        if (isNonExistentMember) {
            if (indexIsNumeric) {
                this.addIssue(IssueCodes.getMessageForEXP_INDEXED_ACCESS_FORBIDDEN(), (EObject)indexedAccess, "EXP_INDEXED_ACCESS_FORBIDDEN");
            } else {
                this.addIssue(IssueCodes.getMessageForEXP_INDEXED_ACCESS_COMPUTED_NOTFOUND(memberName), (EObject)indexedAccess, "EXP_INDEXED_ACCESS_COMPUTED_NOTFOUND");
            }
            return;
        }
        IEObjectDescriptionWithError errorDesc = IEObjectDescriptionWithError.getDescriptionWithError((IEObjectDescription)memberDesc);
        if (errorDesc != null) {
            this.addIssue(errorDesc.getMessage(), (EObject)indexedAccess, errorDesc.getIssueCode());
        }
    }

    private boolean internalCheckIndexedAccessWithSymbol(RuleEnvironment G, IndexedAccessExpression indexedAccess, TypeRef receiverTypeRef, TField accessedBuiltInSymbol) {
        boolean writeAccess;
        boolean _tripleNotEquals;
        Functions.Function1 _function = it -> {
            String _name = it.getName();
            return Objects.equal((Object)_name, (Object)"iterator");
        };
        TMember _findFirst = (TMember)IterableExtensions.findFirst((Iterable)RuleEnvironmentExtensions.symbolObjectType(G).getOwnedMembers(), (Functions.Function1)_function);
        boolean bl = _tripleNotEquals = accessedBuiltInSymbol != _findFirst;
        if (_tripleNotEquals) {
            this.addIssue(IssueCodes.getMessageForEXP_INDEXED_ACCESS_SYMBOL_INVALID(), (EObject)indexedAccess, "EXP_INDEXED_ACCESS_SYMBOL_INVALID");
            return false;
        }
        boolean isIterable = this.ts.subtypeSucceeded(G, (TypeArgument)receiverTypeRef, (TypeArgument)RuleEnvironmentExtensions.iterableTypeRef(G, new TypeArgument[]{TypeRefsFactory.eINSTANCE.createWildcard()}));
        boolean isObjectImmediate = receiverTypeRef.getDeclaredType() == RuleEnvironmentExtensions.objectType(G) && receiverTypeRef.getTypingStrategy() == TypingStrategy.NOMINAL;
        boolean isDynamic = receiverTypeRef.isDynamic();
        if (!(isIterable || isObjectImmediate || isDynamic)) {
            this.addIssue(IssueCodes.getMessageForEXP_INDEXED_ACCESS_SYMBOL_WRONG_TYPE(), (EObject)indexedAccess, "EXP_INDEXED_ACCESS_SYMBOL_WRONG_TYPE");
            return false;
        }
        if (!isObjectImmediate && !isDynamic && (writeAccess = ExpressionExtensions.isLeftHandSide((EObject)indexedAccess))) {
            this.addIssue(IssueCodes.getMessageForEXP_INDEXED_ACCESS_SYMBOL_READONLY(), (EObject)indexedAccess, "EXP_INDEXED_ACCESS_SYMBOL_READONLY");
            return false;
        }
        return true;
    }

    @Check
    public Object checkAssignmentExpression(AssignmentExpression assExpr) {
        boolean _holdsLefthandsideNotConst;
        Object _xblockexpression = null;
        Expression lhs = assExpr.getLhs();
        boolean _and = false;
        boolean _holdsWritableIdentifier = this.holdsWritableIdentifier(lhs);
        _and = !_holdsWritableIdentifier ? false : (_holdsLefthandsideNotConst = this.holdsLefthandsideNotConst(lhs));
        Expression rhs = assExpr.getRhs();
        Object _xifexpression = null;
        if (rhs instanceof IdentifierRef) {
            Object _xblockexpression_1 = null;
            IdentifiableElement id = ((IdentifierRef)rhs).getId();
            Object _switchResult = null;
            boolean _matched = false;
            if (id instanceof TMethod) {
                _matched = true;
                _switchResult = null;
            }
            if (!_matched && id instanceof TFunction) {
                _matched = true;
                Procedures.Procedure4 _function = (message, source, feature, issueCode) -> this.addIssue((String)message, (EObject)source, (EStructuralFeature)feature, (String)issueCode, new String[0]);
                N4JSExpressionValidator.internalCheckNameRestrictionInMethodBodies((IdentifierRef)rhs, (Procedures.Procedure4<? super String, ? super EObject, ? super EStructuralFeature, ? super String>)_function);
            }
            _xifexpression = _xblockexpression_1 = _switchResult;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private boolean holdsLefthandsideNotConst(Expression lhs) {
        if (lhs instanceof ParenExpression) {
            return this.holdsLefthandsideNotConst(((ParenExpression)lhs).getExpression());
        }
        if (lhs instanceof IdentifierRef) {
            return this.holdsLefthandsideNotConst((IdentifierRef)lhs);
        }
        return true;
    }

    private boolean holdsLefthandsideNotConst(IdentifierRef lhs) {
        boolean _isConst;
        IdentifiableElement id = lhs.getId();
        boolean _matched = false;
        if (id instanceof VariableDeclaration && (_isConst = ((VariableDeclaration)id).isConst())) {
            _matched = true;
            this.addIssue(IssueCodes.getMessageForEXP_ASSIGN_CONST_VARIABLE(((VariableDeclaration)id).getName()), (EObject)lhs, "EXP_ASSIGN_CONST_VARIABLE");
            return false;
        }
        if (!_matched && id instanceof TVariable && (_isConst = ((TVariable)id).isConst())) {
            _matched = true;
            this.addIssue(IssueCodes.getMessageForEXP_ASSIGN_CONST_VARIABLE(((TVariable)id).getName()), (EObject)lhs, "EXP_ASSIGN_CONST_VARIABLE");
            return false;
        }
        if (!_matched && id instanceof TField) {
            boolean _not;
            boolean _isWriteable = ((TField)id).isWriteable();
            boolean bl = _not = !_isWriteable;
            if (_not) {
                _matched = true;
                this.addIssue(IssueCodes.getMessageForVIS_WRONG_READ_WRITE_ACCESS("built-in constant", ((TField)id).getName(), "read-only"), (EObject)lhs, "VIS_WRONG_READ_WRITE_ACCESS");
                return false;
            }
        }
        return true;
    }

    @Check
    public void checkPromisify(PromisifyExpression promiExpr) {
        boolean _not;
        boolean _isPromisifiableExpression = this.promisifyHelper.isPromisifiableExpression(promiExpr.getExpression());
        boolean bl = _not = !_isPromisifiableExpression;
        if (_not) {
            this.addIssue(IssueCodes.getMessageForEXP_PROMISIFY_INVALID_USE(), (EObject)promiExpr, "EXP_PROMISIFY_INVALID_USE");
        }
    }

    @Check
    public void checkThisLiteral(ThisLiteral thisLiteral) {
        ThisArgProvider context = (ThisArgProvider)EcoreUtil2.getContainerOfType((EObject)thisLiteral, ThisArgProvider.class);
        while (context instanceof ArrowFunction) {
            context = (ThisArgProvider)EcoreUtil2.getContainerOfType((EObject)((ArrowFunction)context).eContainer(), ThisArgProvider.class);
        }
        if (context instanceof N4MemberDeclaration) {
            boolean _isStatic;
            TMember tMember = ((N4MemberDeclaration)context).getDefinedTypeElement();
            boolean _and = false;
            ContainerType _containingType = null;
            if (tMember != null) {
                _containingType = tMember.getContainingType();
            }
            if (_and = !(_containingType instanceof TInterface) ? false : (_isStatic = tMember.isStatic())) {
                String msg = IssueCodes.getMessageForCLF_NO_THIS_IN_STATIC_MEMBER_OF_INTERFACE();
                this.addIssue(msg, (EObject)thisLiteral, "CLF_NO_THIS_IN_STATIC_MEMBER_OF_INTERFACE");
                return;
            }
        }
        if (context instanceof N4FieldDeclaration) {
            boolean _isStatic_1;
            TMember tField = ((N4FieldDeclaration)context).getDefinedTypeElement();
            ContainerType _containingType_1 = null;
            if (tField != null) {
                _containingType_1 = tField.getContainingType();
            }
            if (_containingType_1 instanceof TInterface) {
                String msg_1 = IssueCodes.getMessageForCLF_NO_THIS_IN_FIELD_OF_INTERFACE();
                this.addIssue(msg_1, (EObject)thisLiteral, "CLF_NO_THIS_IN_FIELD_OF_INTERFACE");
                return;
            }
            ContainerType _containingType_2 = null;
            if (tField != null) {
                _containingType_2 = tField.getContainingType();
            }
            if (_containingType_2 instanceof TClass && (_isStatic_1 = tField.isStatic())) {
                String msg_2 = IssueCodes.getMessageForCLF_NO_THIS_IN_STATIC_FIELD();
                this.addIssue(msg_2, (EObject)thisLiteral, "CLF_NO_THIS_IN_STATIC_FIELD");
                return;
            }
        }
    }

    @Check
    public void checkMandatoryCompileTimeExpression(Expression expr) {
        CompileTimeValue evalResult;
        EObject _eContainer = expr.eContainer();
        if (_eContainer instanceof IndexedAccessExpression) {
            return;
        }
        boolean _isMandatoryCompileTimeExpression = N4JSLanguageUtils.isMandatoryCompileTimeExpression(expr);
        if (_isMandatoryCompileTimeExpression && (evalResult = ASTMetaInfoUtils.getCompileTimeValue(expr)) instanceof CompileTimeValue.ValueInvalid) {
            boolean _isExpressionOfComputedPropertyNameInObjectLiteral = this.isExpressionOfComputedPropertyNameInObjectLiteral(expr);
            if (_isExpressionOfComputedPropertyNameInObjectLiteral) {
                this.addIssue(IssueCodes.getMessageForEXP_COMPUTED_PROP_NAME_DISCOURAGED(), (EObject)expr, "EXP_COMPUTED_PROP_NAME_DISCOURAGED");
                return;
            }
            this.createIssuesForEvalErrors((CompileTimeEvaluationError[])Conversions.unwrapArray(((CompileTimeValue.ValueInvalid)evalResult).getErrors(), CompileTimeEvaluationError.class));
        }
    }

    private boolean isExpressionOfComputedPropertyNameInObjectLiteral(Expression expr) {
        EObject exprParent = expr.eContainer();
        return exprParent instanceof LiteralOrComputedPropertyName && exprParent.eContainer() instanceof PropertyAssignment && exprParent.eContainer().eContainer() instanceof ObjectLiteral;
    }

    private void createIssuesForEvalErrors(CompileTimeEvaluationError ... errors) {
        CompileTimeEvaluationError[] compileTimeEvaluationErrorArray = errors;
        int n = errors.length;
        int n2 = 0;
        while (n2 < n) {
            CompileTimeEvaluationError error = compileTimeEvaluationErrorArray[n2];
            this.createIssueForEvalError(error);
            ++n2;
        }
    }

    private void createIssueForEvalError(CompileTimeEvaluationError error) {
        String _xifexpression = null;
        if (error instanceof CompileTimeEvaluator.UnresolvedPropertyAccessError) {
            String _xblockexpression = null;
            ParameterizedPropertyAccessExpression propAccessExpr = ((CompileTimeEvaluator.UnresolvedPropertyAccessError)error).getAstNodeCasted();
            IdentifiableElement prop = propAccessExpr.getProperty();
            String _xifexpression_1 = null;
            _xifexpression_1 = prop == null || prop.eIsProxy() ? null : "reference must point to a directly owned field (i.e. not inherited, consumed, or polyfilled) and the field must not have a computed name";
            _xifexpression = _xblockexpression = _xifexpression_1;
        } else {
            _xifexpression = error.message;
        }
        String message = _xifexpression;
        EObject astNode = error.astNode;
        EStructuralFeature feature = error.feature;
        if (message != null && astNode != null) {
            String msgFull = IssueCodes.getMessageForEXP_COMPILE_TIME_MANDATORY(message);
            this.addIssue(msgFull, astNode, feature, "EXP_COMPILE_TIME_MANDATORY", new String[0]);
        }
    }
}

