/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tester;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.fileextensions.FileExtensionType;
import org.eclipse.n4js.fileextensions.FileExtensionsRegistry;
import org.eclipse.n4js.n4JS.N4MethodDeclaration;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.IN4JSSourceContainer;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.resource.N4JSResourceDescriptionStrategy;
import org.eclipse.n4js.tester.domain.ID;
import org.eclipse.n4js.tester.domain.TestCase;
import org.eclipse.n4js.tester.domain.TestSuite;
import org.eclipse.n4js.tester.domain.TestTree;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.TAnnotableElement;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.n4js.utils.ContainerTypesHelper;
import org.eclipse.n4js.utils.ResourceNameComputer;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;

public class TestDiscoveryHelper {
    @Inject
    private FileExtensionsRegistry fileExtensionRegistry;
    @Inject
    private IN4JSCore n4jsCore;
    @Inject
    private ResourceNameComputer resourceNameComputer;
    @Inject
    private ContainerTypesHelper containerTypesHelper;
    private static final EClass T_CLASS = TypesPackage.eINSTANCE.getTClass();
    private static final Comparator<URI> URI_COMPARATOR = (left, right) -> {
        if (left.hasFragment()) {
            return right.hasFragment() ? left.hashCode() - right.hashCode() : -1;
        }
        if (right.hasFragment()) {
            return left.hasFragment() ? left.hashCode() - right.hashCode() : 1;
        }
        return left.hashCode() - right.hashCode();
    };

    public ID createTestSessionId() {
        return new ID(UUID.randomUUID().toString());
    }

    public boolean isTestable(URI location) {
        if (location == null) {
            return false;
        }
        if (this.isProject(location)) {
            IN4JSProject p = this.n4jsCore.create(location);
            return p.getSourceContainers().stream().anyMatch(IN4JSSourceContainer::isTest);
        }
        if (location.hasFragment()) {
            return this.isTestable(location.trimFragment());
        }
        IN4JSSourceContainer c = (IN4JSSourceContainer)this.n4jsCore.findN4JSSourceContainer(location).orNull();
        if (c == null || !c.isTest()) {
            return false;
        }
        ResourceSet resourceSet = this.n4jsCore.createResourceSet(Optional.of((Object)c.getProject()));
        IResourceDescriptions index = this.n4jsCore.getXtextIndex(resourceSet);
        IResourceDescription rdesc = index.getResourceDescription(location);
        if (rdesc != null) {
            return TestDiscoveryHelper.stream(rdesc.getExportedObjectsByType(T_CLASS)).anyMatch(desc -> this.hasTestMethods(resourceSet, (IEObjectDescription)desc));
        }
        return true;
    }

    public TestTree collectTests(List<URI> uris) {
        ResourceSet resSet = this.n4jsCore.createResourceSet(Optional.absent());
        IResourceDescriptions index = this.n4jsCore.getXtextIndex(resSet);
        return this.collectTests(resSet, index, uris).sort();
    }

    public TestTree collectAllTestsFromWorkspace() {
        LinkedList<URI> testableProjectURIs = new LinkedList<URI>();
        for (IN4JSProject project : this.n4jsCore.findAllProjects()) {
            URI location = project.getLocation().toURI();
            if (!project.exists() || !this.isTestable(location)) continue;
            testableProjectURIs.add(location);
        }
        TestTree collectedTests = this.collectTests(testableProjectURIs);
        return collectedTests;
    }

    private ID createTestCaseId(String testClassFqn, TMethod testMethod) {
        return new ID(String.valueOf(testClassFqn) + "#" + testMethod.getName());
    }

    private List<URI> collectDistinctTestLocations(IResourceDescriptions index, ResourceSet resSet, List<URI> locations) {
        return Lists.newArrayList((Iterable)Sets.newHashSet(locations.stream().flatMap(loc -> this.collectTestLocations(index, resSet, (URI)loc)).iterator()));
    }

    private Stream<URI> collectTestLocations(IResourceDescriptions index, ResourceSet resSet, URI location) {
        if (location == null) {
            return Stream.empty();
        }
        if (this.isProject(location)) {
            IN4JSProject p = this.n4jsCore.create(location);
            return p.getSourceContainers().stream().filter(IN4JSSourceContainer::isTest).flatMap(TestDiscoveryHelper::stream).filter(uri -> this.isTestFile((URI)uri) && this.isTestModule(resSet, index.getResourceDescription(uri)));
        }
        IResourceDescription resDesc = index.getResourceDescription(location.trimFragment());
        if (resDesc != null) {
            IN4JSSourceContainer srcContainer;
            if (this.isTestModule(resSet, resDesc) && (srcContainer = (IN4JSSourceContainer)this.n4jsCore.findN4JSSourceContainer(location.trimFragment()).orNull()) != null && srcContainer.isTest()) {
                return Stream.of(location);
            }
            return Stream.empty();
        }
        IN4JSSourceContainer srcContainer = (IN4JSSourceContainer)this.n4jsCore.findN4JSSourceContainer(location).orNull();
        if (srcContainer != null) {
            if (srcContainer.isTest()) {
                String locationStr = location.toString();
                return TestDiscoveryHelper.stream(srcContainer).filter(uri -> uri.toString().startsWith(locationStr) && this.isTestModule(resSet, index.getResourceDescription(uri)));
            }
            return Stream.empty();
        }
        return Stream.empty();
    }

    private TestTree collectTests(ResourceSet resSet, IResourceDescriptions index, List<URI> locations) {
        LinkedHashMap<String, TestSuite> suites = new LinkedHashMap<String, TestSuite>();
        List<URI> testLocations = this.collectDistinctTestLocations(index, resSet, locations);
        HashMultimap<URI, URI> testLocationMapping = this.createTestLocationMapping(testLocations);
        Map<URI, TModule> moduleUri2Modules = this.loadModules(testLocationMapping.asMap().keySet(), index, resSet);
        for (URI moduleLocation : testLocationMapping.keySet()) {
            TModule module = moduleUri2Modules.get(moduleLocation);
            if (module == null) continue;
            ArrayList testLocationsForModule = Lists.newArrayList((Iterable)testLocationMapping.get((Object)moduleLocation));
            testLocationsForModule.sort(URI_COMPARATOR);
            if (((URI)testLocationsForModule.get(0)).equals(moduleLocation)) {
                this.collectTestCasesAndSuitesForModule(module, suites);
                continue;
            }
            for (URI uri : testLocationsForModule) {
                this.collectTestSuiteAndTestCaseForMethod(uri, module, suites);
            }
        }
        ID sessionId = this.createTestSessionId();
        String name = String.valueOf(sessionId);
        if (!locations.isEmpty()) {
            URI uri = locations.get(0);
            name = String.valueOf(uri.trimFragment()).replaceFirst("platform:/resource/", "");
            if (name.lastIndexOf(46) > 0) {
                name = name.substring(0, name.lastIndexOf(46));
            }
            if (uri.hasFragment() && !suites.isEmpty() && !((TestSuite)suites.values().iterator().next()).getTestCases().isEmpty()) {
                name = String.valueOf(name) + "#" + ((TestSuite)suites.values().iterator().next()).getTestCases().get(0).getDisplayName();
            }
            if (locations.size() > 1) {
                name = String.valueOf(name) + " and " + (locations.size() - 1) + " more";
            }
        }
        return new TestTree(sessionId, suites.values(), name);
    }

    private void collectTestSuiteAndTestCaseForMethod(URI uri, TModule module, Map<String, TestSuite> suites) {
        Type type;
        EObject object = module.eResource().getResourceSet().getEObject(uri, true);
        Object object2 = object instanceof N4MethodDeclaration ? ((N4MethodDeclaration)object).getDefinedType() : (type = object instanceof TMethod ? (TMethod)object : null);
        if (type instanceof TMethod) {
            TMethod method = (TMethod)type;
            TestSuite testSuite = this.addOrCreateSuite((TClass)method.getContainingType(), suites);
            testSuite.add(this.createTestCase(method, module));
        }
    }

    private void collectTestCasesAndSuitesForModule(TModule module, Map<String, TestSuite> suites) {
        for (TClass clazz : FluentIterable.from((Iterable)module.getTopLevelTypes()).filter(TClass.class).filter(c -> !c.isAbstract() && c.isExported())) {
            Iterable<TMethod> testMethods = this.getAllTestMethodsOfClass(clazz);
            if (!testMethods.iterator().hasNext()) continue;
            TestSuite testSuite = this.addOrCreateSuite(clazz, suites);
            for (TMethod method : testMethods) {
                TestCase testCase = this.createTestCase(method, module, this.getTestCatalogNameFor(clazz));
                testSuite.add(testCase);
            }
        }
    }

    private TestSuite addOrCreateSuite(TClass clazz, Map<String, TestSuite> suites) {
        String suiteKey = this.getTestCatalogNameFor(clazz);
        TestSuite suite = suites.get(suiteKey);
        if (suite == null) {
            suite = new TestSuite(suiteKey);
            suites.put(suiteKey, suite);
        }
        return suite;
    }

    private TestCase createTestCase(TMethod method, TModule module) {
        return this.createTestCase(method, module, this.getClassName(method));
    }

    private TestCase createTestCase(TMethod method, TModule module, String clazzFqnStr) {
        TestCase testCase = new TestCase(this.createTestCaseId(clazzFqnStr, method), clazzFqnStr, module.getProjectName(), method.getName(), method.getName(), EcoreUtil.getURI((EObject)method));
        return testCase;
    }

    private String getClassName(TMethod method) {
        return this.getTestCatalogNameFor((TClass)EcoreUtil2.getContainerOfType((EObject)method, TClass.class));
    }

    private String getTestCatalogNameFor(TClass clazz) {
        String output;
        String classStr = "";
        classStr = clazz.getDeclaredVersion() > 0 ? String.valueOf(this.resourceNameComputer.getFullyQualifiedTypeName((Type)clazz)) + "$" + clazz.getDeclaredVersion() : this.resourceNameComputer.getFullyQualifiedTypeName((Type)clazz);
        IN4JSProject project = (IN4JSProject)this.n4jsCore.findProject(clazz.eResource().getURI()).orNull();
        if (project != null && !Strings.isNullOrEmpty((String)(output = project.getOutputPath())) && output != ".") {
            classStr = output.endsWith("/") ? String.valueOf(output) + classStr : String.valueOf(output) + "/" + classStr;
        }
        return classStr;
    }

    private Map<URI, TModule> loadModules(Iterable<URI> moduleUris, IResourceDescriptions index, ResourceSet resSet) {
        HashMap uri2Modules = Maps.newHashMap();
        for (URI moduleUri : moduleUris) {
            IResourceDescription resDesc = index.getResourceDescription(moduleUri);
            uri2Modules.put(moduleUri, this.n4jsCore.loadModuleFromIndex(resSet, resDesc, false));
        }
        return uri2Modules;
    }

    private HashMultimap<URI, URI> createTestLocationMapping(List<URI> testLocations) {
        HashMultimap moduleUris2testUris = HashMultimap.create();
        for (URI testLocation : testLocations) {
            moduleUris2testUris.put((Object)testLocation.trimFragment(), (Object)testLocation);
        }
        return moduleUris2testUris;
    }

    private Iterable<TMethod> getAllTestMethodsOfClass(TClass cls) {
        TModule module = N4JSResource.getModule((Resource)cls.eResource());
        return FluentIterable.from((Iterable)this.containerTypesHelper.fromContext((EObject)module).allMembers((ContainerType)cls, false, false)).filter(TMethod.class).filter(m -> TestDiscoveryHelper.isTestMethod((TMember)m));
    }

    private boolean isProject(URI location) {
        try {
            return this.n4jsCore.create(location).exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isTestFile(URI uri) {
        return this.fileExtensionRegistry.getFileExtensions(FileExtensionType.TESTABLE_FILE_EXTENSION).contains(uri.fileExtension());
    }

    private boolean isTestModule(ResourceSet resourceSet, IResourceDescription module) {
        if (module == null) {
            return false;
        }
        Iterable classes = module.getExportedObjectsByType(T_CLASS);
        return TestDiscoveryHelper.stream(classes).anyMatch(desc -> this.hasTestMethods(resourceSet, (IEObjectDescription)desc));
    }

    private static boolean isAbstractClass(IEObjectDescription objDesc) {
        boolean isAbstract = N4JSResourceDescriptionStrategy.getAbstract((IEObjectDescription)objDesc);
        return isAbstract;
    }

    private static boolean isExportedTestClass(IEObjectDescription objDesc) {
        boolean isTestClass = N4JSResourceDescriptionStrategy.getTestClass((IEObjectDescription)objDesc);
        boolean isExported = N4JSResourceDescriptionStrategy.getExported((IEObjectDescription)objDesc);
        return isTestClass && isExported;
    }

    private boolean hasTestMethods(ResourceSet resSet, IEObjectDescription objDesc) {
        if (TestDiscoveryHelper.isAbstractClass(objDesc)) {
            return false;
        }
        if (TestDiscoveryHelper.isExportedTestClass(objDesc)) {
            return true;
        }
        TClass clazz = (TClass)this.loadTClass(resSet, objDesc).orNull();
        return clazz != null && clazz.isExported() && this.getAllTestMethodsOfClass(clazz).iterator().hasNext();
    }

    private Optional<TClass> loadTClass(ResourceSet resSet, IEObjectDescription objDesc) {
        if (T_CLASS.isSuperTypeOf(objDesc.getEClass())) {
            EObject object;
            EObject objectOrProxy = objDesc.getEObjectOrProxy();
            EObject eObject = object = objectOrProxy.eIsProxy() ? EcoreUtil.resolve((EObject)objectOrProxy, (ResourceSet)resSet) : objectOrProxy;
            if (!object.eIsProxy()) {
                return Optional.fromNullable((Object)((TClass)object));
            }
        }
        return Optional.absent();
    }

    private static boolean isTestMethod(TMember member) {
        return member instanceof TMethod && AnnotationDefinition.TEST_METHOD.hasAnnotation((TAnnotableElement)member);
    }

    private static final <T> Stream<T> stream(Iterable<T> in) {
        return StreamSupport.stream(in.spliterator(), false);
    }
}

