/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.factories;

import org.eclipse.n4js.flowgraphs.ControlFlowType;
import org.eclipse.n4js.flowgraphs.factories.DelegatingNodeFactory;
import org.eclipse.n4js.flowgraphs.factories.ReentrantASTIterator;
import org.eclipse.n4js.flowgraphs.model.CatchToken;
import org.eclipse.n4js.flowgraphs.model.ComplexNode;
import org.eclipse.n4js.flowgraphs.model.HelperNode;
import org.eclipse.n4js.flowgraphs.model.JumpToken;
import org.eclipse.n4js.flowgraphs.model.Node;
import org.eclipse.n4js.flowgraphs.model.RepresentingNode;
import org.eclipse.n4js.n4JS.BinaryLogicalExpression;
import org.eclipse.n4js.n4JS.ConditionalExpression;
import org.eclipse.n4js.n4JS.ControlFlowElement;
import org.eclipse.n4js.n4JS.DoStatement;
import org.eclipse.n4js.n4JS.ForStatement;
import org.eclipse.n4js.n4JS.IfStatement;
import org.eclipse.n4js.n4JS.ParenExpression;
import org.eclipse.n4js.n4JS.Statement;
import org.eclipse.n4js.n4JS.WhileStatement;

class BinaryLogicalExpressionFactory {
    BinaryLogicalExpressionFactory() {
    }

    static ComplexNode buildComplexNode(ReentrantASTIterator astpp, BinaryLogicalExpression lbExpr) {
        ComplexNode cNode = new ComplexNode(astpp.container(), (ControlFlowElement)lbExpr);
        HelperNode entryNode = new HelperNode("entry", astpp.pos(), (ControlFlowElement)lbExpr);
        Node lhsNode = DelegatingNodeFactory.createOrHelper(astpp, "lhs", (ControlFlowElement)lbExpr, (ControlFlowElement)lbExpr.getLhs());
        HelperNode scJumpNode = new HelperNode("shortCircuitJump", astpp.pos(), (ControlFlowElement)lbExpr);
        Node rhsNode = DelegatingNodeFactory.createOrHelper(astpp, "rhs", (ControlFlowElement)lbExpr, (ControlFlowElement)lbExpr.getRhs());
        RepresentingNode exitNode = new RepresentingNode("exit", astpp.pos(), (ControlFlowElement)lbExpr);
        cNode.addNode(entryNode);
        cNode.addNode(lhsNode);
        cNode.addNode(scJumpNode);
        cNode.addNode(rhsNode);
        cNode.addNode(exitNode);
        ControlFlowType thenCFT = null;
        ControlFlowType elseCFT = null;
        switch (lbExpr.getOp()) {
            case OR: {
                thenCFT = ControlFlowType.IfFalse;
                elseCFT = ControlFlowType.IfTrue;
                break;
            }
            case AND: {
                thenCFT = ControlFlowType.IfTrue;
                elseCFT = ControlFlowType.IfFalse;
            }
        }
        cNode.connectInternalSucc(entryNode, lhsNode, scJumpNode);
        cNode.connectInternalSucc(thenCFT, scJumpNode, rhsNode);
        cNode.connectInternalSucc(rhsNode, exitNode);
        scJumpNode.addJumpToken(new JumpToken(elseCFT));
        cNode.setJumpNode(scJumpNode);
        cNode.setEntryNode(entryNode);
        cNode.setExitNode(exitNode);
        rhsNode.addCatchToken(new CatchToken(thenCFT));
        boolean isCatchingLhs = BinaryLogicalExpressionFactory.isTopJumpCatcher(lbExpr);
        if (isCatchingLhs) {
            exitNode.addCatchToken(new CatchToken(elseCFT));
            exitNode.addCatchToken(new CatchToken(thenCFT));
        }
        return cNode;
    }

    private static boolean isTopJumpCatcher(BinaryLogicalExpression ble) {
        BinaryLogicalExpression child;
        BinaryLogicalExpression parent = ble;
        do {
            child = parent;
        } while ((parent = parent.eContainer()) instanceof ParenExpression);
        if (parent instanceof BinaryLogicalExpression) {
            return false;
        }
        if (parent instanceof ConditionalExpression) {
            ConditionalExpression isParent = (ConditionalExpression)parent;
            return isParent.getExpression() != child;
        }
        if (parent instanceof Statement) {
            if (parent instanceof IfStatement) {
                IfStatement isParent = (IfStatement)parent;
                return isParent.getExpression() != child;
            }
            if (parent instanceof ForStatement) {
                ForStatement isParent = (ForStatement)parent;
                return isParent.getExpression() != child || !isParent.isForPlain();
            }
            if (parent instanceof WhileStatement) {
                WhileStatement isParent = (WhileStatement)parent;
                return isParent.getExpression() != child;
            }
            if (parent instanceof DoStatement) {
                DoStatement isParent = (DoStatement)parent;
                return isParent.getExpression() != child;
            }
        }
        return true;
    }
}

