/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler;

import com.google.common.collect.Iterables;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.n4JS.AdditiveExpression;
import org.eclipse.n4js.n4JS.AdditiveOperator;
import org.eclipse.n4js.n4JS.AnnotableN4MemberDeclaration;
import org.eclipse.n4js.n4JS.Annotation;
import org.eclipse.n4js.n4JS.AnnotationList;
import org.eclipse.n4js.n4JS.Argument;
import org.eclipse.n4js.n4JS.ArrayElement;
import org.eclipse.n4js.n4JS.ArrayLiteral;
import org.eclipse.n4js.n4JS.ArrayPadding;
import org.eclipse.n4js.n4JS.AssignmentExpression;
import org.eclipse.n4js.n4JS.AssignmentOperator;
import org.eclipse.n4js.n4JS.BinaryLogicalExpression;
import org.eclipse.n4js.n4JS.BinaryLogicalOperator;
import org.eclipse.n4js.n4JS.Block;
import org.eclipse.n4js.n4JS.BooleanLiteral;
import org.eclipse.n4js.n4JS.CommaExpression;
import org.eclipse.n4js.n4JS.ConditionalExpression;
import org.eclipse.n4js.n4JS.EmptyStatement;
import org.eclipse.n4js.n4JS.EqualityExpression;
import org.eclipse.n4js.n4JS.EqualityOperator;
import org.eclipse.n4js.n4JS.ExportDeclaration;
import org.eclipse.n4js.n4JS.ExportableElement;
import org.eclipse.n4js.n4JS.ExportedVariableStatement;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ExpressionAnnotationList;
import org.eclipse.n4js.n4JS.ExpressionStatement;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.FunctionDeclaration;
import org.eclipse.n4js.n4JS.FunctionExpression;
import org.eclipse.n4js.n4JS.FunctionOrFieldAccessor;
import org.eclipse.n4js.n4JS.IfStatement;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.ImportSpecifier;
import org.eclipse.n4js.n4JS.IndexedAccessExpression;
import org.eclipse.n4js.n4JS.IntLiteral;
import org.eclipse.n4js.n4JS.LiteralOrComputedPropertyName;
import org.eclipse.n4js.n4JS.N4ClassDeclaration;
import org.eclipse.n4js.n4JS.N4EnumDeclaration;
import org.eclipse.n4js.n4JS.N4EnumLiteral;
import org.eclipse.n4js.n4JS.N4FieldDeclaration;
import org.eclipse.n4js.n4JS.N4InterfaceDeclaration;
import org.eclipse.n4js.n4JS.N4JSFactory;
import org.eclipse.n4js.n4JS.N4MemberAnnotationList;
import org.eclipse.n4js.n4JS.N4MemberDeclaration;
import org.eclipse.n4js.n4JS.N4MethodDeclaration;
import org.eclipse.n4js.n4JS.N4Modifier;
import org.eclipse.n4js.n4JS.N4SetterDeclaration;
import org.eclipse.n4js.n4JS.NamedImportSpecifier;
import org.eclipse.n4js.n4JS.NamespaceImportSpecifier;
import org.eclipse.n4js.n4JS.NewExpression;
import org.eclipse.n4js.n4JS.NullLiteral;
import org.eclipse.n4js.n4JS.NumericLiteral;
import org.eclipse.n4js.n4JS.ObjectLiteral;
import org.eclipse.n4js.n4JS.ParameterizedCallExpression;
import org.eclipse.n4js.n4JS.ParenExpression;
import org.eclipse.n4js.n4JS.PropertyAssignment;
import org.eclipse.n4js.n4JS.PropertyNameOwner;
import org.eclipse.n4js.n4JS.PropertyNameValuePair;
import org.eclipse.n4js.n4JS.RelationalExpression;
import org.eclipse.n4js.n4JS.RelationalOperator;
import org.eclipse.n4js.n4JS.ReturnStatement;
import org.eclipse.n4js.n4JS.Statement;
import org.eclipse.n4js.n4JS.StringLiteral;
import org.eclipse.n4js.n4JS.SuperLiteral;
import org.eclipse.n4js.n4JS.ThisLiteral;
import org.eclipse.n4js.n4JS.ThrowStatement;
import org.eclipse.n4js.n4JS.UnaryExpression;
import org.eclipse.n4js.n4JS.UnaryOperator;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.n4JS.VariableStatement;
import org.eclipse.n4js.n4JS.VariableStatementKeyword;
import org.eclipse.n4js.n4JS.YieldExpression;
import org.eclipse.n4js.transpiler.im.IdentifierRef_IM;
import org.eclipse.n4js.transpiler.im.ImFactory;
import org.eclipse.n4js.transpiler.im.ParameterizedPropertyAccessExpression_IM;
import org.eclipse.n4js.transpiler.im.ParameterizedTypeRef_IM;
import org.eclipse.n4js.transpiler.im.Snippet;
import org.eclipse.n4js.transpiler.im.StringLiteralForSTE;
import org.eclipse.n4js.transpiler.im.SymbolTableEntry;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.MemberAccessModifier;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TFormalParameter;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TSetter;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class TranspilerBuilderBlocks {
    public static ImportDeclaration _ImportDecl(ImportSpecifier ... importSpecifiers) {
        ImportDeclaration result = N4JSFactory.eINSTANCE.createImportDeclaration();
        result.setModule(null);
        EList _importSpecifiers = result.getImportSpecifiers();
        Iterable _filterNull = IterableExtensions.filterNull((Iterable)((Iterable)Conversions.doWrapArray((Object)importSpecifiers)));
        Iterables.addAll((Collection)_importSpecifiers, (Iterable)_filterNull);
        int _length = importSpecifiers.length;
        boolean _greaterThan = _length > 0;
        result.setImportFrom(_greaterThan);
        return result;
    }

    public static NamedImportSpecifier _NamedImportSpecifier(String importedElementName, String alias, boolean usedInCode) {
        NamedImportSpecifier result = N4JSFactory.eINSTANCE.createNamedImportSpecifier();
        result.setImportedElement(null);
        result.setImportedElementAsText(importedElementName);
        result.setAlias(alias);
        result.setFlaggedUsedInCode(usedInCode);
        return result;
    }

    public static NamespaceImportSpecifier _NamespaceImportSpecifier(String namespaceName, boolean usedInCode) {
        NamespaceImportSpecifier result = N4JSFactory.eINSTANCE.createNamespaceImportSpecifier();
        result.setAlias(namespaceName);
        result.setFlaggedUsedInCode(usedInCode);
        return result;
    }

    public static VariableStatement _VariableStatement(boolean exported, VariableDeclaration ... varDecls) {
        return TranspilerBuilderBlocks._VariableStatement(exported, VariableStatementKeyword.VAR, varDecls);
    }

    public static VariableStatement _VariableStatement(boolean exported, VariableStatementKeyword keyword, VariableDeclaration ... varDecls) {
        if (exported) {
            return TranspilerBuilderBlocks._ExportedVariableStatement(keyword, varDecls);
        }
        return TranspilerBuilderBlocks._VariableStatement(keyword, varDecls);
    }

    public static VariableStatement _VariableStatement(VariableDeclaration ... varDecls) {
        return TranspilerBuilderBlocks._VariableStatement(VariableStatementKeyword.VAR, varDecls);
    }

    public static VariableStatement _VariableStatement(VariableStatementKeyword keyword, VariableDeclaration ... varDecls) {
        VariableStatement result = N4JSFactory.eINSTANCE.createVariableStatement();
        result.setVarStmtKeyword(keyword);
        EList _varDeclsOrBindings = result.getVarDeclsOrBindings();
        Iterables.addAll((Collection)_varDeclsOrBindings, (Iterable)((Iterable)Conversions.doWrapArray((Object)varDecls)));
        return result;
    }

    public static ExportedVariableStatement _ExportedVariableStatement(VariableStatementKeyword keyword, VariableDeclaration ... varDecls) {
        ExportedVariableStatement result = N4JSFactory.eINSTANCE.createExportedVariableStatement();
        result.setVarStmtKeyword(keyword);
        EList _varDeclsOrBindings = result.getVarDeclsOrBindings();
        Iterable _filterNull = IterableExtensions.filterNull((Iterable)((Iterable)Conversions.doWrapArray((Object)varDecls)));
        Iterables.addAll((Collection)_varDeclsOrBindings, (Iterable)_filterNull);
        return result;
    }

    public static VariableDeclaration _VariableDeclaration(String name) {
        VariableDeclaration result = N4JSFactory.eINSTANCE.createVariableDeclaration();
        result.setName(name);
        return result;
    }

    public static VariableDeclaration _VariableDeclaration(String name, Expression exp) {
        VariableDeclaration result = N4JSFactory.eINSTANCE.createVariableDeclaration();
        result.setName(name);
        result.setExpression(exp);
        return result;
    }

    public static ExportDeclaration _ExportDeclaration(ExportableElement exported) {
        ExportDeclaration result = N4JSFactory.eINSTANCE.createExportDeclaration();
        result.setExportedElement(exported);
        return result;
    }

    public static ReturnStatement _ReturnStmnt() {
        ReturnStatement result = N4JSFactory.eINSTANCE.createReturnStatement();
        return result;
    }

    public static ReturnStatement _ReturnStmnt(Expression expr) {
        ReturnStatement result = N4JSFactory.eINSTANCE.createReturnStatement();
        result.setExpression(expr);
        return result;
    }

    public static IfStatement _IfStmnt(Expression condition, Statement ifStmnt) {
        return TranspilerBuilderBlocks._IfStmnt(condition, ifStmnt, null);
    }

    public static IfStatement _IfStmnt(Expression condition, Statement ifStmnt, Statement elseStmnt) {
        IfStatement result = N4JSFactory.eINSTANCE.createIfStatement();
        result.setExpression(condition);
        result.setIfStmt(ifStmnt);
        result.setElseStmt(elseStmnt);
        return result;
    }

    public static ThrowStatement _ThrowStmnt(Expression expression) {
        ThrowStatement result = N4JSFactory.eINSTANCE.createThrowStatement();
        result.setExpression(expression);
        return result;
    }

    public static ConditionalExpression _ConditionalExpr(Expression condition, Expression trueExpr, Expression falseExpr) {
        ConditionalExpression result = N4JSFactory.eINSTANCE.createConditionalExpression();
        result.setExpression(condition);
        result.setTrueExpression(trueExpr);
        result.setFalseExpression(falseExpr);
        return result;
    }

    public static YieldExpression _YieldExpr(Expression expr) {
        YieldExpression result = N4JSFactory.eINSTANCE.createYieldExpression();
        result.setExpression(expr);
        return result;
    }

    public static ParameterizedCallExpression _CallExpr() {
        ParameterizedCallExpression result = N4JSFactory.eINSTANCE.createParameterizedCallExpression();
        return result;
    }

    public static ParameterizedCallExpression _CallExpr(Expression target, Expression ... arguments) {
        ParameterizedCallExpression result = N4JSFactory.eINSTANCE.createParameterizedCallExpression();
        result.setTarget(target);
        EList _arguments = result.getArguments();
        Functions.Function1 _function = it -> TranspilerBuilderBlocks._Argument(it);
        Iterable _map = IterableExtensions.map((Iterable)IterableExtensions.filterNull((Iterable)((Iterable)Conversions.doWrapArray((Object)arguments))), (Functions.Function1)_function);
        Iterables.addAll((Collection)_arguments, (Iterable)_map);
        return result;
    }

    public static Argument _Argument(Expression expression) {
        return TranspilerBuilderBlocks._Argument(false, expression);
    }

    public static Argument _Argument(boolean spread, Expression expression) {
        Argument result = N4JSFactory.eINSTANCE.createArgument();
        result.setSpread(spread);
        result.setExpression(expression);
        return result;
    }

    public static ExpressionStatement _ExprStmnt(Expression expr) {
        ExpressionStatement result = N4JSFactory.eINSTANCE.createExpressionStatement();
        result.setExpression(expr);
        return result;
    }

    public static AssignmentExpression _AssignmentExpr() {
        AssignmentExpression result = N4JSFactory.eINSTANCE.createAssignmentExpression();
        result.setOp(AssignmentOperator.ASSIGN);
        return result;
    }

    public static AssignmentExpression _AssignmentExpr(Expression lhs, Expression rhs) {
        AssignmentExpression result = N4JSFactory.eINSTANCE.createAssignmentExpression();
        result.setLhs(lhs);
        result.setOp(AssignmentOperator.ASSIGN);
        result.setRhs(rhs);
        return result;
    }

    public static ParameterizedPropertyAccessExpression_IM _PropertyAccessExpr() {
        ParameterizedPropertyAccessExpression_IM result = ImFactory.eINSTANCE.createParameterizedPropertyAccessExpression_IM();
        return result;
    }

    public static ParameterizedPropertyAccessExpression_IM _PropertyAccessExpr(SymbolTableEntry target, SymbolTableEntry ... properties) {
        return TranspilerBuilderBlocks._PropertyAccessExpr(TranspilerBuilderBlocks._IdentRef(target), properties);
    }

    public static ParameterizedPropertyAccessExpression_IM _PropertyAccessExpr(Expression target, SymbolTableEntry ... properties) {
        boolean _greaterThan;
        if (properties == null || IterableExtensions.exists((Iterable)((Iterable)Conversions.doWrapArray((Object)properties)), it -> it == null)) {
            throw new IllegalArgumentException("none of the properties may be null");
        }
        ParameterizedPropertyAccessExpression_IM result = ImFactory.eINSTANCE.createParameterizedPropertyAccessExpression_IM();
        result.setTarget(target);
        int _length = properties.length;
        boolean bl = _greaterThan = _length > 0;
        if (_greaterThan) {
            result.setRewiredTarget(properties[0]);
            int _length_1 = properties.length;
            ExclusiveRange _doubleDotLessThan = new ExclusiveRange(1, _length_1, true);
            for (Integer idx : _doubleDotLessThan) {
                ParameterizedPropertyAccessExpression_IM newResult = ImFactory.eINSTANCE.createParameterizedPropertyAccessExpression_IM();
                newResult.setTarget(result);
                newResult.setRewiredTarget(properties[idx]);
                result = newResult;
            }
        }
        return result;
    }

    public static IndexedAccessExpression _IndexAccessExpr() {
        return TranspilerBuilderBlocks._IndexAccessExpr(null, null);
    }

    public static IndexedAccessExpression _IndexAccessExpr(SymbolTableEntry target, Expression index) {
        return TranspilerBuilderBlocks._IndexAccessExpr(TranspilerBuilderBlocks._IdentRef(target), index);
    }

    public static IndexedAccessExpression _IndexAccessExpr(Expression target, Expression index) {
        IndexedAccessExpression result = N4JSFactory.eINSTANCE.createIndexedAccessExpression();
        result.setTarget(target);
        result.setIndex(index);
        return result;
    }

    public static NewExpression _NewExpr(Expression callee, Expression ... arguments) {
        NewExpression result = N4JSFactory.eINSTANCE.createNewExpression();
        result.setCallee(callee);
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.filterNull((Iterable)((Iterable)Conversions.doWrapArray((Object)arguments))));
        boolean _not = !_isEmpty;
        result.setWithArgs(_not);
        EList _arguments = result.getArguments();
        Functions.Function1 _function = it -> TranspilerBuilderBlocks._Argument(it);
        Iterable _map = IterableExtensions.map((Iterable)IterableExtensions.filterNull((Iterable)((Iterable)Conversions.doWrapArray((Object)arguments))), (Functions.Function1)_function);
        Iterables.addAll((Collection)_arguments, (Iterable)_map);
        return result;
    }

    public static RelationalExpression _RelationalExpr(Expression lhs, RelationalOperator op, Expression rhs) {
        RelationalExpression result = N4JSFactory.eINSTANCE.createRelationalExpression();
        result.setLhs(lhs);
        result.setOp(op);
        result.setRhs(rhs);
        return result;
    }

    public static EqualityExpression _EqualityExpr(Expression lhs, EqualityOperator op, Expression rhs) {
        EqualityExpression result = N4JSFactory.eINSTANCE.createEqualityExpression();
        result.setLhs(lhs);
        result.setOp(op);
        result.setRhs(rhs);
        return result;
    }

    public static UnaryExpression _NOT(Expression expr) {
        return TranspilerBuilderBlocks._UnaryExpr(UnaryOperator.NOT, expr);
    }

    public static BinaryLogicalExpression _OR(Expression lhs, Expression rhs) {
        return TranspilerBuilderBlocks._BinaryLogicalExpr(lhs, BinaryLogicalOperator.OR, rhs);
    }

    public static BinaryLogicalExpression _AND(Expression lhs, Expression rhs) {
        return TranspilerBuilderBlocks._BinaryLogicalExpr(lhs, BinaryLogicalOperator.AND, rhs);
    }

    public static Expression _AND(Iterable<Expression> operands) {
        Functions.Function2 _function = (op1, op2) -> TranspilerBuilderBlocks._AND(op1, op2);
        return (Expression)IterableExtensions.reduce(operands, (Functions.Function2)_function);
    }

    public static UnaryExpression _UnaryExpr(UnaryOperator op, Expression expr) {
        UnaryExpression result = N4JSFactory.eINSTANCE.createUnaryExpression();
        result.setOp(op);
        result.setExpression(expr);
        return result;
    }

    public static BinaryLogicalExpression _BinaryLogicalExpr(Expression lhs, BinaryLogicalOperator op, Expression rhs) {
        BinaryLogicalExpression result = N4JSFactory.eINSTANCE.createBinaryLogicalExpression();
        result.setLhs(lhs);
        result.setOp(op);
        result.setRhs(rhs);
        return result;
    }

    public static CommaExpression _CommaExpression(Expression ... expressions) {
        CommaExpression result = N4JSFactory.eINSTANCE.createCommaExpression();
        EList _exprs = result.getExprs();
        Iterables.addAll((Collection)_exprs, (Iterable)((Iterable)Conversions.doWrapArray((Object)expressions)));
        return result;
    }

    public static AdditiveExpression _AdditiveExpression(Expression lhs, AdditiveOperator op, Expression rhs) {
        AdditiveExpression result = N4JSFactory.eINSTANCE.createAdditiveExpression();
        result.setLhs(lhs);
        result.setOp(op);
        result.setRhs(rhs);
        return result;
    }

    public static AdditiveExpression _AdditiveExpression(AdditiveOperator op, Expression ... operands) {
        boolean _lessThan;
        if (operands == null || IterableExtensions.exists((Iterable)((Iterable)Conversions.doWrapArray((Object)operands)), it -> it == null)) {
            throw new IllegalArgumentException("none of the operands may be null");
        }
        int _size = ((List)Conversions.doWrapArray((Object)operands)).size();
        boolean bl = _lessThan = _size < 2;
        if (_lessThan) {
            throw new IllegalArgumentException("need at least two operands");
        }
        AdditiveExpression result = N4JSFactory.eINSTANCE.createAdditiveExpression();
        result.setLhs(operands[0]);
        result.setOp(op);
        result.setRhs(operands[1]);
        int _length = operands.length;
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(2, _length, true);
        for (Integer idx : _doubleDotLessThan) {
            AdditiveExpression newResult = N4JSFactory.eINSTANCE.createAdditiveExpression();
            newResult.setLhs((Expression)result);
            newResult.setOp(op);
            newResult.setRhs(operands[idx]);
            result = newResult;
        }
        return result;
    }

    public static ObjectLiteral _ObjLit() {
        return TranspilerBuilderBlocks._ObjLit(null);
    }

    public static ObjectLiteral _ObjLit(Pair<String, Expression> ... nameValuePairs) {
        Functions.Function1 _function = it -> TranspilerBuilderBlocks._PropertyNameValuePair((String)it.getKey(), (Expression)it.getValue());
        return TranspilerBuilderBlocks._ObjLit((PropertyAssignment[])Conversions.unwrapArray((Object)IterableExtensions.map((Iterable)IterableExtensions.filterNull((Iterable)((Iterable)Conversions.doWrapArray(nameValuePairs))), (Functions.Function1)_function), PropertyAssignment.class));
    }

    public static ObjectLiteral _ObjLit(PropertyAssignment ... pas) {
        ObjectLiteral result = N4JSFactory.eINSTANCE.createObjectLiteral();
        if (pas != null) {
            EList _propertyAssignments = result.getPropertyAssignments();
            Iterable _filterNull = IterableExtensions.filterNull((Iterable)((Iterable)Conversions.doWrapArray((Object)pas)));
            Iterables.addAll((Collection)_propertyAssignments, (Iterable)_filterNull);
        }
        return result;
    }

    public static PropertyNameValuePair _PropertyNameValuePair(String name, Expression value) {
        PropertyNameValuePair result = N4JSFactory.eINSTANCE.createPropertyNameValuePair();
        result.setDeclaredName(TranspilerBuilderBlocks._LiteralOrComputedPropertyName(name));
        result.setExpression(value);
        return result;
    }

    public static ArrayLiteral _ArrLit() {
        return TranspilerBuilderBlocks._ArrLit(null);
    }

    public static ArrayLiteral _ArrLit(Expression ... elements) {
        Functions.Function1 _function = it -> TranspilerBuilderBlocks._ArrayElement(it);
        return TranspilerBuilderBlocks._ArrLit((ArrayElement[])Conversions.unwrapArray((Object)IterableExtensions.map((Iterable)IterableExtensions.filterNull((Iterable)((Iterable)Conversions.doWrapArray((Object)elements))), (Functions.Function1)_function), ArrayElement.class));
    }

    public static ArrayLiteral _ArrLit(ArrayElement ... elements) {
        ArrayLiteral result = N4JSFactory.eINSTANCE.createArrayLiteral();
        if (elements != null) {
            EList _elements = result.getElements();
            Iterable _filterNull = IterableExtensions.filterNull((Iterable)((Iterable)Conversions.doWrapArray((Object)elements)));
            Iterables.addAll((Collection)_elements, (Iterable)_filterNull);
        }
        return result;
    }

    public static ArrayElement _ArrayElement(Expression expression) {
        return TranspilerBuilderBlocks._ArrayElement(false, expression);
    }

    public static ArrayElement _ArrayElement(boolean spread, Expression expression) {
        ArrayElement result = N4JSFactory.eINSTANCE.createArrayElement();
        result.setSpread(spread);
        result.setExpression(expression);
        return result;
    }

    public static ArrayPadding _ArrayPadding() {
        ArrayPadding result = N4JSFactory.eINSTANCE.createArrayPadding();
        return result;
    }

    public static FunctionDeclaration _FunDecl(String name, Statement ... statements) {
        return TranspilerBuilderBlocks._FunDecl(name, new FormalParameter[0], statements);
    }

    public static FunctionDeclaration _FunDecl(String name, FormalParameter[] fpars, Statement ... statements) {
        FunctionDeclaration result = N4JSFactory.eINSTANCE.createFunctionDeclaration();
        result.setName(name);
        EList _fpars = result.getFpars();
        Iterables.addAll((Collection)_fpars, (Iterable)((Iterable)Conversions.doWrapArray((Object)fpars)));
        result.setBody(TranspilerBuilderBlocks._Block(statements));
        return result;
    }

    public static FunctionExpression _FunExpr(boolean async, Statement ... statements) {
        return TranspilerBuilderBlocks._FunExpr(async, null, new FormalParameter[0], statements);
    }

    public static FunctionExpression _FunExpr(boolean async, String name, Statement ... statements) {
        return TranspilerBuilderBlocks._FunExpr(async, name, new FormalParameter[0], statements);
    }

    public static FunctionExpression _FunExpr(boolean async, String name, FormalParameter ... formalParams) {
        return TranspilerBuilderBlocks._FunExpr(async, name, formalParams, new Statement[0]);
    }

    public static FunctionExpression _FunExpr(boolean async, String name, FormalParameter[] fpars, Statement ... statements) {
        if (statements != null && statements.length == 1 && statements[0] instanceof Block) {
            Statement _get = statements[0];
            return TranspilerBuilderBlocks._FunExprWithBlock(async, name, fpars, (Block)_get);
        }
        FunctionExpression result = N4JSFactory.eINSTANCE.createFunctionExpression();
        result.setDeclaredAsync(async);
        result.setName(name);
        EList _fpars = result.getFpars();
        Iterables.addAll((Collection)_fpars, (Iterable)((Iterable)Conversions.doWrapArray((Object)fpars)));
        result.setBody(TranspilerBuilderBlocks._Block(statements));
        return result;
    }

    public static FormalParameter _FormalParameter(String name) {
        FormalParameter result = N4JSFactory.eINSTANCE.createFormalParameter();
        result.setName(name);
        return result;
    }

    public static FunctionExpression _FunExpr(boolean async, String name, FormalParameter[] fpars, Block block) {
        return TranspilerBuilderBlocks._FunExprWithBlock(async, name, fpars, block);
    }

    private static FunctionExpression _FunExprWithBlock(boolean async, String name, FormalParameter[] fpars, Block block) {
        FunctionExpression result = N4JSFactory.eINSTANCE.createFunctionExpression();
        result.setDeclaredAsync(async);
        result.setName(name);
        EList _fpars = result.getFpars();
        Iterables.addAll((Collection)_fpars, (Iterable)((Iterable)Conversions.doWrapArray((Object)fpars)));
        result.setBody(block);
        return result;
    }

    public static N4MemberDeclaration _N4MemberDecl(TMember template, Statement ... statements) {
        MemberAccessModifier _memberAccessModifier;
        boolean _isStatic;
        if (template instanceof TField && !((List)Conversions.doWrapArray((Object)statements)).isEmpty()) {
            throw new IllegalArgumentException("fields cannot have statements");
        }
        N4FieldDeclaration _switchResult = null;
        boolean _matched = false;
        if (template instanceof TField) {
            _matched = true;
            _switchResult = N4JSFactory.eINSTANCE.createN4FieldDeclaration();
        }
        if (!_matched && template instanceof TGetter) {
            _matched = true;
            _switchResult = N4JSFactory.eINSTANCE.createN4GetterDeclaration();
        }
        if (!_matched && template instanceof TSetter) {
            _matched = true;
            _switchResult = N4JSFactory.eINSTANCE.createN4SetterDeclaration();
        }
        if (!_matched && template instanceof TMethod) {
            _matched = true;
            _switchResult = N4JSFactory.eINSTANCE.createN4MethodDeclaration();
        }
        if (!_matched) {
            String _name = template.eClass().getName();
            String _plus = "unsupported subtype of TMember: " + _name;
            throw new IllegalArgumentException(_plus);
        }
        N4FieldDeclaration result = _switchResult;
        ((PropertyNameOwner)result).setDeclaredName(TranspilerBuilderBlocks._LiteralOrComputedPropertyName(template.getName()));
        if (result instanceof FunctionOrFieldAccessor) {
            ((FunctionOrFieldAccessor)result).setBody(TranspilerBuilderBlocks._Block((Statement[])Conversions.unwrapArray((Object)IterableExtensions.filterNull((Iterable)((Iterable)Conversions.doWrapArray((Object)statements))), Statement.class)));
        }
        if (template instanceof TSetter) {
            String _elvis = null;
            TFormalParameter _fpar = ((TSetter)template).getFpar();
            String _name_1 = null;
            if (_fpar != null) {
                _name_1 = _fpar.getName();
            }
            _elvis = _name_1 != null ? _name_1 : "value";
            String fparName = _elvis;
            ((N4SetterDeclaration)result).setFpar(TranspilerBuilderBlocks._Fpar(fparName));
        }
        if (template instanceof TMethod) {
            EList _fpars = ((N4MethodDeclaration)result).getFpars();
            Functions.Function1 _function = it -> TranspilerBuilderBlocks._Fpar(it.getName());
            List _map = ListExtensions.map((List)((TMethod)template).getFpars(), (Functions.Function1)_function);
            Iterables.addAll((Collection)_fpars, (Iterable)_map);
            ((N4MethodDeclaration)result).setDeclaredAsync(((TMethod)template).isDeclaredAsync());
        }
        if (_isStatic = template.isStatic()) {
            EList _declaredModifiers = ((AnnotableN4MemberDeclaration)result).getDeclaredModifiers();
            _declaredModifiers.add((Object)N4Modifier.STATIC);
        }
        if ((_memberAccessModifier = template.getMemberAccessModifier()) != null) {
            switch (_memberAccessModifier) {
                case PUBLIC: {
                    EList _declaredModifiers_1 = ((AnnotableN4MemberDeclaration)result).getDeclaredModifiers();
                    _declaredModifiers_1.add((Object)N4Modifier.PUBLIC);
                    break;
                }
                case PUBLIC_INTERNAL: {
                    EList _declaredModifiers_2 = ((AnnotableN4MemberDeclaration)result).getDeclaredModifiers();
                    _declaredModifiers_2.add((Object)N4Modifier.PUBLIC);
                    EList _annotations = TranspilerBuilderBlocks.getOrCreateMemberAnnotationList((AnnotableN4MemberDeclaration)result).getAnnotations();
                    Annotation __Annotation = TranspilerBuilderBlocks._Annotation(AnnotationDefinition.INTERNAL);
                    _annotations.add((Object)__Annotation);
                    break;
                }
                case PROTECTED: {
                    EList _declaredModifiers_3 = ((AnnotableN4MemberDeclaration)result).getDeclaredModifiers();
                    _declaredModifiers_3.add((Object)N4Modifier.PROTECTED);
                    break;
                }
                case PROTECTED_INTERNAL: {
                    EList _declaredModifiers_4 = ((AnnotableN4MemberDeclaration)result).getDeclaredModifiers();
                    _declaredModifiers_4.add((Object)N4Modifier.PROTECTED);
                    EList _annotations_1 = TranspilerBuilderBlocks.getOrCreateMemberAnnotationList((AnnotableN4MemberDeclaration)result).getAnnotations();
                    Annotation __Annotation_1 = TranspilerBuilderBlocks._Annotation(AnnotationDefinition.INTERNAL);
                    _annotations_1.add((Object)__Annotation_1);
                    break;
                }
                case PROJECT: {
                    EList _declaredModifiers_5 = ((AnnotableN4MemberDeclaration)result).getDeclaredModifiers();
                    _declaredModifiers_5.add((Object)N4Modifier.PROJECT);
                    break;
                }
                case PRIVATE: {
                    EList _declaredModifiers_6 = ((AnnotableN4MemberDeclaration)result).getDeclaredModifiers();
                    _declaredModifiers_6.add((Object)N4Modifier.PRIVATE);
                    break;
                }
                case UNDEFINED: {
                    break;
                }
            }
        }
        return (AnnotableN4MemberDeclaration)result;
    }

    private static N4MemberAnnotationList getOrCreateMemberAnnotationList(AnnotableN4MemberDeclaration memberDecl) {
        N4MemberAnnotationList annList = memberDecl.getAnnotationList();
        if (annList == null) {
            annList = N4JSFactory.eINSTANCE.createN4MemberAnnotationList();
            memberDecl.setAnnotationList(annList);
        }
        return annList;
    }

    public static N4MethodDeclaration _N4MethodDecl(String name, Statement ... statements) {
        N4MethodDeclaration result = N4JSFactory.eINSTANCE.createN4MethodDeclaration();
        result.setDeclaredName(TranspilerBuilderBlocks._LiteralOrComputedPropertyName(name));
        result.setBody(TranspilerBuilderBlocks._Block((Statement[])Conversions.unwrapArray((Object)IterableExtensions.filterNull((Iterable)((Iterable)Conversions.doWrapArray((Object)statements))), Statement.class)));
        return result;
    }

    public static FormalParameter _Fpar() {
        return TranspilerBuilderBlocks._Fpar(null, false, null, false);
    }

    public static FormalParameter _Fpar(String name) {
        return TranspilerBuilderBlocks._Fpar(name, false, null, false);
    }

    public static FormalParameter _Fpar(String name, boolean variadic) {
        return TranspilerBuilderBlocks._Fpar(name, variadic, null, false);
    }

    public static FormalParameter _Fpar(String name, boolean variadic, TypeRef typeRef, boolean isSpecFpar) {
        FormalParameter result = N4JSFactory.eINSTANCE.createFormalParameter();
        result.setName(name);
        result.setVariadic(variadic);
        result.setDeclaredTypeRef((TypeRef)TypeUtils.copy((EObject)typeRef));
        if (isSpecFpar) {
            EList _annotations = result.getAnnotations();
            Annotation __Annotation = TranspilerBuilderBlocks._Annotation(AnnotationDefinition.SPEC);
            _annotations.add((Object)__Annotation);
        }
        return result;
    }

    public static Annotation _Annotation(AnnotationDefinition annDef) {
        Annotation result = N4JSFactory.eINSTANCE.createAnnotation();
        result.setName(annDef.name);
        return result;
    }

    public static AnnotationList _AnnotationList(List<AnnotationDefinition> annDef) {
        AnnotationList result = N4JSFactory.eINSTANCE.createAnnotationList();
        if (annDef != null) {
            EList _annotations = result.getAnnotations();
            Functions.Function1 _function = it -> TranspilerBuilderBlocks._Annotation(it);
            List _map = ListExtensions.map(annDef, (Functions.Function1)_function);
            Iterables.addAll((Collection)_annotations, (Iterable)_map);
        }
        return result;
    }

    public static ExpressionAnnotationList _ExprAnnoList(Annotation[] annotations) {
        ExpressionAnnotationList result = N4JSFactory.eINSTANCE.createExpressionAnnotationList();
        EList _annotations = result.getAnnotations();
        Iterables.addAll((Collection)_annotations, (Iterable)((Iterable)Conversions.doWrapArray((Object)annotations)));
        return result;
    }

    public static Block _Block(Statement ... statements) {
        Block result = N4JSFactory.eINSTANCE.createBlock();
        EList _statements = result.getStatements();
        Iterable _filterNull = IterableExtensions.filterNull((Iterable)((Iterable)Conversions.doWrapArray((Object)statements)));
        Iterables.addAll((Collection)_statements, (Iterable)_filterNull);
        return result;
    }

    public static ParenExpression _Parenthesis(Expression expr) {
        ParenExpression result = N4JSFactory.eINSTANCE.createParenExpression();
        result.setExpression(expr);
        return result;
    }

    public static NullLiteral _NULL() {
        return N4JSFactory.eINSTANCE.createNullLiteral();
    }

    public static BooleanLiteral _TRUE() {
        return TranspilerBuilderBlocks._BooleanLiteral(true);
    }

    public static BooleanLiteral _FALSE() {
        return TranspilerBuilderBlocks._BooleanLiteral(false);
    }

    public static BooleanLiteral _BooleanLiteral(boolean value) {
        BooleanLiteral result = N4JSFactory.eINSTANCE.createBooleanLiteral();
        result.setTrue(value);
        return result;
    }

    public static NumericLiteral _NumericLiteral(int num) {
        NumericLiteral result = N4JSFactory.eINSTANCE.createNumericLiteral();
        result.setValue(BigDecimal.valueOf(num));
        return result;
    }

    public static StringLiteral _StringLiteral(String s, String rawValue) {
        StringLiteral result = TranspilerBuilderBlocks._StringLiteral(s);
        result.setRawValue(rawValue);
        return result;
    }

    public static StringLiteral _StringLiteral(String s) {
        StringLiteral result = N4JSFactory.eINSTANCE.createStringLiteral();
        result.setValue(s);
        return result;
    }

    public static StringLiteral _StringLiteralForSTE(SymbolTableEntry symbolTableEntry) {
        return TranspilerBuilderBlocks._StringLiteralForSTE(symbolTableEntry, false);
    }

    public static StringLiteral _StringLiteralForSTE(SymbolTableEntry symbolTableEntry, boolean useExportedName) {
        StringLiteralForSTE result = ImFactory.eINSTANCE.createStringLiteralForSTE();
        result.setEntry(symbolTableEntry);
        result.setUseExportedName(useExportedName);
        return result;
    }

    public static IntLiteral _IntLiteral(int i) {
        IntLiteral result = N4JSFactory.eINSTANCE.createIntLiteral();
        result.setValue(BigDecimal.valueOf(i));
        return result;
    }

    public static ThisLiteral _ThisLiteral() {
        ThisLiteral result = N4JSFactory.eINSTANCE.createThisLiteral();
        return result;
    }

    public static SuperLiteral _SuperLiteral() {
        SuperLiteral result = N4JSFactory.eINSTANCE.createSuperLiteral();
        return result;
    }

    public static EmptyStatement _emptyStatement() {
        return N4JSFactory.eINSTANCE.createEmptyStatement();
    }

    public static N4EnumDeclaration _EnumDeclaration(String name, List<N4EnumLiteral> literals) {
        N4EnumDeclaration result = N4JSFactory.eINSTANCE.createN4EnumDeclaration();
        result.setName(name);
        EList _literals = result.getLiterals();
        Iterables.addAll((Collection)_literals, literals);
        return result;
    }

    public static N4EnumLiteral _EnumLiteral(String name, String value) {
        N4EnumLiteral result = N4JSFactory.eINSTANCE.createN4EnumLiteral();
        result.setName(name);
        result.setValue(value);
        return result;
    }

    public static N4ClassDeclaration _N4ClassDeclaration(String name) {
        N4ClassDeclaration result = N4JSFactory.eINSTANCE.createN4ClassDeclaration();
        result.setName(name);
        return result;
    }

    public static N4InterfaceDeclaration _N4InterfaceDeclaration(String name) {
        N4InterfaceDeclaration result = N4JSFactory.eINSTANCE.createN4InterfaceDeclaration();
        result.setName(name);
        return result;
    }

    public static LiteralOrComputedPropertyName _LiteralOrComputedPropertyName(String name) {
        LiteralOrComputedPropertyName result = N4JSFactory.eINSTANCE.createLiteralOrComputedPropertyName();
        result.setLiteralName(name);
        return result;
    }

    public static IdentifierRef_IM _IdentRef(SymbolTableEntry symbolTableEntry) {
        if (symbolTableEntry == null) {
            throw new IllegalArgumentException("when creating an IdentifierRef_IM: symbol table entry may not be null");
        }
        IdentifierRef_IM result = ImFactory.eINSTANCE.createIdentifierRef_IM();
        result.setRewiredTarget(symbolTableEntry);
        return result;
    }

    public static ParameterizedTypeRef_IM _ParameterizedTypeRef(SymbolTableEntry symbolTableEntry) {
        if (symbolTableEntry == null) {
            throw new IllegalArgumentException("when creating an ParameterizedTypeRef_IM: symbol table entry may not be null");
        }
        ParameterizedTypeRef_IM result = ImFactory.eINSTANCE.createParameterizedTypeRef_IM();
        result.setRewiredTarget(symbolTableEntry);
        return result;
    }

    public static SymbolTableEntry _SymbolTableEntry(String name) {
        throw new UnsupportedOperationException("do not manually create symbol table entries; use methods #createSymbolTableEntry() or #getSymbolTableEntry() instead");
    }

    public static ExpressionStatement _SnippetAsStmnt(String code) {
        return TranspilerBuilderBlocks._ExprStmnt(TranspilerBuilderBlocks._Snippet(code));
    }

    public static Snippet _Snippet(String code) {
        Snippet result = ImFactory.eINSTANCE.createSnippet();
        result.setCode(code);
        return result;
    }
}

