/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tests.util;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Stopwatch;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.N4JSGlobals;
import org.eclipse.n4js.external.LibraryManager;
import org.eclipse.n4js.json.JSON.JSONDocument;
import org.eclipse.n4js.json.JSON.JSONObject;
import org.eclipse.n4js.packagejson.PackageJsonBuilder;
import org.eclipse.n4js.projectModel.locations.PlatformResourceURI;
import org.eclipse.n4js.projectModel.names.EclipseProjectName;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;
import org.eclipse.n4js.test.helper.hlc.N4jsLibsAccess;
import org.eclipse.n4js.tests.util.PackageJSONTestUtils;
import org.eclipse.n4js.ui.editor.N4JSDirtyStateEditorSupport;
import org.eclipse.n4js.ui.internal.N4JSActivator;
import org.eclipse.n4js.ui.utils.TimeoutRuntimeException;
import org.eclipse.n4js.ui.utils.UIUtils;
import org.eclipse.n4js.utils.io.FileCopier;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.xtext.resource.SaveOptions;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.eclipse.xtext.ui.testing.util.IResourcesSetupUtil;
import org.eclipse.xtext.ui.testing.util.JavaProjectSetupUtil;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.junit.Assert;

public class ProjectTestsUtils {
    public static final String N4JS_RUNTIME_DUMMY_VERSION = "0.0.1-dummy";
    public static final long MAX_WAIT_2_MINUTES = 120000L;
    public static final long CHECK_INTERVAL_100_MS = 100L;
    private static Logger LOGGER = Logger.getLogger(ProjectTestsUtils.class);

    private static boolean allPredicatesApply(Predicate<IMarker>[] preds, IMarker marker) {
        Predicate<IMarker>[] predicateArray = preds;
        int n = preds.length;
        int n2 = 0;
        while (n2 < n) {
            Predicate<IMarker> p = predicateArray[n2];
            if (!p.apply((Object)marker)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static IProject importProject(File probandsFolder, N4JSProjectName projectName) throws CoreException {
        return ProjectTestsUtils.importProject(probandsFolder, projectName, Collections.emptyList());
    }

    public static IProject importProject(File probandsFolder, N4JSProjectName projectName, Collection<N4JSProjectName> n4jsLibs) throws CoreException {
        return ProjectTestsUtils.importProject(probandsFolder, projectName, true, true, n4jsLibs);
    }

    public static IProject importProjectFromExternalSource(File probandsFolder, N4JSProjectName projectName, boolean copyIntoWorkspace) throws Exception {
        return ProjectTestsUtils.importProject(probandsFolder, projectName, copyIntoWorkspace, false, Collections.emptyList());
    }

    public static IProject createProjectWithLocation(File probandsFolder, String projectLocationFolder, String workspaceName) throws CoreException {
        File projectSourceFolder = new File(probandsFolder, projectLocationFolder);
        if (!projectSourceFolder.exists()) {
            throw new IllegalArgumentException("proband not found in " + projectSourceFolder);
        }
        ProjectTestsUtils.prepareDotProject(projectSourceFolder);
        NullProgressMonitor monitor = new NullProgressMonitor();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(workspaceName);
        workspace.run(mon -> {
            IProjectDescription newProjectDescription = workspace.newProjectDescription(workspaceName);
            Path absoluteProjectPath = new Path(projectSourceFolder.getAbsolutePath());
            newProjectDescription.setLocation((IPath)absoluteProjectPath);
            project.create(newProjectDescription, mon);
            project.open(mon);
        }, (IProgressMonitor)monitor);
        return project;
    }

    private static IProject importProject(File probandsFolder, N4JSProjectName projectName, boolean copyIntoWorkspace, boolean prepareDotProject, Collection<N4JSProjectName> n4jsLibs) throws CoreException {
        File dotProjectFile;
        File projectTargetFolder;
        File projectSourceFolder = new File(probandsFolder, projectName.getRawName());
        if (!projectSourceFolder.exists()) {
            throw new IllegalArgumentException("proband not found in " + projectSourceFolder);
        }
        if (prepareDotProject) {
            ProjectTestsUtils.prepareDotProject(projectSourceFolder);
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (copyIntoWorkspace) {
            File workspaceFolder = workspace.getRoot().getLocation().toFile();
            projectTargetFolder = new File(workspaceFolder, projectName.getRawName());
            try {
                projectTargetFolder.mkdirs();
                FileCopier.copy((java.nio.file.Path)projectSourceFolder.toPath(), (java.nio.file.Path)projectTargetFolder.toPath());
            }
            catch (IOException e) {
                throw new WrappedException("exception while copying project into workspace", (Exception)e);
            }
        } else {
            projectTargetFolder = projectSourceFolder;
        }
        if (!n4jsLibs.isEmpty()) {
            try {
                N4jsLibsAccess.installN4jsLibs((java.nio.file.Path)projectTargetFolder.toPath().resolve("node_modules"), (boolean)true, (boolean)false, (boolean)false, (N4JSProjectName[])n4jsLibs.toArray(new N4JSProjectName[0]));
            }
            catch (IOException e) {
                throw new RuntimeException("unable to install n4js-libs from local checkout", e);
            }
        }
        if (!(dotProjectFile = new File(projectTargetFolder, ".project")).exists()) {
            throw new IllegalArgumentException("project to import does not contain a .project file: " + projectTargetFolder);
        }
        IProjectDescription description = workspace.loadProjectDescription((IPath)new Path(dotProjectFile.getAbsolutePath()));
        String projectNameFromDotProjectFile = description.getName();
        IProject project = workspace.getRoot().getProject(projectNameFromDotProjectFile);
        NullProgressMonitor monitor = new NullProgressMonitor();
        workspace.run(mon -> {
            project.create(description, mon);
            project.open(mon);
            if (!project.getLocation().toFile().exists()) {
                throw new IllegalArgumentException("test project not correctly created in " + project.getLocation());
            }
            IOverwriteQuery overwriteQuery = new IOverwriteQuery(){

                public String queryOverwrite(String file) {
                    return "ALL";
                }
            };
            ImportOperation importOperation = new ImportOperation(project.getFullPath(), (Object)projectTargetFolder, (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, overwriteQuery);
            importOperation.setCreateContainerStructure(false);
            try {
                importOperation.run(mon);
            }
            catch (InterruptedException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }, (IProgressMonitor)monitor);
        ProjectTestsUtils.waitForAllJobs();
        return project;
    }

    public static IProject importYarnWorkspace(LibraryManager libraryManager, File parentFolder, N4JSProjectName yarnProjectName) throws CoreException {
        return ProjectTestsUtils.importYarnWorkspace(libraryManager, parentFolder, yarnProjectName, (Predicate<N4JSProjectName>)Predicates.alwaysTrue(), Collections.emptyList());
    }

    public static IProject importYarnWorkspace(LibraryManager libraryManager, File parentFolder, N4JSProjectName yarnProjectName, Collection<N4JSProjectName> n4jsLibs) throws CoreException {
        return ProjectTestsUtils.importYarnWorkspace(libraryManager, parentFolder, yarnProjectName, (Predicate<N4JSProjectName>)Predicates.alwaysTrue(), n4jsLibs);
    }

    public static IProject importYarnWorkspace(LibraryManager libraryManager, File parentFolder, N4JSProjectName yarnProjectName, Predicate<N4JSProjectName> packagesToImport, Collection<N4JSProjectName> n4jsLibs) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject yarnProject = ProjectTestsUtils.importProject(parentFolder, yarnProjectName);
        IPath yarnPath = yarnProject.getLocation();
        IPath yarnPackagesPath = yarnPath.append("packages");
        String[] stringArray = yarnPackagesPath.toFile().list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String yarnPackageName = stringArray[n2];
            IPath packagePath = yarnPackagesPath.append(yarnPackageName);
            if (yarnPackageName.startsWith("@")) {
                String[] stringArray2 = packagePath.toFile().list();
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String scopedPackageName = stringArray2[n4];
                    IPath scopedPackagePath = packagePath.append(scopedPackageName);
                    if (packagesToImport.apply((Object)new N4JSProjectName(String.valueOf(yarnPackageName) + '/' + scopedPackageName))) {
                        ProjectTestsUtils.importProjectNotCopy(workspace, scopedPackagePath.toFile(), (IProgressMonitor)new NullProgressMonitor());
                    }
                    ++n4;
                }
            } else if (packagesToImport.apply((Object)new N4JSProjectName(yarnPackageName))) {
                ProjectTestsUtils.importProjectNotCopy(workspace, packagePath.toFile(), (IProgressMonitor)new NullProgressMonitor());
            }
            ++n2;
        }
        if (!n4jsLibs.isEmpty()) {
            try {
                N4jsLibsAccess.installN4jsLibs((java.nio.file.Path)yarnPackagesPath.toFile().toPath(), (boolean)true, (boolean)false, (boolean)false, (N4JSProjectName[])n4jsLibs.toArray(new N4JSProjectName[0]));
                yarnProject.refreshLocal(2, null);
            }
            catch (IOException e) {
                throw new RuntimeException("unable to install n4js-libs from local checkout", e);
            }
        }
        if (libraryManager != null) {
            ProjectTestsUtils.waitForAllJobs();
            libraryManager.runNpmYarnInstall(new PlatformResourceURI((IResource)yarnProject), (IProgressMonitor)new NullProgressMonitor());
        }
        ProjectTestsUtils.waitForAllJobs();
        ProjectTestsUtils.waitForAutoBuild();
        return yarnProject;
    }

    public static IProject importProjectNotCopy(IWorkspace workspace, File rootFolder, IProgressMonitor progressMonitor) throws CoreException {
        Path path = new Path(new File(rootFolder, "_project").getAbsolutePath());
        IProjectDescription desc = workspace.loadProjectDescription((IPath)path);
        IProject project = workspace.getRoot().getProject(desc.getName());
        project.create(desc, progressMonitor);
        project.open(progressMonitor);
        return project;
    }

    public static boolean prepareDotProject(File projectSourceFolder) {
        File dotProject = new File(projectSourceFolder, ".project");
        File dotProjectTemplate = new File(projectSourceFolder, "_project");
        if (dotProject.exists() && !dotProjectTemplate.exists()) {
            throw new IllegalArgumentException("proband must rename the '.project' file to '_project'");
        }
        if (dotProjectTemplate.exists()) {
            try {
                Files.copy(dotProjectTemplate.toPath(), dotProject.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new IllegalStateException("unable to prepare .project-file", e);
            }
            dotProject.deleteOnExit();
            return true;
        }
        return false;
    }

    public static IProject createJSProject(String projectName) throws CoreException {
        return ProjectTestsUtils.createJSProject(projectName, "src", "src-gen", null);
    }

    public static IProject createJSProject(String projectName, String sourceFolder, String outputFolder, Consumer<PackageJsonBuilder> packageJSONAdjustments) throws CoreException {
        IProject result = JavaProjectSetupUtil.createSimpleProject((String)projectName);
        JavaProjectSetupUtil.createSubFolder((IProject)result.getProject(), (String)sourceFolder);
        JavaProjectSetupUtil.createSubFolder((IProject)result.getProject(), (String)outputFolder);
        ProjectTestsUtils.createProjectDescriptionFile(result.getProject(), sourceFolder, outputFolder, packageJSONAdjustments);
        return result;
    }

    public static IFolder createDummyN4JSRuntime(IProject project) throws CoreException {
        IFolder nodeModulesFolder = project.getFolder("node_modules");
        ProjectTestsUtils.createDummyN4JSRuntime(nodeModulesFolder.getLocation().toFile().toPath());
        project.refreshLocal(2, IResourcesSetupUtil.monitor());
        return nodeModulesFolder.getFolder(N4JSGlobals.N4JS_RUNTIME.toEclipseProjectName().getRawName());
    }

    public static java.nio.file.Path createDummyN4JSRuntime(java.nio.file.Path location) {
        java.nio.file.Path projectPath = location.resolve(N4JSGlobals.N4JS_RUNTIME.getRawName());
        java.nio.file.Path packageJsonFile = projectPath.resolve("package.json");
        try {
            Files.createDirectories(projectPath, new FileAttribute[0]);
            Files.write(packageJsonFile, (Iterable<? extends CharSequence>)Lists.newArrayList((Object[])new String[]{"{", "    \"name\": \"" + N4JSGlobals.N4JS_RUNTIME + "\",", "    \"version\": \"0.0.1-dummy\"", "}"}), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("failed to create dummy n4js-runtime for testing purposes", e);
        }
        return projectPath;
    }

    public static void createProjectDescriptionFile(IProject project) throws CoreException {
        ProjectTestsUtils.createProjectDescriptionFile(project, "src", "src-gen", null);
    }

    public static void createProjectDescriptionFile(IProject project, String sourceFolder, String outputFolder, Consumer<PackageJsonBuilder> packageJSONBuilderAdjustments) throws CoreException {
        IFile projectDescriptionWorkspaceFile = project.getFile("package.json");
        URI uri = URI.createPlatformResourceURI((String)projectDescriptionWorkspaceFile.getFullPath().toString(), (boolean)true);
        PackageJsonBuilder packageJsonBuilder = PackageJSONTestUtils.defaultPackageJson(project.getName(), sourceFolder, outputFolder);
        if (packageJSONBuilderAdjustments != null) {
            packageJSONBuilderAdjustments.accept(packageJsonBuilder);
        }
        JSONDocument document = packageJsonBuilder.buildModel();
        ResourceSet rs = ProjectTestsUtils.createResourceSet(project);
        Resource projectDescriptionResource = rs.createResource(uri);
        projectDescriptionResource.getContents().add((Object)document);
        try {
            projectDescriptionResource.save(SaveOptions.newBuilder().format().getOptions().toOptionsMap());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        project.refreshLocal(2, IResourcesSetupUtil.monitor());
        ProjectTestsUtils.waitForAutoBuild();
        Assert.assertTrue((String)"project description file (package.json) should have been created", (boolean)projectDescriptionWorkspaceFile.exists());
    }

    public static void addProjectToDependencies(IProject toChange, N4JSProjectName projectName, String versionConstraint) throws IOException {
        URI uri = URI.createPlatformResourceURI((String)toChange.getFile("package.json").getFullPath().toString(), (boolean)true);
        ResourceSet rs = ProjectTestsUtils.createResourceSet(toChange);
        Resource resource = rs.getResource(uri, true);
        JSONObject packageJSONRoot = PackageJSONTestUtils.getPackageJSONRoot(resource);
        PackageJSONTestUtils.addProjectDependency(packageJSONRoot, projectName.getRawName(), versionConstraint);
        resource.save(null);
        ProjectTestsUtils.waitForAutoBuild();
    }

    public static IFolder configureProjectWithXtext(IProject project) throws CoreException {
        return ProjectTestsUtils.configureProjectWithXtext(project, "src");
    }

    public static IFolder configureProjectWithXtext(IProject project, String sourceFolder) throws CoreException {
        IResourcesSetupUtil.addNature((IProject)project.getProject(), (String)"org.eclipse.xtext.ui.shared.xtextNature");
        IFolder folder = project.getProject().getFolder(sourceFolder);
        if (!folder.exists()) {
            folder.create(true, true, null);
        }
        return folder;
    }

    private static ResourceSet createResourceSet(IProject project) {
        return ((IResourceSetProvider)N4JSActivator.getInstance().getInjector("org.eclipse.n4js.N4JS").getInstance(IResourceSetProvider.class)).get(project);
    }

    public static void waitForAutoBuild() {
        long start;
        int maxTry = 3;
        int currentTry = 1;
        long end = start = System.currentTimeMillis();
        boolean wasInterrupted = false;
        boolean foundJob = false;
        while (true) {
            try {
                Job[] foundJobs = Job.getJobManager().find(ResourcesPlugin.FAMILY_AUTO_BUILD);
                if (foundJobs.length > 0) {
                    foundJob = true;
                    Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
                }
                wasInterrupted = false;
                end = System.currentTimeMillis();
            }
            catch (OperationCanceledException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
            }
            if (wasInterrupted && end - start < 120000L) continue;
            if (!foundJob) {
                LOGGER.debug((Object)"Auto build job hasn't been found, but maybe already run.");
                ++currentTry;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    LOGGER.debug((Object)"Couldn't sleep, abort waiting");
                    return;
                }
                LOGGER.debug((Object)("Try again, try " + currentTry + " of " + 3));
            }
            if (foundJob || currentTry >= 3) break;
        }
    }

    public static void waitForUpdateEditorJob() {
        long start;
        int maxWait = 12000;
        long end = start = System.currentTimeMillis();
        boolean wasInterrupted = false;
        boolean foundJob = false;
        do {
            try {
                Job[] foundJobs = Job.getJobManager().find(N4JSDirtyStateEditorSupport.FAMILY_UPDATE_JOB);
                if (foundJobs.length > 0) {
                    foundJob = true;
                    Job.getJobManager().join(N4JSDirtyStateEditorSupport.FAMILY_UPDATE_JOB, null);
                }
                wasInterrupted = false;
                end = System.currentTimeMillis();
            }
            catch (OperationCanceledException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
            }
        } while (wasInterrupted && end - start < (long)maxWait);
        if (!foundJob) {
            LOGGER.warn((Object)"Update editor job hasn't been found, but maybe already run.");
        }
    }

    public static void waitForAllJobs() {
        ProjectTestsUtils.waitForAllJobs(120000L);
    }

    public static void waitForAllJobs(long maxWait) {
        List<String> foundJobs;
        if (maxWait < 1L) {
            throw new IllegalArgumentException("Wait time needs to be > 0, was " + maxWait + ".");
        }
        boolean runsInUI = UIUtils.runsInUIThread();
        if (runsInUI) {
            LOGGER.warn((Object)"Waiting for jobs runs in the UI thread which can lead to UI thread starvation.");
        }
        if ((foundJobs = ProjectTestsUtils.listJobsRunningWaiting()).isEmpty()) {
            LOGGER.info((Object)"No running nor waiting jobs found, maybe all have already finished.");
            return;
        }
        boolean wasInterrupted = false;
        boolean wasCancelled = false;
        boolean foundJob = false;
        Stopwatch sw = Stopwatch.createStarted();
        do {
            try {
                foundJobs = ProjectTestsUtils.listJobsRunningWaiting();
                boolean bl = foundJob = !foundJobs.isEmpty();
                if (!foundJob) continue;
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)("Found " + foundJobs.size() + " after " + sw + ", going to sleep for a while."));
                }
                if (runsInUI) {
                    UIUtils.waitForUiThread();
                    continue;
                }
                Thread.sleep(100L);
            }
            catch (OperationCanceledException e) {
                wasCancelled = true;
                LOGGER.error((Object)("Waiting for jobs was cancelled after " + sw + "."), (Throwable)e);
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
                LOGGER.error((Object)("Waiting for jobs was interrupted after " + sw + "."), (Throwable)e);
            }
        } while (sw.elapsed(TimeUnit.MILLISECONDS) < maxWait && foundJob && !wasInterrupted && !wasCancelled);
        sw.stop();
        if (foundJob) {
            if (LOGGER.isInfoEnabled()) {
                StringJoiner sj = new StringJoiner("\n");
                sj.add("Expected no jobs, found " + foundJobs.size() + ".");
                foundJobs.forEach(sj::add);
                LOGGER.info((Object)sj.toString());
            }
            if (!wasCancelled && !wasInterrupted) {
                throw new TimeoutRuntimeException("Expected no jobs, found " + foundJobs.size() + " after " + sw + ". " + foundJobs);
            }
        }
    }

    public static final List<String> listJobsRunningWaiting() {
        return Arrays.stream(Job.getJobManager().find(null)).filter(job -> job.getState() != 1 && job.getState() != 0).map(job -> " - " + job.getName() + " : " + job.getState()).collect(Collectors.toList());
    }

    public static IMarker[] assertMarkers(String assertMessage, IProject project, int count) throws CoreException {
        return ProjectTestsUtils.assertMarkers(assertMessage, (IResource)project, "org.eclipse.xtext.ui.check", count);
    }

    public static IMarker[] assertMarkers(String assertMessage, IResource resource, int count) throws CoreException {
        return ProjectTestsUtils.assertMarkers(assertMessage, resource, "org.eclipse.xtext.ui.check", count);
    }

    @SafeVarargs
    public static IMarker[] assertMarkers(String assertMessage, IResource resource, int count, Predicate<IMarker> ... markerPredicates) throws CoreException {
        return ProjectTestsUtils.assertMarkers(assertMessage, resource, "org.eclipse.xtext.ui.check", count, markerPredicates);
    }

    public static IMarker[] assertMarkers(String assertMessage, IResource resource, String markerType, int count) throws CoreException {
        return ProjectTestsUtils.assertMarkers(assertMessage, resource, markerType, count, Predicates.alwaysTrue());
    }

    @SafeVarargs
    public static IMarker[] assertMarkers(String assertMessage, IResource resource, String markerType, int count, Predicate<IMarker> ... markerPredicates) throws CoreException {
        IMarker[] markers = resource.findMarkers(markerType, true, 2);
        ImmutableList markerList = FluentIterable.from(Arrays.asList(markers)).filter(m -> ProjectTestsUtils.allPredicatesApply(markerPredicates, m)).toList();
        if (markerList.size() != count) {
            StringBuilder message = new StringBuilder(assertMessage);
            message.append("\nbut was:");
            for (IMarker marker : markerList) {
                message.append("\n");
                message.append("line " + MarkerUtilities.getLineNumber((IMarker)marker) + ": ");
                message.append(marker.getAttribute("message", "<no message>"));
            }
            Assert.assertEquals((String)message.toString(), (long)count, (long)markerList.size());
        }
        return markers;
    }

    public static void assertNoIssues() throws CoreException {
        ProjectTestsUtils.assertIssues(new String[0]);
    }

    public static void assertNoErrors() throws CoreException {
        ProjectTestsUtils.waitForAutoBuild();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IMarker[] markers = root.findMarkers("org.eclipse.xtext.ui.check", true, 2);
        int i = 0;
        while (i < markers.length) {
            IMarker m = markers[i];
            int severity = m.getAttribute("severity", -1);
            Assert.assertNotEquals((String)("Expected no errors but found:\n" + m.toString()), (long)2L, (long)severity);
            ++i;
        }
    }

    public static void assertIssues(String ... expectedMessages) throws CoreException {
        ProjectTestsUtils.assertIssues((IResource)ResourcesPlugin.getWorkspace().getRoot(), expectedMessages);
    }

    public static void assertIssues(IResource resource, String ... expectedMessages) throws CoreException {
        ProjectTestsUtils.assertIssues(null, resource, expectedMessages);
    }

    public static void assertIssues(String msg, IResource resource, String ... expectedMessages) throws CoreException {
        ProjectTestsUtils.waitForAutoBuild();
        IMarker[] markers = resource.findMarkers("org.eclipse.xtext.ui.check", true, 2);
        String[] actualMessages = new String[markers.length];
        int i = 0;
        while (i < markers.length) {
            IMarker m = markers[i];
            actualMessages[i] = "line " + MarkerUtilities.getLineNumber((IMarker)m) + ": " + m.getAttribute("message");
            ++i;
        }
        TreeSet<String> actual = new TreeSet<String>(Arrays.asList(actualMessages));
        TreeSet<String> expected = new TreeSet<String>(Arrays.asList(expectedMessages));
        Assert.assertEquals((Object)Joiner.on((char)'\n').join(expected), (Object)Joiner.on((char)'\n').join(actual));
    }

    public static void deleteProject(IProject project) throws CoreException {
        project.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void closeAllProjectsInWorkspace() {
        try {
            new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    IProject[] hiddenProjects;
                    IProject[] visibleProjects;
                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                    IProject[] iProjectArray = visibleProjects = root.getProjects();
                    int n = visibleProjects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProject visibleProject = iProjectArray[n2];
                        visibleProject.close(monitor);
                        ++n2;
                    }
                    IProject[] iProjectArray2 = hiddenProjects = root.getProjects(8);
                    int n3 = hiddenProjects.length;
                    n = 0;
                    while (n < n3) {
                        IProject hiddenProject = iProjectArray2[n];
                        hiddenProject.close(monitor);
                        ++n;
                    }
                }
            }.run(IResourcesSetupUtil.monitor());
        }
        catch (InvocationTargetException e) {
            Exceptions.sneakyThrow((Throwable)e.getCause());
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    public static IProject getProjectByName(EclipseProjectName projectName) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName.getRawName());
    }

    public static IProject[] getProjectsByName(EclipseProjectName projectName, EclipseProjectName otherName, EclipseProjectName ... rest) {
        List projectNames = Lists.asList((Object)projectName, (Object)otherName, (Object[])rest);
        IProject[] projects = new IProject[projectNames.size()];
        int i = 0;
        while (i < projects.length) {
            projects[i] = ProjectTestsUtils.getProjectByName((EclipseProjectName)projectNames.get(i));
            ++i;
        }
        return projects;
    }

    public static void importDependencies(N4JSProjectName projectName, java.net.URI externalRootLocation, LibraryManager libraryManager) throws IOException, CoreException {
        IProject clientProject = ProjectTestsUtils.getProjectByName(projectName.toEclipseProjectName());
        java.net.URI clientLocation = clientProject.getLocationURI();
        File nodeModulesDir = new File(clientLocation.getPath(), "node_modules");
        if (!nodeModulesDir.isDirectory()) {
            Files.createDirectory(nodeModulesDir.toPath(), new FileAttribute[0]);
        }
        java.nio.file.Path probandsSource = Paths.get(externalRootLocation.getPath(), new String[0]);
        FileCopier.copy((java.nio.file.Path)probandsSource, (java.nio.file.Path)nodeModulesDir.toPath());
        libraryManager.synchronizeNpms((IProgressMonitor)new NullProgressMonitor());
        IResourcesSetupUtil.fullBuild();
        ProjectTestsUtils.waitForAllJobs();
    }
}

