/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.es.transform;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.N4JSGlobals;
import org.eclipse.n4js.n4JS.ExportDeclaration;
import org.eclipse.n4js.n4JS.ExportableElement;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.ModifiableElement;
import org.eclipse.n4js.n4JS.ModuleSpecifierForm;
import org.eclipse.n4js.n4JS.NamedElement;
import org.eclipse.n4js.n4JS.VariableBinding;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.n4JS.VariableDeclarationOrBinding;
import org.eclipse.n4js.n4JS.VariableStatement;
import org.eclipse.n4js.projectDescription.ProjectType;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.locations.SafeURI;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;
import org.eclipse.n4js.transpiler.Transformation;
import org.eclipse.n4js.transpiler.TranspilerBuilderBlocks;
import org.eclipse.n4js.transpiler.im.SymbolTableEntry;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.utils.ResourceNameComputer;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class ModuleWrappingTransformation
extends Transformation {
    @Inject
    private IN4JSCore n4jsCore;
    @Inject
    private ResourceNameComputer resourceNameComputer;
    private String[] localModuleSpecifierSegments = null;

    public void assertPreConditions() {
    }

    public void assertPostConditions() {
    }

    public void analyze() {
        TModule localModule = this.getState().resource.getModule();
        String localModuleSpecifier = this.resourceNameComputer.getCompleteModuleSpecifier(localModule);
        this.localModuleSpecifierSegments = localModuleSpecifier.split("/", -1);
    }

    public void transform() {
        Consumer<ImportDeclaration> _function = it -> this.transformImportDecl((ImportDeclaration)it);
        this.collectNodes((EObject)this.getState().im, ImportDeclaration.class, false).forEach(_function);
        Functions.Function1 _function_1 = it -> it.getExportedElement();
        Consumer<ModifiableElement> _function_2 = it -> it.getDeclaredModifiers().clear();
        Iterables.filter((Iterable)ListExtensions.map((List)this.collectNodes((EObject)this.getState().im, ExportDeclaration.class, false), (Functions.Function1)_function_1), ModifiableElement.class).forEach(_function_2);
        Consumer<ExportDeclaration> _function_3 = it -> this.splitDefaultExportFromVarDecl((ExportDeclaration)it);
        this.collectNodes((EObject)this.getState().im, ExportDeclaration.class, false).forEach(_function_3);
        this.addEmptyImport(N4JSGlobals.N4JS_RUNTIME.getRawName());
    }

    private void transformImportDecl(ImportDeclaration importDeclIM) {
        String moduleSpecifier = this.computeModuleSpecifierForOutputCode(importDeclIM);
        String moduleSpecifierNormalized = moduleSpecifier.replace("/./", "/");
        importDeclIM.setModuleSpecifierAsText(moduleSpecifierNormalized);
    }

    private String computeModuleSpecifierForOutputCode(ImportDeclaration importDeclIM) {
        SafeURI _location_1;
        boolean _tripleEquals;
        TModule targetModule = this.getState().info.getImportedModule(importDeclIM);
        IN4JSProject targetProject = (IN4JSProject)this.n4jsCore.findProject(targetModule.eResource().getURI()).orNull();
        ProjectType _projectType = targetProject.getProjectType();
        boolean bl = _tripleEquals = _projectType == ProjectType.RUNTIME_LIBRARY;
        if (_tripleEquals) {
            return targetModule.getModuleSpecifier();
        }
        SafeURI _location = targetProject.getLocation();
        boolean importingFromModuleInSameProject = com.google.common.base.Objects.equal((Object)_location, (Object)(_location_1 = this.getState().project.getLocation()));
        if (importingFromModuleInSameProject) {
            return this.createRelativeModuleSpecifier(targetModule);
        }
        ModuleSpecifierForm moduleSpecifierForm = importDeclIM.getModuleSpecifierForm();
        if (moduleSpecifierForm == ModuleSpecifierForm.PROJECT || moduleSpecifierForm == ModuleSpecifierForm.PROJECT_NO_MAIN) {
            return this.getActualProjectName(targetProject).getRawName();
        }
        return this.createAbsoluteModuleSpecifier(targetProject, targetModule);
    }

    private String createRelativeModuleSpecifier(TModule targetModule) {
        String targetModuleSpecifier = this.resourceNameComputer.getCompleteModuleSpecifier(targetModule);
        String[] targetSegments = targetModuleSpecifier.split("/", -1);
        int l = Math.min(targetSegments.length, this.localModuleSpecifierSegments.length);
        int i = 0;
        while (i < l && Objects.equals(targetSegments[i], this.localModuleSpecifierSegments[i])) {
            ++i;
        }
        Object[] differingSegments = Arrays.copyOfRange(targetSegments, i, targetSegments.length);
        int _length = this.localModuleSpecifierSegments.length;
        int _minus = _length - 1;
        int goUpCount = _minus - i;
        String _xifexpression = null;
        _xifexpression = goUpCount > 0 ? "../".repeat(goUpCount) : "./";
        String _join = Joiner.on((String)"/").join(differingSegments);
        String result = String.valueOf(_xifexpression) + _join;
        return result;
    }

    private String createAbsoluteModuleSpecifier(IN4JSProject targetProject, TModule targetModule) {
        String outputPath;
        boolean _isNullOrEmpty;
        boolean _not;
        StringBuilder sb = new StringBuilder();
        N4JSProjectName targetProjectName = this.getActualProjectName(targetProject);
        if (targetProjectName != null) {
            sb.append(targetProjectName);
        }
        boolean bl = _not = !(_isNullOrEmpty = StringExtensions.isNullOrEmpty((String)(outputPath = targetProject.getOutputPath())));
        if (_not) {
            boolean _not_2;
            boolean _not_1;
            boolean _startsWith = outputPath.startsWith("/");
            boolean bl2 = _not_1 = !_startsWith;
            if (_not_1) {
                sb.append("/");
            }
            sb.append(outputPath);
            boolean _endsWith = outputPath.endsWith("/");
            boolean bl3 = _not_2 = !_endsWith;
            if (_not_2) {
                sb.append("/");
            }
        } else {
            boolean _greaterThan;
            int _length = sb.length();
            boolean bl4 = _greaterThan = _length > 0;
            if (_greaterThan) {
                sb.append("/");
            }
        }
        String targetModuleSpecifier = this.resourceNameComputer.getCompleteModuleSpecifier(targetModule);
        sb.append(targetModuleSpecifier);
        return sb.toString();
    }

    private N4JSProjectName getActualProjectName(IN4JSProject project) {
        N4JSProjectName definedProjectName;
        boolean _tripleEquals;
        ProjectType _projectType = project.getProjectType();
        boolean bl = _tripleEquals = _projectType == ProjectType.DEFINITION;
        if (_tripleEquals && (definedProjectName = project.getDefinesPackageName()) != null && !definedProjectName.isEmpty()) {
            return definedProjectName;
        }
        return project.getProjectName();
    }

    private void splitDefaultExportFromVarDecl(ExportDeclaration exportDecl) {
        ExportableElement exportedElement;
        boolean _isDefaultExport = exportDecl.isDefaultExport();
        if (_isDefaultExport && (exportedElement = exportDecl.getExportedElement()) instanceof VariableStatement) {
            boolean _greaterThan;
            boolean _not;
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)Iterables.filter((Iterable)((VariableStatement)exportedElement).getVarDeclsOrBindings(), VariableBinding.class));
            boolean bl = _not = !_isEmpty;
            if (_not) {
                throw new UnsupportedOperationException("unsupported: default-exported variable binding");
            }
            int _size = ((VariableStatement)exportedElement).getVarDeclsOrBindings().size();
            boolean bl2 = _greaterThan = _size > 1;
            if (_greaterThan) {
                throw new UnsupportedOperationException("unsupported: several default-exported variable declarations in a single export declaration");
            }
            VariableDeclarationOrBinding _head = (VariableDeclarationOrBinding)IterableExtensions.head((Iterable)((VariableStatement)exportedElement).getVarDeclsOrBindings());
            VariableDeclaration varDecl = (VariableDeclaration)_head;
            SymbolTableEntry varDeclSTE = this.findSymbolTableEntryForElement((NamedElement)varDecl, true);
            this.insertBefore((EObject)exportDecl, new EObject[]{exportedElement});
            exportDecl.setDefaultExportedExpression((Expression)TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)varDeclSTE));
        }
    }
}

