/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ts.ui.labeling;

import com.google.inject.Inject;
import java.net.URL;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.ts.ide.server.hover.CustomHoverLabelUtil;
import org.eclipse.n4js.ts.types.TFunction;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.validation.TypesKeywordProvider;
import org.eclipse.xtext.ui.editor.hover.html.DefaultEObjectHoverProvider;

public class TypesHoverProvider
extends DefaultEObjectHoverProvider {
    @Inject
    private TypesKeywordProvider keywordProvider;
    private static final String CSS_STYLE_KEYWORD = "color:white;background-color:gray;border: 1px solid gray;padding-left:3px;padding-right:3px;border-radius:6px;";
    private static final String HTML_IMAGE_PROPERTIES = "style=\"vertical-align: top;\" width=\"16\" height=\"16\"";

    protected String getFirstLine(EObject obj) {
        String keyword = this.keywordProvider.keyword((Object)obj);
        String label = this.getLabel(obj);
        return TypesHoverProvider.composeFirstLine(null, keyword, label);
    }

    public String getLabel(EObject obj) {
        String label = CustomHoverLabelUtil.getLabel((EObject)obj);
        if (label != null) {
            return label;
        }
        return super.getLabel(obj);
    }

    public boolean hasHover(EObject obj) {
        if (obj instanceof TMember || obj instanceof TFunction) {
            return true;
        }
        return super.hasHover(obj);
    }

    public static final String composeFirstLine(URL imageURL, String keyword, String label) {
        String htmlKeyword = "<span style=\"color:white;background-color:gray;border: 1px solid gray;padding-left:3px;padding-right:3px;border-radius:6px;\">" + keyword + "</span>";
        String htmlLabel = label == null ? "" : (label.contains("<b>") ? label : "<b>" + label + "</b>");
        String htmlImage = imageURL == null ? null : "<image style=\"vertical-align: top;\" width=\"16\" height=\"16\" src=\"" + imageURL.toExternalForm() + "\"/>";
        String line = String.valueOf(htmlImage == null ? htmlKeyword : htmlImage) + " " + htmlLabel;
        return line;
    }
}

