/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.editor;

import com.google.common.base.Objects;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.xtext.ui.editor.doubleClicking.AbstractPartitionDoubleClickSelector;
import org.eclipse.xtext.ui.editor.doubleClicking.DoubleClickStrategyProvider;
import org.eclipse.xtext.ui.editor.model.CommonBreakIterator;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;

public class N4JSDoubleClickStrategyProvider
extends DoubleClickStrategyProvider {
    public ITextDoubleClickStrategy getStrategy(ISourceViewer sourceViewer, String contentType, final String documentPartitioning) {
        boolean _equals = Objects.equal((Object)"__regex", (Object)contentType);
        if (_equals) {
            return new AbstractPartitionDoubleClickSelector(documentPartitioning){

                protected IRegion findExtendedDoubleClickSelection(@Extension IDocument document, int offset) {
                    try {
                        ITypedRegion region = TextUtilities.getPartition((IDocument)document, (String)documentPartitioning, (int)offset, (boolean)true);
                        boolean doSelect = false;
                        int trimRight = 0;
                        if (offset == region.getOffset() + 1 || offset >= region.getOffset() + region.getLength() - 2) {
                            boolean _tripleEquals;
                            int _offset = region.getOffset();
                            int _plus = _offset + 1;
                            doSelect = _tripleEquals = offset == _plus;
                            String textInRegion = document.get(region.getOffset(), region.getLength());
                            int lastSlash = N4JSDoubleClickStrategyProvider.this.last(textInRegion, '/');
                            if (lastSlash != 0) {
                                int _minus;
                                doSelect = doSelect || offset == region.getOffset() + lastSlash - 1;
                                int _length = region.getLength();
                                trimRight = _minus = _length - lastSlash;
                            }
                        }
                        if (doSelect) {
                            boolean trimLeft = true;
                            int _offset_1 = region.getOffset();
                            int _plus_1 = _offset_1 + 1;
                            int _length_1 = region.getLength();
                            int _minus_1 = _length_1 - 1;
                            int _minus_2 = _minus_1 - trimRight;
                            return new Region(_plus_1, _minus_2);
                        }
                    }
                    catch (Throwable _t) {
                        if (_t instanceof BadLocationException) {
                            return null;
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                    return null;
                }
            };
        }
        boolean _equals_1 = Objects.equal((Object)"__template", (Object)contentType);
        if (_equals_1) {
            return new AbstractPartitionDoubleClickSelector(documentPartitioning){

                protected IRegion findExtendedDoubleClickSelection(@Extension IDocument document, int offset) {
                    try {
                        ITypedRegion region = TextUtilities.getPartition((IDocument)document, (String)documentPartitioning, (int)offset, (boolean)true);
                        int _offset = region.getOffset();
                        int _plus = _offset + 1;
                        boolean doSelect = offset == _plus;
                        int trimRight = 0;
                        int _offset_1 = region.getOffset();
                        int _length = region.getLength();
                        int _plus_1 = _offset_1 + _length;
                        int endOffset = _plus_1 - 1;
                        char lastChar = document.getChar(endOffset);
                        boolean _is = N4JSDoubleClickStrategyProvider.is(lastChar, '`');
                        if (_is) {
                            doSelect = doSelect || offset == endOffset;
                            trimRight = 1;
                        } else if (N4JSDoubleClickStrategyProvider.is(lastChar, '{') && N4JSDoubleClickStrategyProvider.is(document.getChar(endOffset - 1), '$')) {
                            doSelect = doSelect || offset == endOffset - 1;
                            trimRight = 2;
                        }
                        if (doSelect) {
                            int trimLeft = 1;
                            int _offset_2 = region.getOffset();
                            int _plus_2 = _offset_2 + trimLeft;
                            int _length_1 = region.getLength();
                            int _minus = _length_1 - trimLeft;
                            int _minus_1 = _minus - trimRight;
                            return new Region(_plus_2, _minus_1);
                        }
                    }
                    catch (Throwable _t) {
                        if (_t instanceof BadLocationException) {
                            return null;
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                    return null;
                }
            };
        }
        boolean _equals_2 = Objects.equal((Object)"__jsdoc", (Object)contentType);
        if (_equals_2) {
            return new AbstractPartitionDoubleClickSelector(documentPartitioning){

                protected IRegion findExtendedDoubleClickSelection(@Extension IDocument document, int position) {
                    int end;
                    int start;
                    block10: {
                        IRegion line;
                        IRegion word;
                        block9: {
                            try {
                                boolean _tripleEquals;
                                int _length;
                                IRegion match = super.findExtendedDoubleClickSelection(document, position);
                                if (match != null) {
                                    return match;
                                }
                                word = this.findWord(document, position);
                                line = document.getLineInformationOfOffset(position);
                                int _offset = line.getOffset();
                                int _plus = _offset + (_length = line.getLength());
                                boolean bl = _tripleEquals = position == _plus;
                                if (!_tripleEquals) break block9;
                                return null;
                            }
                            catch (Throwable _t) {
                                if (_t instanceof BadLocationException) {
                                    return null;
                                }
                                throw Exceptions.sneakyThrow((Throwable)_t);
                            }
                        }
                        start = word.getOffset();
                        int _length_1 = word.getLength();
                        end = start + _length_1;
                        if (start > 0 && N4JSDoubleClickStrategyProvider.is(document.getChar(start - 1), '@') && Character.isJavaIdentifierPart(document.getChar(start)) && (start == 1 || Character.isWhitespace(document.getChar(start - 2)) || N4JSDoubleClickStrategyProvider.is(document.getChar(start - 2), '{'))) {
                            --start;
                        } else if (end == position && end == start + 1 && end < line.getOffset() + line.getLength() && N4JSDoubleClickStrategyProvider.is(document.getChar(end), '@')) {
                            return this.findExtendedDoubleClickSelection(document, position + 1);
                        }
                        if (start != end) break block10;
                        return null;
                    }
                    return new Region(start, end - start);
                }

                protected CommonBreakIterator createBreakIterator() {
                    return new MyBreakIterator();
                }
            };
        }
        return super.getStrategy(sourceViewer, contentType, documentPartitioning);
    }

    public static boolean is(char a, char b) {
        return a == b;
    }

    public int last(String s, char b) {
        return s.lastIndexOf(b);
    }

    public static class MyBreakIterator
    extends CommonBreakIterator {
        private final Braces braces = new Braces();
        private final Parentheses parentheses = new Parentheses();

        public MyBreakIterator() {
            super(false);
        }

        protected CommonBreakIterator.Run getRun(char ch) {
            boolean _isValid = this.braces.isValid(ch);
            if (_isValid) {
                return this.braces;
            }
            boolean _isValid_1 = this.parentheses.isValid(ch);
            if (_isValid_1) {
                return this.parentheses;
            }
            return super.getRun(ch);
        }

        public static class Braces
        extends CommonBreakIterator.Other {
            protected boolean isValid(char ch) {
                return N4JSDoubleClickStrategyProvider.is(ch, '{') || N4JSDoubleClickStrategyProvider.is(ch, '}');
            }
        }

        public static class Parentheses
        extends CommonBreakIterator.Other {
            protected boolean isValid(char ch) {
                return N4JSDoubleClickStrategyProvider.is(ch, '(') || N4JSDoubleClickStrategyProvider.is(ch, ')');
            }
        }
    }
}

