/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ts.scoping.builtin;

import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.n4js.ts.scoping.builtin.BuiltInSchemeRegistrar;
import org.eclipse.xtext.resource.ClasspathUriResolutionException;
import org.eclipse.xtext.resource.ClasspathUriUtil;
import org.eclipse.xtext.resource.SynchronizedXtextResourceSet;
import org.eclipse.xtext.util.UriExtensions;

public class ResourceSetWithBuiltInScheme
extends SynchronizedXtextResourceSet {
    private final UriExtensions uriExtensions = new UriExtensions();

    @Inject
    private void configureWith(BuiltInSchemeRegistrar registrar) {
        registrar.registerScheme((ResourceSet)this);
    }

    private URI resolveClasspathURI(URI uri) {
        return this.getClasspathUriResolver().resolve(this.getClasspathURIContext(), uri);
    }

    public URIConverter getURIConverter() {
        if (this.uriConverter == null) {
            this.uriConverter = new ExtensibleURIConverterImpl(){

                public URI normalize(URI uri) {
                    URI normalizedURI = (URI)ResourceSetWithBuiltInScheme.this.normalizationMap.get(uri);
                    if (normalizedURI != null) {
                        return normalizedURI;
                    }
                    if (ClasspathUriUtil.isClasspathUri((URI)uri)) {
                        URI result = ResourceSetWithBuiltInScheme.this.resolveClasspathURI(uri);
                        if (ClasspathUriUtil.isClasspathUri((URI)result)) {
                            throw new ClasspathUriResolutionException(result);
                        }
                        result = super.normalize(result);
                        return result;
                    }
                    URI result = super.normalize(uri);
                    if (!result.isRelative()) {
                        result = ResourceSetWithBuiltInScheme.this.uriExtensions.withEmptyAuthority(result);
                    }
                    return result;
                }

                public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
                    options = ResourceSetWithBuiltInScheme.this.addTimeout(options);
                    return super.createInputStream(uri, options);
                }

                public Map<String, ?> contentDescription(URI uri, Map<?, ?> options) throws IOException {
                    options = ResourceSetWithBuiltInScheme.this.addTimeout(options);
                    return super.contentDescription(uri, options);
                }
            };
        }
        return super.getURIConverter();
    }
}

