/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils;

import com.google.inject.Inject;
import com.google.inject.Injector;

public final class CallTraceUtil {
    private static final int CALL_BASE_DEPTH = 3;
    @Inject
    private Injector injector;
    private String injectorData;

    public String getCallerInfo() {
        return this.getStaticAndInstanceInfo();
    }

    public void traceCall() {
        System.out.println(this.getStaticAndInstanceInfo());
    }

    public void printFullCallTrace() {
        System.out.println(String.valueOf(this.getStaticAndInstanceInfo()) + CallTraceUtil.getStackTraceFromOffset(3));
    }

    public static void traceStaticCall() {
        System.out.println(CallTraceUtil.getStaticCallerInfo());
    }

    public static String getStaticCallerInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)CallTraceUtil.getStackTrace(3));
        return sb.toString();
    }

    private String getStaticAndInstanceInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)CallTraceUtil.getStackTrace(3));
        sb.append(", ");
        sb.append((CharSequence)this.getInjectionInfo());
        return sb.toString();
    }

    private static StringBuilder getStackTraceFromOffset(int baseOffset) {
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        int stackOffset = baseOffset;
        while (stackOffset < stackTrace.length) {
            sb.append("\n" + stackTrace[stackOffset]);
            ++stackOffset;
        }
        return sb;
    }

    private static StringBuilder getStackTrace(int callDepth) {
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        int stackOffset = callDepth + 1;
        if (stackTrace.length >= callDepth) {
            sb.append(stackTrace[stackOffset].toString());
        } else {
            sb.append("call stack is suspiciously shallow:");
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            int n = stackTraceElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement ste = stackTraceElementArray[n2];
                sb.append(ste);
                ++n2;
            }
        }
        return sb;
    }

    private StringBuilder getInjectionInfo() {
        StringBuilder sb = new StringBuilder();
        if (this.injector != null) {
            sb.append("injected with:#").append(this.injector.hashCode()).append("_").append(this.getInjectorData());
        } else {
            sb.append("instance not injected");
        }
        return sb;
    }

    private String getInjectorData() {
        if (this.injectorData == null && this.injector != null) {
            this.injectorData = this.injector.getClass().getTypeName();
            String injectorAllData = this.injector.toString();
            if (injectorAllData.contains("N4JSRuntimeModule")) {
                this.injectorData = String.valueOf(this.injectorData) + "  [N4JSRuntimeModule]";
            }
            if (injectorAllData.contains("N4JSXRuntimeModule")) {
                this.injectorData = String.valueOf(this.injectorData) + "  [N4JSXRuntimeModule]";
            }
        }
        return this.injectorData;
    }
}

