/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.internal;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.n4js.internal.AbstractN4JSCore;
import org.eclipse.n4js.internal.FileBasedWorkspace;
import org.eclipse.n4js.internal.N4JSModel;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.IN4JSRuntimeCore;
import org.eclipse.n4js.projectModel.IN4JSSourceContainer;
import org.eclipse.n4js.projectModel.locations.FileURI;
import org.eclipse.n4js.projectModel.locations.SafeURI;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;
import org.eclipse.n4js.resource.OrderedResourceDescriptionsData;
import org.eclipse.n4js.ts.scoping.builtin.N4Scheme;
import org.eclipse.n4js.utils.ResourceType;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;

@Singleton
public class N4JSRuntimeCore
extends AbstractN4JSCore
implements IN4JSRuntimeCore {
    private final FileBasedWorkspace workspace;
    private final N4JSModel<? extends SafeURI<?>> model;
    @Inject
    private Provider<XtextResourceSet> resourceSetProvider;
    @Inject
    private ResourceDescriptionsProvider resourceDescriptionsProvider;
    @Inject
    private IResourceServiceProvider.Registry resourceServiceProviderRegistry;

    @Inject
    public N4JSRuntimeCore(FileBasedWorkspace workspace, N4JSModel<? extends SafeURI<?>> model) {
        this.workspace = workspace;
        this.model = model;
    }

    @Override
    public IN4JSProject create(URI location) {
        if (location == null) {
            return null;
        }
        return this.model.getN4JSProject(location);
    }

    @Override
    public SafeURI<?> toProjectLocation(URI uri) {
        return this.model.toProjectLocation(uri);
    }

    @Override
    public Optional<? extends IN4JSProject> findProject(URI nestedLocation) {
        if (nestedLocation == null || N4Scheme.isN4Scheme((URI)nestedLocation)) {
            return Optional.absent();
        }
        IN4JSProject result = this.model.findProjectWith(nestedLocation);
        return Optional.fromNullable((Object)result);
    }

    public Set<? extends IN4JSProject> findAllProjects() {
        return this.model.getAllProjects();
    }

    @Override
    public Optional<? extends IN4JSProject> findProject(N4JSProjectName name) {
        return Optional.fromNullable((Object)this.model.findProject(name));
    }

    @Override
    public Map<N4JSProjectName, IN4JSProject> findAllProjectMappings() {
        HashMap<N4JSProjectName, IN4JSProject> allProjectMappings = new HashMap<N4JSProjectName, IN4JSProject>();
        for (IN4JSProject project : this.findAllProjects()) {
            allProjectMappings.put(project.getProjectName(), project);
        }
        return allProjectMappings;
    }

    @Override
    public Optional<? extends IN4JSSourceContainer> findN4JSSourceContainer(URI nestedLocation) {
        if (nestedLocation == null || nestedLocation.isFile() && nestedLocation.isRelative()) {
            return Optional.absent();
        }
        return this.model.findN4JSSourceContainer(nestedLocation);
    }

    @Override
    public void registerProject(File file) {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(String.valueOf(file.getAbsolutePath()) + " is not a valid project location");
        }
        URI uri = new FileURI(file).toURI();
        this.workspace.registerProject((FileURI)this.toProjectLocation(uri));
    }

    @Override
    public ResourceSet createResourceSet(Optional<IN4JSProject> contextProject) {
        ResourceSet resourceSet = (ResourceSet)this.resourceSetProvider.get();
        resourceSet.getLoadOptions().put("org.eclipse.xtext.builder.impl.PersistentDataAwareDirtyResource.PERSISTED_DESCRIPTIONS", Boolean.TRUE);
        this.createAllResourcesWorkspace(resourceSet);
        this.attachResourceDescriptionsData(resourceSet);
        return resourceSet;
    }

    @Override
    public IResourceDescriptions getXtextIndex(ResourceSet resourceSet) {
        return this.resourceDescriptionsProvider.getResourceDescriptions(resourceSet);
    }

    private void createAllResourcesWorkspace(ResourceSet resourceSet) {
        HashSet uris = Sets.newHashSet();
        for (IN4JSProject project : this.findAllProjects()) {
            project.getSourceContainers().forEach(sc -> {
                for (URI sourceFile : sc) {
                    if (!this.isN4File(sourceFile) || !uris.add(sourceFile)) continue;
                    resourceSet.createResource(sourceFile);
                }
            });
        }
    }

    private void attachResourceDescriptionsData(ResourceSet resourceSet) {
        this.installIndex(resourceSet);
    }

    private void installIndex(ResourceSet resourceSet) {
        OrderedResourceDescriptionsData index = new OrderedResourceDescriptionsData(Collections.emptyList());
        ArrayList resources = Lists.newArrayList((Iterable)resourceSet.getResources());
        for (Resource resource : resources) {
            this.index(resource, resource.getURI(), index);
        }
        Adapter existing = EcoreUtil.getAdapter((List)resourceSet.eAdapters(), ResourceDescriptionsData.class);
        if (existing != null) {
            resourceSet.eAdapters().remove((Object)existing);
        }
        ResourceDescriptionsData.ResourceSetAdapter.installResourceDescriptionsData((ResourceSet)resourceSet, (ResourceDescriptionsData)index);
    }

    private void index(Resource resource, URI uri, ResourceDescriptionsData index) {
        IResourceDescription resourceDescription;
        IN4JSSourceContainer sourceContainer;
        if (this.isJsFile(uri) && (sourceContainer = (IN4JSSourceContainer)this.findN4JSSourceContainer(uri).orNull()) == null) {
            return;
        }
        IResourceServiceProvider serviceProvider = this.resourceServiceProviderRegistry.getResourceServiceProvider(uri);
        if (serviceProvider != null && (resourceDescription = serviceProvider.getResourceDescriptionManager().getResourceDescription(resource)) != null) {
            index.addDescription(uri, resourceDescription);
        }
    }

    protected boolean isJsFile(URI uri) {
        ResourceType resourceType = ResourceType.getResourceType(uri);
        switch (resourceType) {
            case JS: {
                return true;
            }
            case JSX: {
                return true;
            }
        }
        return false;
    }

    private boolean isN4File(URI uri) {
        ResourceType resourceType = ResourceType.getResourceType(uri);
        switch (resourceType) {
            case UNKOWN: {
                return false;
            }
        }
        return !ResourceType.xtHidesOtherExtension(uri);
    }
}

