/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.jsdoc2spec.adoc;

import java.io.File;
import java.util.ArrayList;
import java.util.Objects;
import org.eclipse.n4js.jsdoc2spec.SpecFile;
import org.eclipse.n4js.jsdoc2spec.adoc.IndexEntry;

abstract class IndexEntryWriter {
    protected IndexEntry lastIE;
    protected StringBuilder strb;

    IndexEntryWriter() {
    }

    protected abstract void appendEntry(IndexEntry var1);

    protected abstract String getFileName();

    protected abstract SpecFile createSpecFile(File var1, String var2);

    protected void clear() {
        this.lastIE = null;
        this.strb = null;
    }

    protected void startNewFile() {
        this.strb = new StringBuilder();
    }

    protected void append(IndexEntry ie) {
        Objects.requireNonNull(this.strb);
        this.appendEntry(ie);
        this.lastIE = ie;
    }

    public boolean hasContent() {
        return this.lastIE != null && this.strb != null;
    }

    public void serialize(ArrayList<IndexEntry> entries) {
        this.clear();
        this.startNewFile();
        for (IndexEntry ie : entries) {
            this.append(ie);
        }
    }

    public SpecFile getSpecFile(File rootDir) {
        String fileName = this.getFileName();
        String absFileName = rootDir + File.separator + "api-gen" + File.separator + fileName;
        File indexFile = new File(absFileName);
        String indexContent = this.strb.toString();
        SpecFile scf = this.createSpecFile(indexFile, indexContent);
        return scf;
    }
}

