/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide;

import com.google.common.util.concurrent.Futures;
import com.google.inject.Injector;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.Channels;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.n4js.ide.N4JSIdeSetup;
import org.eclipse.n4js.ide.server.N4JSLanguageServerImpl;

public class RunServer {
    public static void main(String[] args) throws Exception {
        Injector injector = new N4JSIdeSetup().createInjectorAndDoEMFRegistration();
        AsynchronousServerSocketChannel _open = AsynchronousServerSocketChannel.open();
        InetSocketAddress _inetSocketAddress = new InetSocketAddress("localhost", 5007);
        AsynchronousServerSocketChannel serverSocket = _open.bind(_inetSocketAddress);
        ExecutorService threadPool = Executors.newCachedThreadPool();
        while (true) {
            N4JSLanguageServerImpl languageServer = (N4JSLanguageServerImpl)((Object)injector.getInstance(N4JSLanguageServerImpl.class));
            AsynchronousSocketChannel socketChannel = serverSocket.accept().get();
            InputStream in = Channels.newInputStream(socketChannel);
            OutputStream out = Channels.newOutputStream(socketChannel);
            Function<MessageConsumer, MessageConsumer> _function = it -> it;
            Launcher launcher = Launcher.createIoLauncher((Object)((Object)languageServer), LanguageClient.class, (InputStream)in, (OutputStream)out, (ExecutorService)threadPool, _function);
            languageServer.connect((LanguageClient)launcher.getRemoteProxy());
            Futures.getUnchecked((Future)launcher.startListening());
            languageServer.getRequestManager().shutdown();
            in.close();
            out.close();
            socketChannel.close();
        }
    }
}

