/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.n4idl.migrations;

import java.util.List;
import java.util.Optional;
import org.eclipse.n4js.n4idl.migrations.SuperClassifierIterator;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeTypeRef;
import org.eclipse.n4js.ts.types.BuiltInType;
import org.eclipse.n4js.ts.types.PrimitiveType;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.utils.collections.Iterables2;
import org.eclipse.xtext.xbase.lib.Pair;

public class TypeDistanceComputer {
    public static final double MAX_DISTANCE = Double.POSITIVE_INFINITY;

    public double computeDistance(List<TypeRef> fromTypeRefs, List<TypeRef> toTypeRefs) throws UnsupportedTypeDistanceOperandsException {
        if (fromTypeRefs.size() != toTypeRefs.size()) {
            return Double.POSITIVE_INFINITY;
        }
        double sum = 0.0;
        Iterable argumentParemeterPairs = Iterables2.align(fromTypeRefs, toTypeRefs);
        for (Pair typePair : argumentParemeterPairs) {
            double distance = this.computeDistance((TypeRef)typePair.getKey(), (TypeRef)typePair.getValue());
            if (distance == Double.POSITIVE_INFINITY) {
                return Double.POSITIVE_INFINITY;
            }
            sum += distance;
        }
        return sum;
    }

    public double computeDistance(TypeRef typeRef1, TypeRef typeRef2) throws UnsupportedTypeDistanceOperandsException {
        Type type2;
        Optional<Pair<Type, Type>> operands = this.extractTypeDistanceOperands(typeRef1, typeRef2);
        if (!operands.isPresent()) {
            return Double.POSITIVE_INFINITY;
        }
        Type type1 = (Type)operands.get().getKey();
        if (type1 == (type2 = (Type)operands.get().getValue())) {
            return 0.0;
        }
        if (type1 instanceof PrimitiveType || type2 instanceof PrimitiveType) {
            return Double.POSITIVE_INFINITY;
        }
        if (type1 instanceof BuiltInType || type2 instanceof BuiltInType) {
            return Double.POSITIVE_INFINITY;
        }
        if (typeRef1.getVersion() != typeRef2.getVersion()) {
            return Double.POSITIVE_INFINITY;
        }
        if (type1 instanceof TClassifier && type2 instanceof TClassifier) {
            return this.classifierDistance((TClassifier)type1, (TClassifier)type2);
        }
        throw new UnsupportedOperationException("Types (" + type1 + ",\n " + type2 + ") cannot be handled by the compile-time type distance computer.");
    }

    private Optional<Pair<Type, Type>> extractTypeDistanceOperands(TypeRef typeRef1, TypeRef typeRef2) throws UnsupportedTypeDistanceOperandsException {
        if (typeRef1 instanceof TypeTypeRef && typeRef2 instanceof TypeTypeRef && ((TypeTypeRef)typeRef1).getTypeArg() != null && ((TypeTypeRef)typeRef2).getTypeArg() != null) {
            TypeArgument typeTypeArg1 = ((TypeTypeRef)typeRef1).getTypeArg();
            TypeArgument typeTypeArg2 = ((TypeTypeRef)typeRef2).getTypeArg();
            if (typeTypeArg1 instanceof TypeRef && typeTypeArg2 instanceof TypeRef) {
                Type type1 = ((TypeRef)typeTypeArg1).getDeclaredType();
                Type type2 = ((TypeRef)typeTypeArg2).getDeclaredType();
                if (type1 != null && type2 != null) {
                    return Optional.of(Pair.of((Object)type1, (Object)type2));
                }
            }
        }
        if (typeRef1 instanceof TypeTypeRef || typeRef2 instanceof TypeTypeRef) {
            return Optional.empty();
        }
        Type type1 = typeRef1.getDeclaredType();
        Type type2 = typeRef2.getDeclaredType();
        if (type1 == null || type2 == null) {
            throw new UnsupportedTypeDistanceOperandsException("The TypeDistanceComputer does not support null types as input: type1=" + type1 + ", type2=" + type2);
        }
        if (this.isOfHandledClass(type1) && this.isOfHandledClass(type2)) {
            return Optional.of(Pair.of((Object)type1, (Object)type2));
        }
        throw new UnsupportedTypeDistanceOperandsException("No support for type-distance computation from " + type1.getClass() + " to " + type2.getClass() + " type model instances.");
    }

    private boolean isOfHandledClass(Type type) {
        return type instanceof PrimitiveType || type instanceof BuiltInType || type instanceof TClassifier;
    }

    private double classifierDistance(TClassifier classifier1, TClassifier classifier2) {
        SuperClassifierIterator superClassifierIterator = new SuperClassifierIterator(classifier1);
        while (superClassifierIterator.hasNext()) {
            SuperClassifierIterator.SuperClassifierEntry entry = superClassifierIterator.next();
            if (entry.classifier != classifier2) continue;
            return entry.level;
        }
        return Double.POSITIVE_INFINITY;
    }

    public static final class UnsupportedTypeDistanceOperandsException
    extends Exception {
        public UnsupportedTypeDistanceOperandsException(String message) {
            super(message);
        }
    }
}

