/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation.validators.flowgraphs;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.flowgraphs.FlowAnalyser;
import org.eclipse.n4js.flowgraphs.analysers.NullDereferenceAnalyser;
import org.eclipse.n4js.flowgraphs.analysers.NullDereferenceResult;
import org.eclipse.n4js.flowgraphs.dataflow.guards.GuardAssertion;
import org.eclipse.n4js.flowgraphs.dataflow.guards.GuardType;
import org.eclipse.n4js.n4JS.AssignmentExpression;
import org.eclipse.n4js.n4JS.DestructNode;
import org.eclipse.n4js.n4JS.DestructureUtils;
import org.eclipse.n4js.n4JS.ForStatement;
import org.eclipse.n4js.n4JS.FunctionDefinition;
import org.eclipse.n4js.n4JS.FunctionExpression;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSSourceContainer;
import org.eclipse.n4js.utils.FindReferenceHelper;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.n4js.validation.validators.N4JSFlowgraphValidator;
import org.eclipse.n4js.validation.validators.flowgraphs.FlowValidator;
import org.eclipse.xtext.EcoreUtil2;

public class NullUndefinedValidator
implements FlowValidator {
    private final NullDereferenceAnalyser nda;
    private final FindReferenceHelper findReferenceHelper;
    private final IN4JSCore n4jsCore;

    public NullUndefinedValidator(NullDereferenceAnalyser nullDereferenceAnalyser, IN4JSCore n4jsCore, FindReferenceHelper findReferenceHelper) {
        this.findReferenceHelper = findReferenceHelper;
        this.n4jsCore = n4jsCore;
        this.nda = nullDereferenceAnalyser;
    }

    @Override
    public FlowAnalyser getFlowAnalyser() {
        return this.nda;
    }

    @Override
    public void checkResults(N4JSFlowgraphValidator fVali) {
        this.internalCheckNullDereference(fVali);
    }

    private void internalCheckNullDereference(N4JSFlowgraphValidator fVali) {
        Iterable nullDerefs = this.nda.getNullDereferences();
        for (NullDereferenceResult ndr : nullDerefs) {
            String varName = ndr.checkedSymbol.getName();
            boolean isLeakingToClosure = this.isLeakingToClosure(ndr);
            boolean isInTestFolder = this.isInTestFolder((EObject)ndr.checkedSymbol.getASTLocation());
            if (isInTestFolder && isLeakingToClosure) continue;
            String isOrMaybe = this.getAssertionString(ndr, isLeakingToClosure);
            String nullOrUndefined = this.getNullOrUndefinedString(ndr);
            String reason = this.getReason(ndr);
            String msg = IssueCodes.getMessageForDFG_NULL_DEREFERENCE(varName, isOrMaybe, nullOrUndefined, reason);
            fVali.addIssue(msg, (EObject)ndr.cfe, "DFG_NULL_DEREFERENCE");
        }
    }

    private String getAssertionString(NullDereferenceResult ndr, boolean isLeakingToClosure) {
        if (ndr.assertion == GuardAssertion.AlwaysHolds && !isLeakingToClosure) {
            return "is";
        }
        return "may be";
    }

    private String getNullOrUndefinedString(NullDereferenceResult ndr) {
        String problemType = "";
        for (GuardType guardType : ndr.types) {
            problemType = String.valueOf(problemType) + (!problemType.isEmpty() ? " or " : "");
            switch (guardType) {
                case IsNull: {
                    problemType = String.valueOf(problemType) + "null";
                    break;
                }
                case IsUndefined: {
                    problemType = String.valueOf(problemType) + "undefined";
                    break;
                }
                default: {
                    problemType = String.valueOf(problemType) + "unknown";
                }
            }
        }
        return problemType;
    }

    private String getReason(NullDereferenceResult ndr) {
        if (ndr.failedAlias != null && !ndr.checkedSymbol.is(ndr.failedAlias)) {
            return " due to previous variable " + ndr.failedAlias.getName();
        }
        return "";
    }

    private boolean isLeakingToClosure(NullDereferenceResult ndr) {
        EObject decl = ndr.checkedSymbol.getDeclaration();
        List<EObject> refs = this.findReferenceHelper.findReferencesInResource(decl, decl.eResource());
        LinkedList<Object> writeRefs = new LinkedList<Object>();
        writeRefs.add(ndr.cfe);
        for (EObject ref : refs) {
            if (!this.isWriteAccess(ref)) continue;
            writeRefs.add(ref);
        }
        Iterator writeRefsIter = writeRefs.iterator();
        if (!writeRefsIter.hasNext()) {
            return false;
        }
        EObject ref = (EObject)writeRefsIter.next();
        EObject parentScope = this.getParentScope(ref);
        while (writeRefsIter.hasNext()) {
            ref = (EObject)writeRefsIter.next();
            if (parentScope == this.getParentScope(ref)) continue;
            return true;
        }
        return false;
    }

    private boolean isWriteAccess(EObject reference) {
        EObject parent = reference.eContainer();
        if (parent == null) {
            return false;
        }
        if (parent instanceof AssignmentExpression) {
            AssignmentExpression ae = (AssignmentExpression)parent;
            return ae.getLhs() == reference;
        }
        if (parent instanceof ForStatement) {
            ForStatement fs = (ForStatement)parent;
            return fs.getInitExpr() == reference;
        }
        DestructNode dNode = DestructureUtils.getCorrespondingDestructNode((EObject)reference);
        if (dNode != null) {
            return (dNode = dNode.findNodeForElement(parent)) != null;
        }
        return false;
    }

    private EObject getParentScope(EObject eobj) {
        Iterable containers = EcoreUtil2.getAllContainers((EObject)eobj);
        for (EObject container : containers) {
            boolean isScopeParent = false;
            isScopeParent |= container instanceof FunctionDefinition;
            if (!(isScopeParent |= container instanceof FunctionExpression)) continue;
            return container;
        }
        return null;
    }

    private boolean isInTestFolder(EObject eobj) {
        URI location = eobj.eResource().getURI();
        IN4JSSourceContainer c = (IN4JSSourceContainer)this.n4jsCore.findN4JSSourceContainer(location).orNull();
        return c != null && c.isTest();
    }
}

