/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils.process;

import com.google.common.base.Strings;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Pure;

@Accessors(value={AccessorType.PUBLIC_GETTER})
public class ProcessResult {
    private static final String LN = System.lineSeparator();
    private final int exitCode;
    private final String stdOut;
    private final String stdErr;

    ProcessResult(int exitCode, String stdOut, String stdErr) {
        this.exitCode = exitCode;
        this.stdOut = Strings.nullToEmpty((String)stdOut);
        this.stdErr = Strings.nullToEmpty((String)stdErr);
    }

    public boolean isOK() {
        return this.exitCode == 0;
    }

    public String toString() {
        return "Exit code:" + Integer.valueOf(this.exitCode) + LN + "Standard out:" + LN + this.stdOut + LN + "Standard error:" + LN + this.stdErr;
    }

    public Throwable toThrowable(String message) {
        Exception exc = new Exception(String.valueOf(message) + LN + LN + this.stdErr);
        exc.setStackTrace(new StackTraceElement[0]);
        return exc;
    }

    @Pure
    public int getExitCode() {
        return this.exitCode;
    }

    @Pure
    public String getStdOut() {
        return this.stdOut;
    }

    @Pure
    public String getStdErr() {
        return this.stdErr;
    }
}

