/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.hlc.base;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum ErrorExitCode {
    EXITCODE_WRONG_CMDLINE_OPTIONS(1, "wrong parameter set given"),
    EXITCODE_COMPILE_ERROR(2, "compilation did not succeed"),
    EXITCODE_CONFIGURATION_ERROR(3, "configuration is erroneous"),
    EXITCODE_RUNNER_NOT_FOUND(4, "required runner could not be loaded"),
    EXITCODE_MODULE_TO_RUN_NOT_FOUND(5, "module to run doesn't exist"),
    EXITCODE_RUNNER_STOPPED_WITH_ERROR(6, "unsuccessful execution of the runner"),
    EXITCODE_TEST_CATALOG_ASSEMBLATION_ERROR(7, "assembling the test catalog failed for compiler projects"),
    EXITCODE_CLEAN_ERROR(8, "cleaning projects encountered error"),
    EXITCODE_TESTER_STOPPED_WITH_ERROR(9, "unsuccessful execution of the tests"),
    EXITCODE_TESTER_NOT_FOUND(10, "required tester could not be loaded"),
    EXITCODE_DEPENDENCY_NOT_FOUND(11, "required dependency is missing"),
    EXITCODE_SRCFILES_INVALID(12, "At least one source file or project (last parameter) is neither file nor directory."),
    EXITCODE_PERFORMANCE_REPORT_COULD_NOT_BE_WRITTEN(13, "The performance report could not be written to disk.");

    private static final Map<Integer, ErrorExitCode> lookup;
    private final String explanation;
    private final int code;

    static {
        lookup = new HashMap<Integer, ErrorExitCode>();
        for (ErrorExitCode ec : EnumSet.allOf(ErrorExitCode.class)) {
            lookup.put(ec.getExitCodeValue(), ec);
        }
    }

    private ErrorExitCode(int code, String explanation) {
        this.code = code;
        this.explanation = explanation;
    }

    public String getExplanation() {
        return this.explanation;
    }

    public int getExitCodeValue() {
        return this.code;
    }

    public static ErrorExitCode fromInt(int code) {
        return lookup.get(code);
    }
}

