/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.analysis;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.n4js.flowgraphs.analysis.BranchWalkerInternal;
import org.eclipse.n4js.flowgraphs.analysis.GraphVisitorInternal;

public abstract class GraphExplorerInternal {
    final Set<BranchWalkerInternal> activeBranches = new HashSet<BranchWalkerInternal>();
    final LinkedList<BranchWalkerInternal> passedBranches = new LinkedList();
    final LinkedList<BranchWalkerInternal> failedBranchs = new LinkedList();
    final LinkedList<BranchWalkerInternal> allBranches = new LinkedList();
    protected final Quantor quantor;
    protected final boolean passAsDefault;
    private BranchWalkerInternal firstBranch;
    private BranchWalkerInternal lastBranch;
    private GraphVisitorInternal parentGraphVisitor;
    private State state;
    private int branchCounter = 0;

    protected GraphExplorerInternal() {
        this(Quantor.None, false);
    }

    protected GraphExplorerInternal(Quantor quantor) {
        this(quantor, true);
    }

    protected GraphExplorerInternal(Quantor quantor, boolean passAsDefault) {
        this.quantor = quantor;
        this.passAsDefault = passAsDefault;
        this.state = State.Active;
    }

    protected abstract BranchWalkerInternal firstBranchWalker();

    protected abstract BranchWalkerInternal joinBranchWalkers(List<BranchWalkerInternal> var1);

    final BranchWalkerInternal callFirstBranchWalker(GraphVisitorInternal parentGraphVisitorInternal) {
        this.parentGraphVisitor = parentGraphVisitorInternal;
        this.firstBranch = this.firstBranchWalker();
        this.firstBranch.callInitialize(this, (BranchWalkerInternal)null);
        this.lastBranch = this.firstBranch;
        return this.firstBranch;
    }

    final BranchWalkerInternal callJoinBranchWalkers(List<BranchWalkerInternal> branchWalkers) {
        if (branchWalkers.size() == 1) {
            return branchWalkers.get(0);
        }
        BranchWalkerInternal activeBranch = this.joinBranchWalkers(branchWalkers);
        for (BranchWalkerInternal bW : branchWalkers) {
            this.activeBranches.remove(bW);
            bW.deactivate();
        }
        if (activeBranch != null) {
            activeBranch.callInitialize(this, branchWalkers);
        }
        this.lastBranch = activeBranch;
        return activeBranch;
    }

    final void checkExplorerDeactivation() {
        if (this.activeBranches.isEmpty()) {
            boolean somePassed = !this.passedBranches.isEmpty();
            boolean someFailed = !this.failedBranchs.isEmpty();
            switch (this.quantor) {
                case ForAllBranches: 
                case AtLeastOneBranch: {
                    boolean explorerPassed = false;
                    explorerPassed |= somePassed && this.quantor == Quantor.AtLeastOneBranch;
                    explorerPassed |= somePassed && !someFailed && this.quantor == Quantor.ForAllBranches;
                    if (explorerPassed |= !somePassed && !someFailed && this.passAsDefault) {
                        this.state = State.Passed;
                        break;
                    }
                    this.state = State.Failed;
                    break;
                }
                case None: {
                    this.state = State.Terminated;
                }
            }
            this.parentGraphVisitor.deactivateGraphExplorer(this);
        }
    }

    final int getAndIncrementBranchCounter() {
        return this.branchCounter++;
    }

    public final boolean isPassed() {
        return this.state == State.Passed;
    }

    public final boolean isFailed() {
        return this.state == State.Failed;
    }

    public final void deactivateAll() {
        while (!this.activeBranches.isEmpty()) {
            BranchWalkerInternal aBranch = this.activeBranches.iterator().next();
            aBranch.deactivate();
        }
        this.checkExplorerDeactivation();
    }

    public final List<BranchWalkerInternal> getAllBranches() {
        return this.allBranches;
    }

    public final Set<BranchWalkerInternal> getActiveBranches() {
        return this.activeBranches;
    }

    public final BranchWalkerInternal getFirstBranch() {
        return this.firstBranch;
    }

    public final BranchWalkerInternal getLastBranch() {
        return this.lastBranch;
    }

    public final GraphVisitorInternal getGraphVisitorInternal() {
        return this.parentGraphVisitor;
    }

    public static enum Quantor {
        None,
        ForAllBranches,
        AtLeastOneBranch;

    }

    public static enum State {
        Active,
        Terminated,
        Passed,
        Failed;

    }
}

