/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.dataflow.guards;

import org.eclipse.n4js.flowgraphs.dataflow.guards.GuardStructure;
import org.eclipse.n4js.flowgraphs.dataflow.symbols.SymbolFactory;
import org.eclipse.n4js.flowgraphs.model.ControlFlowEdge;
import org.eclipse.n4js.flowgraphs.model.Node;
import org.eclipse.n4js.n4JS.BinaryLogicalExpression;
import org.eclipse.n4js.n4JS.ConditionalExpression;
import org.eclipse.n4js.n4JS.ControlFlowElement;
import org.eclipse.n4js.n4JS.DoStatement;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ForStatement;
import org.eclipse.n4js.n4JS.IfStatement;
import org.eclipse.n4js.n4JS.WhileStatement;

public class GuardStructureFactory {
    public static GuardStructure create(SymbolFactory symbolFactory, ControlFlowEdge edge) {
        boolean negate = false;
        switch (edge.cfType) {
            case IfFalse: 
            case LoopExit: {
                negate = true;
            }
            case IfTrue: 
            case LoopEnter: 
            case LoopReenter: {
                Expression condition = GuardStructureFactory.getCondition(edge);
                if (condition == null) break;
                return new GuardStructure(symbolFactory, condition, negate);
            }
        }
        return null;
    }

    private static Expression getCondition(ControlFlowEdge edge) {
        Expression condition = null;
        Node previousNode = edge.start;
        ControlFlowElement previousCFE = previousNode.getControlFlowElement();
        if (previousCFE instanceof ConditionalExpression) {
            ConditionalExpression ce = (ConditionalExpression)previousCFE;
            condition = ce.getExpression();
        } else if (previousCFE instanceof BinaryLogicalExpression) {
            BinaryLogicalExpression ble = (BinaryLogicalExpression)previousCFE;
            condition = ble.getLhs();
        } else if (previousCFE instanceof IfStatement) {
            IfStatement is = (IfStatement)previousCFE;
            condition = is.getExpression();
        } else if (previousCFE instanceof WhileStatement) {
            WhileStatement ws = (WhileStatement)previousCFE;
            condition = ws.getExpression();
        } else if (previousCFE instanceof DoStatement) {
            DoStatement ws = (DoStatement)previousCFE;
            condition = ws.getExpression();
        } else if (previousCFE instanceof ForStatement) {
            ForStatement ws = (ForStatement)previousCFE;
            condition = ws.getExpression();
        }
        return condition;
    }
}

