/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.dataflow;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.flowgraphs.dataflow.guards.GuardAssertion;
import org.eclipse.n4js.n4JS.BinaryLogicalExpression;
import org.eclipse.n4js.n4JS.EqualityExpression;
import org.eclipse.n4js.n4JS.UnaryExpression;
import org.eclipse.n4js.n4JS.UnaryOperator;

public class FlowAssertionFactory {
    public static GuardAssertion getGuard(EObject topContainer, EObject condition, boolean negateTree, boolean negateCondition) {
        EObject conditionParent = condition.eContainer();
        ArrayList<BooleanExpression> beList = FlowAssertionFactory.getBooleanExpressions(topContainer, conditionParent, negateCondition);
        HashSet<BooleanExpression> beSet = new HashSet<BooleanExpression>(beList);
        boolean mayHolds = false;
        mayHolds |= beSet.contains((Object)BooleanExpression.eq);
        if (mayHolds |= beSet.contains((Object)BooleanExpression.neq)) {
            return GuardAssertion.MayHolds;
        }
        return FlowAssertionFactory.get(beList, negateTree);
    }

    private static ArrayList<BooleanExpression> getBooleanExpressions(EObject topContainer, EObject condition, boolean negateCondition) {
        ArrayList<BooleanExpression> bExprs = new ArrayList<BooleanExpression>();
        if (negateCondition) {
            bExprs.add(BooleanExpression.not);
        }
        FlowAssertionFactory.addBooleanExpressions(topContainer, bExprs, condition);
        return bExprs;
    }

    private static void addBooleanExpressions(EObject topContainer, ArrayList<BooleanExpression> bExprs, EObject condition) {
        if (topContainer == condition) {
            return;
        }
        BooleanExpression nextValue = null;
        if (condition instanceof UnaryExpression) {
            UnaryExpression ue = (UnaryExpression)condition;
            if (ue.getOp() == UnaryOperator.NOT) {
                nextValue = BooleanExpression.not;
            }
        } else if (condition instanceof BinaryLogicalExpression) {
            BinaryLogicalExpression ble = (BinaryLogicalExpression)condition;
            switch (ble.getOp()) {
                case AND: {
                    nextValue = BooleanExpression.and;
                    break;
                }
                case OR: {
                    nextValue = BooleanExpression.or;
                }
            }
        } else if (condition instanceof EqualityExpression) {
            EqualityExpression ee = (EqualityExpression)condition;
            switch (ee.getOp()) {
                case SAME: 
                case EQ: {
                    nextValue = BooleanExpression.eq;
                    break;
                }
                case NSAME: 
                case NEQ: {
                    nextValue = BooleanExpression.neq;
                }
            }
        }
        if (nextValue != null) {
            bExprs.add(nextValue);
        }
        EObject parent = condition.eContainer();
        FlowAssertionFactory.addBooleanExpressions(topContainer, bExprs, parent);
    }

    private static void simplify(ArrayList<BooleanExpression> bExpressions, int startIdx) {
        BooleanExpression be0 = bExpressions.size() > startIdx + 0 ? bExpressions.get(startIdx + 0) : null;
        BooleanExpression be1 = bExpressions.size() > startIdx + 1 ? bExpressions.get(startIdx + 1) : null;
        int reverseStartIdx = Math.max(0, startIdx - 2);
        if (be0 == BooleanExpression.and && be1 == BooleanExpression.and) {
            bExpressions.remove(startIdx);
            FlowAssertionFactory.simplify(bExpressions, reverseStartIdx);
            return;
        }
        if (be0 == BooleanExpression.not && be1 == BooleanExpression.not) {
            bExpressions.remove(startIdx);
            bExpressions.remove(startIdx);
            FlowAssertionFactory.simplify(bExpressions, reverseStartIdx);
            return;
        }
        if (be0 == BooleanExpression.or && be1 == BooleanExpression.or) {
            bExpressions.remove(startIdx);
            FlowAssertionFactory.simplify(bExpressions, reverseStartIdx);
            return;
        }
        if (be0 == BooleanExpression.not && be1 == BooleanExpression.or) {
            bExpressions.remove(startIdx + 1);
            bExpressions.add(startIdx, BooleanExpression.and);
            FlowAssertionFactory.simplify(bExpressions, reverseStartIdx);
            return;
        }
        if (be0 == BooleanExpression.not && be1 == BooleanExpression.and) {
            bExpressions.remove(startIdx + 1);
            bExpressions.add(startIdx, BooleanExpression.or);
            FlowAssertionFactory.simplify(bExpressions, reverseStartIdx);
            return;
        }
        if (startIdx + 1 < bExpressions.size()) {
            FlowAssertionFactory.simplify(bExpressions, startIdx + 1);
        }
    }

    private static GuardAssertion get(ArrayList<BooleanExpression> beList, boolean negateTree) {
        if (negateTree) {
            beList.add(BooleanExpression.not);
        }
        FlowAssertionFactory.simplify(beList, 0);
        if (beList.size() == 0) {
            return GuardAssertion.AlwaysHolds;
        }
        if (beList.size() == 1) {
            switch (beList.get(0)) {
                case not: {
                    return GuardAssertion.NeverHolds;
                }
                case and: {
                    return GuardAssertion.AlwaysHolds;
                }
                case or: {
                    return GuardAssertion.MayHolds;
                }
            }
            return null;
        }
        if (beList.size() == 2) {
            BooleanExpression be0 = beList.get(0);
            BooleanExpression be1 = beList.get(1);
            if (be0 == BooleanExpression.and && be1 == BooleanExpression.not) {
                return GuardAssertion.MayHolds;
            }
            if (be0 == BooleanExpression.or && be1 == BooleanExpression.not) {
                return GuardAssertion.NeverHolds;
            }
        }
        return GuardAssertion.MayHolds;
    }

    private static enum BooleanExpression {
        or,
        and,
        not,
        eq,
        neq;

    }
}

