/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server.concurrent;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.xtext.ide.server.concurrent.AbstractRequest;
import org.eclipse.xtext.ide.server.concurrent.ReadRequest;
import org.eclipse.xtext.ide.server.concurrent.WriteRequest;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;

public class RequestManager {
    @Inject
    private ExecutorService parallel;
    @Inject
    private OperationCanceledManager operationCanceledManager;
    private final ExecutorService queue = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("RequestManager-Queue-%d").build());
    private ArrayList<AbstractRequest<?>> requests = CollectionLiterals.newArrayList();

    public void shutdown() {
        this.queue.shutdown();
        this.parallel.shutdown();
        this.cancel();
    }

    public <V> CompletableFuture<V> runRead(Functions.Function1<? super CancelIndicator, ? extends V> cancellable) {
        ReadRequest<? extends V> _readRequest = new ReadRequest<V>(cancellable, this.parallel);
        return this.submit(_readRequest);
    }

    public <U, V> CompletableFuture<V> runWrite(Functions.Function0<? extends U> nonCancellable, Functions.Function2<? super CancelIndicator, ? super U, ? extends V> cancellable) {
        CompletableFuture<Void> cancelFuture = this.cancel();
        WriteRequest<? super U, ? extends V> _writeRequest = new WriteRequest<U, V>(nonCancellable, cancellable, cancelFuture);
        return this.submit(_writeRequest);
    }

    protected <V> CompletableFuture<V> submit(AbstractRequest<V> request) {
        this.requests.add(request);
        this.queue.submit(request);
        return request.get();
    }

    protected CompletableFuture<Void> cancel() {
        ArrayList<AbstractRequest<?>> localRequests = this.requests;
        this.requests = CollectionLiterals.newArrayList();
        ArrayList cfs = CollectionLiterals.newArrayList();
        for (AbstractRequest<?> request : localRequests) {
            request.cancel();
            CompletableFuture<?> _get = request.get();
            cfs.add(_get);
        }
        return CompletableFuture.allOf((CompletableFuture[])Conversions.unwrapArray((Object)cfs, CompletableFuture.class));
    }

    protected boolean isCancelException(Throwable t) {
        if (t == null) {
            return false;
        }
        Throwable _xifexpression = null;
        _xifexpression = t instanceof CompletionException ? ((CompletionException)t).getCause() : t;
        Throwable cause = _xifexpression;
        return this.operationCanceledManager.isOperationCanceledException(cause);
    }
}

