/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ts.utils;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.n4js.n4JS.ArrowFunction;
import org.eclipse.n4js.n4JS.Block;
import org.eclipse.n4js.n4JS.FunctionDefinition;
import org.eclipse.n4js.n4JS.FunctionExpression;
import org.eclipse.n4js.n4JS.FunctionOrFieldAccessor;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.n4JS.LocalArgumentsVariable;
import org.eclipse.n4js.n4JS.SuperLiteral;
import org.eclipse.n4js.n4JS.ThisArgProvider;
import org.eclipse.n4js.n4JS.ThisLiteral;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.utils.EcoreUtilN4;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class LambdaUtils {
    public static Iterator<EObject> thisLiterals(Block body) {
        Predicate _function = it -> {
            boolean _introducesThisContext = LambdaUtils.introducesThisContext(it);
            return !_introducesThisContext;
        };
        Functions.Function1 _function_1 = it -> it instanceof ThisLiteral;
        return IteratorExtensions.filter((Iterator)EcoreUtilN4.getAllContentsFiltered((EObject)body, (Predicate)_function), (Functions.Function1)_function_1);
    }

    private static boolean introducesThisContext(EObject node) {
        boolean _switchResult = false;
        boolean _matched = false;
        if (node instanceof FunctionExpression) {
            _matched = true;
            boolean _isArrowFunction = ((FunctionExpression)node).isArrowFunction();
            boolean bl = _switchResult = !_isArrowFunction;
        }
        if (!_matched && node instanceof FunctionDefinition) {
            _matched = true;
            _switchResult = true;
        }
        if (!_matched && node instanceof ThisArgProvider) {
            _matched = true;
            _switchResult = true;
        }
        if (!_matched) {
            _switchResult = false;
        }
        return _switchResult;
    }

    public static Iterator<? extends IdentifierRef> argumentsOccurrences(Block body, LocalArgumentsVariable target) {
        if (target == null) {
            return CollectionLiterals.emptyList().iterator();
        }
        Predicate _function = it -> {
            boolean _introducesThisContext = LambdaUtils.introducesThisContext(it);
            return !_introducesThisContext;
        };
        Functions.Function1 _function_1 = it -> {
            IdentifiableElement _id = it.getId();
            return _id == target;
        };
        return IteratorExtensions.filter((Iterator)Iterators.filter((Iterator)EcoreUtilN4.getAllContentsFiltered((EObject)body, (Predicate)_function), IdentifierRef.class), (Functions.Function1)_function_1);
    }

    public static Iterator<? extends IdentifierRef> allArgumentsUsages(FunctionOrFieldAccessor argumentsBindingConstruct) {
        Iterator result = LambdaUtils.argumentsOccurrences(argumentsBindingConstruct.getBody(), argumentsBindingConstruct.get_lok());
        Functions.Function1 _function = it -> LambdaUtils.allArgumentsUsages((FunctionOrFieldAccessor)it);
        List _map = ListExtensions.map(LambdaUtils.directlyEnclosedLambdas(argumentsBindingConstruct.getBody()), (Functions.Function1)_function);
        for (Iterator nestedResult : _map) {
            result = Iterators.concat(result, (Iterator)nestedResult);
        }
        boolean _isEmpty = IteratorExtensions.isEmpty(result);
        if (_isEmpty) {
            return Collections.emptyIterator();
        }
        return result;
    }

    public static Iterator<SuperLiteral> superLiterals(Block body) {
        return Iterators.filter((Iterator)body.eAllContents(), SuperLiteral.class);
    }

    public static List<FunctionExpression> directlyEnclosedLambdas(Block body) {
        HashSet result = new HashSet();
        Set candidates = IteratorExtensions.toSet(LambdaUtils.allLambdas(body));
        result.addAll(candidates);
        for (ArrowFunction candidate : candidates) {
            Functions.Function1 _function = it -> candidate != it && LambdaUtils.isEnclosedBy((EObject)candidate, (EObject)it);
            boolean isCandidateItselfNested = IterableExtensions.exists(result, (Functions.Function1)_function);
            if (!isCandidateItselfNested) continue;
            result.remove(candidate);
        }
        return IterableExtensions.toList(result);
    }

    public static Iterator<ArrowFunction> allLambdas(Block body) {
        Predicate _function = it -> {
            boolean _introducesThisContext = LambdaUtils.introducesThisContext(it);
            return !_introducesThisContext;
        };
        return Iterators.filter((Iterator)EcoreUtilN4.getAllContentsFiltered((EObject)body, (Predicate)_function), ArrowFunction.class);
    }

    public static boolean isEnclosedBy(EObject inner, EObject outer) {
        return EcoreUtil.isAncestor((EObject)outer, (EObject)inner);
    }

    public static boolean isLambda(EObject funDef) {
        return funDef instanceof ArrowFunction;
    }

    public static boolean isSingleExprImplicitReturn(FunctionOrFieldAccessor funDef) {
        boolean _xifexpression = false;
        boolean _isLambda = LambdaUtils.isLambda((EObject)funDef);
        _xifexpression = _isLambda ? ((ArrowFunction)funDef).isSingleExprImplicitReturn() : false;
        return _xifexpression;
    }

    public static ThisArgProvider nearestEnclosingThisBinder(EObject expr) {
        if (expr == null) {
            return null;
        }
        ThisArgProvider enclosingThisBinder = (ThisArgProvider)EcoreUtil2.getContainerOfType((EObject)expr, ThisArgProvider.class);
        if (enclosingThisBinder == null) {
            return null;
        }
        boolean _isLambda = LambdaUtils.isLambda((EObject)enclosingThisBinder);
        if (_isLambda) {
            return LambdaUtils.nearestEnclosingThisBinder(enclosingThisBinder.eContainer());
        }
        return enclosingThisBinder;
    }

    public static boolean isTopLevelLambda(FunctionExpression funExpr) {
        boolean _and = false;
        boolean _isLambda = LambdaUtils.isLambda((EObject)funExpr);
        if (!_isLambda) {
            _and = false;
        } else {
            boolean _xblockexpression = false;
            EObject enclosing = funExpr.eContainer();
            ThisArgProvider _nearestEnclosingThisBinder = LambdaUtils.nearestEnclosingThisBinder(enclosing);
            _and = _xblockexpression = _nearestEnclosingThisBinder == null;
        }
        return _and;
    }
}

