/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.parser;

import org.antlr.runtime.BitSet;
import org.antlr.runtime.IntStream;
import org.antlr.runtime.MismatchedTokenException;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.RecognizerSharedState;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenStream;

public class SemicolonInjectionHelper {
    public static void recover(IntStream inputStream, RecognitionException re, Callback callback) {
        int expecting;
        RecognizerSharedState state = callback.getState();
        if (re instanceof MismatchedTokenException && (expecting = ((MismatchedTokenException)re).expecting) != 100) {
            callback.discardError();
            callback.recoverBase(inputStream, re);
            return;
        }
        int unexpectedTokenType = re.token.getType();
        if (!SemicolonInjectionHelper.followedBySemicolon(state, callback.getRecoverySets(), re.index) || SemicolonInjectionHelper.isOffendingToken(unexpectedTokenType)) {
            callback.recoverBase(inputStream, re);
        } else {
            int la = inputStream.LA(1);
            TokenStream casted = (TokenStream)inputStream;
            if (!SemicolonInjectionHelper.isOffendingToken(la)) {
                int ix = re.token.getTokenIndex() - 1;
                while (ix > 0) {
                    Token lt = casted.get(ix);
                    if (lt.getChannel() == 0) {
                        callback.recoverBase(inputStream, re);
                        return;
                    }
                    if (lt.getType() == 152) {
                        if (!callback.allowASI(re)) {
                            callback.recoverBase(inputStream, re);
                            return;
                        }
                        if (!SemicolonInjectionHelper.findCommaBeforeEOL(casted, ix)) {
                            callback.addASIMessage();
                            return;
                        }
                    } else if (lt.getType() == 150) {
                        String tokenText = lt.getText();
                        if (!(SemicolonInjectionHelper.findCommaBeforeEOL(casted, ix) || tokenText.indexOf(10, 2) < 2 && tokenText.indexOf(13, 2) < 2)) {
                            callback.addASIMessage();
                            return;
                        }
                    }
                    --ix;
                }
                callback.recoverBase(inputStream, re);
            }
        }
    }

    private static boolean followedBySemicolon(RecognizerSharedState state, Callback.RecoverySets recoverySets, int currentIndex) {
        long[] array;
        int top = state._fsp;
        if (currentIndex != state.lastErrorIndex && (array = state.following[top].toPackedArray()).length == 1 && array[0] == 2L) {
            return false;
        }
        int i = top;
        while (i >= 0) {
            BitSet localFollowSet = state.following[i];
            if (recoverySets.matches(localFollowSet)) {
                return true;
            }
            --i;
        }
        return false;
    }

    public static void promoteEOL(Callback callback) {
        RecognizerSharedState state = callback.getState();
        TokenStream input = callback.getInput();
        if (state.lastErrorIndex == input.size()) {
            return;
        }
        Token prev = input.LT(-1);
        Token next = input.LT(1);
        int la = next.getType();
        int idx = prev == null ? 0 : prev.getTokenIndex() + 1;
        int max = la == -1 ? input.size() : next.getTokenIndex();
        while (idx < max) {
            Token lt = input.get(idx);
            if (lt.getChannel() == 0) break;
            if (SemicolonInjectionHelper.isSemicolonEquivalent(lt)) {
                lt.setChannel(0);
                input.seek(idx);
                break;
            }
            ++idx;
        }
    }

    public static boolean hasDisallowedEOL(Callback callback) {
        TokenStream input = callback.getInput();
        Token lt = input.LT(1);
        int ix = lt.getTokenIndex() - 1;
        while (ix > 0) {
            lt = input.get(ix);
            if (lt.getChannel() == 0) break;
            if (SemicolonInjectionHelper.isSemicolonEquivalent(lt)) {
                return true;
            }
            --ix;
        }
        return false;
    }

    public static boolean isOffendingToken(int la) {
        return la == 100 || la == -1 || la == 111 || la == 152 || la == 150;
    }

    private static boolean findCommaBeforeEOL(TokenStream casted, int startIndex) {
        int ix = startIndex - 1;
        while (ix > 0) {
            Token lt = casted.get(ix);
            if (lt.getType() == 95) {
                return true;
            }
            if (lt.getChannel() == 0) break;
            --ix;
        }
        return false;
    }

    static boolean isSemicolonEquivalent(Token lt) {
        if (lt.getType() == 152) {
            return true;
        }
        if (lt.getType() == 150) {
            String tokenText = lt.getText();
            int i = 2;
            while (i < tokenText.length() - 2) {
                char c = tokenText.charAt(i);
                if (c == '\n' || c == '\r') {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static interface Callback {
        public RecognizerSharedState getState();

        public TokenStream getInput();

        public BitSet getSemicolonFollowSet();

        default public int getCommaBit() {
            throw new UnsupportedOperationException();
        }

        default public RecoverySets getRecoverySets() {
            throw new UnsupportedOperationException();
        }

        default public RecoverySets computeRecoverySets() {
            BitSet followSet = this.getSemicolonFollowSet();
            long[] array = followSet.toPackedArray();
            if (array.length != 3 || array[0] != 0L) {
                throw new RuntimeException("Internal token types changed. Need to rework ASI.");
            }
            int commaBit = this.getCommaBit() - 64;
            if (commaBit < 0 || commaBit > 64) {
                throw new RuntimeException("Internal token types changed. Need to rework ASI.");
            }
            RecoverySets result = new RecoverySets(array, commaBit);
            return result;
        }

        public void recoverBase(IntStream var1, RecognitionException var2);

        public void addASIMessage();

        public void discardError();

        public boolean allowASI(RecognitionException var1);

        public static class RecoverySets {
            private final long semicolonRecoverySetLeft;
            private final long semicolonRecoverySetRight;
            private final long semicolonRecoverySetWithComma;

            private RecoverySets(long[] array, int commaBit) {
                this.semicolonRecoverySetLeft = array[1];
                this.semicolonRecoverySetRight = array[2];
                this.semicolonRecoverySetWithComma = array[1] | 1L << commaBit;
            }

            boolean matches(BitSet bitSet) {
                long[] array = bitSet.toPackedArray();
                int len = array.length;
                if (len < 3 || array[0] != 0L) {
                    return false;
                }
                long leftBits = array[1];
                long rightBits = array[2];
                if (rightBits == this.semicolonRecoverySetRight && (leftBits == this.semicolonRecoverySetLeft || leftBits == this.semicolonRecoverySetWithComma)) {
                    int i = 3;
                    while (i < len) {
                        if (array[i] != 0L) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

