/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.smith.ui.graph;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Stream;
import org.eclipse.n4js.smith.ui.graph.Rectangle;
import org.eclipse.n4js.smith.ui.graph.VisualisationNode;

public class VisualisationGraph {
    private final List<VisualisationNode> roots = new LinkedList<VisualisationNode>();
    private final Set<VisualisationNode> nodes = Collections.newSetFromMap(new WeakHashMap());

    public VisualisationGraph(VisualisationNode ... rootNodes) {
        int i = 0;
        while (i < rootNodes.length) {
            VisualisationNode stackNode = rootNodes[i];
            stackNode.sortChildren(VisualisationGraph::desc);
            this.roots.add(stackNode);
            this.getTree(stackNode).forEach(this.nodes::add);
            ++i;
        }
    }

    public Rectangle getBounds() {
        Iterator<VisualisationNode> i = this.nodes.iterator();
        if (i.hasNext()) {
            float xMin = Float.MAX_VALUE;
            float xMax = Float.MIN_VALUE;
            float yMin = Float.MAX_VALUE;
            float yMax = Float.MIN_VALUE;
            while (i.hasNext()) {
                VisualisationNode n = i.next();
                xMin = Math.min(xMin, n.getX());
                yMin = Math.min(yMin, n.getY());
                xMax = Math.max(xMax, n.getX() + n.getWidth());
                yMax = Math.max(yMax, n.getY() + n.getHeight());
            }
            return new Rectangle(xMin, yMin, xMax - xMin, yMax - yMin);
        }
        return Rectangle.EMPTY;
    }

    private static int desc(VisualisationNode node1, VisualisationNode node2) {
        return Float.compare(node2.getWidth(), node1.getWidth());
    }

    public void layout() {
        this.roots.stream().flatMap(this::getTree).forEach(n -> n.trim());
        this.doStackLayout();
    }

    private void doStackLayout() {
        this.layoutLayer(null, this.roots);
    }

    public Stream<VisualisationNode> getTree(VisualisationNode node) {
        return Stream.concat(Stream.of(node), node.getChildren().stream().flatMap(this::getTree));
    }

    private void layoutLayer(VisualisationNode parent, List<VisualisationNode> siblings) {
        VisualisationNode prevY = null;
        int i = 0;
        while (i < siblings.size()) {
            VisualisationNode child = siblings.get(i);
            this.positionNode(child, prevY, parent);
            this.layoutLayer(child, child.getChildren());
            prevY = child;
            ++i;
        }
    }

    private void positionNode(VisualisationNode node, VisualisationNode prevX, VisualisationNode prevY) {
        float px = 0.0f;
        float py = 0.0f;
        if (prevX != null) {
            px = prevX.getX() + prevX.getWidth();
            py = prevX.getY();
        } else if (prevY != null) {
            px = prevY.getX();
            py = prevY.getY() + prevY.getHeight();
        }
        node.move(px, py);
    }

    public void moveTree(VisualisationNode node, float dx, float dy) {
        node.move(dx, dy);
        node.getChildren().forEach(ch -> this.moveTree((VisualisationNode)ch, dx, dy));
    }

    public VisualisationNode getNodeAt(float x, float y) {
        for (VisualisationNode n : this.nodes) {
            if (!n.contains(x, y)) continue;
            return n;
        }
        return null;
    }

    public Set<VisualisationNode> getNodes() {
        return new HashSet<VisualisationNode>(this.nodes);
    }
}

