/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.validation;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.xpect.Component;
import org.eclipse.xpect.Environment;
import org.eclipse.xpect.XpectPackage;
import org.eclipse.xpect.XpectTest;
import org.eclipse.xpect.registry.ILanguageInfo;
import org.eclipse.xpect.setup.XpectSetupComponent;
import org.eclipse.xpect.util.EnvironmentUtil;
import org.eclipse.xpect.util.JvmAnnotationUtil;
import org.eclipse.xpect.util.URIDelegationHandler;
import org.eclipse.xpect.validation.AbstractXpectJavaValidator;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.validation.Check;

public class XpectJavaValidator
extends AbstractXpectJavaValidator {
    @Inject
    private URIDelegationHandler uriDelegationHandler;
    @Inject
    private TypeReferences typeReferences;

    @Override
    protected List<EPackage> getEPackages() {
        return Collections.singletonList(XpectPackage.eINSTANCE);
    }

    @Check
    public void validateLanguageModulesAreOnClasspath(XpectTest test) {
        if (EnvironmentUtil.ENVIRONMENT == Environment.WORKBENCH) {
            return;
        }
        String extension = this.uriDelegationHandler.getOriginalFileExtension(test.eResource().getURI().lastSegment());
        if (extension == null || "xpect".equals(extension)) {
            return;
        }
        ILanguageInfo languageInfo = ILanguageInfo.Registry.INSTANCE.getLanguageByFileExtension(extension);
        this.validateClassIsOnClasspath(languageInfo.getRuntimeModuleClass(), (Notifier)test);
        if (EcorePlugin.IS_ECLIPSE_RUNNING) {
            this.validateClassIsOnClasspath(languageInfo.getUIModuleClass(), (Notifier)test);
        }
    }

    protected void validateClassIsOnClasspath(Class<?> cls, Notifier ctx) {
        if (this.typeReferences.findDeclaredType(cls, ctx) == null) {
            this.error("The class " + cls.getName() + " is not on the classpath", (EStructuralFeature)XpectPackage.Literals.XPECT_TEST__DECLARED_SUITE);
        }
    }

    @Check
    public void checkComponent(Component component) {
        JvmDeclaredType type = component.getComponentClass();
        if (type == null || type.eIsProxy()) {
            return;
        }
        XpectSetupComponent annotation = JvmAnnotationUtil.getJavaAnnotation((JvmAnnotationTarget)type, XpectSetupComponent.class);
        if (annotation == null) {
            String message = "The class " + type.getQualifiedName() + " must be annotated with @" + XpectSetupComponent.class.getSimpleName();
            this.warning(message, (EStructuralFeature)XpectPackage.Literals.COMPONENT__COMPONENT_CLASS);
        }
    }
}

