/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.model;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.eclipse.xpect.XjmXpectMethod;
import org.eclipse.xpect.XpectInvocation;
import org.eclipse.xpect.model.XpectArgumentImpl;
import org.eclipse.xpect.state.XpectStateAnnotation;
import org.eclipse.xpect.util.AnnotationUtil;

public class XpectArgumentImplCustom
extends XpectArgumentImpl {
    @Override
    public <T extends Annotation> T getAnnotationOrDefault(Class<T> annotationType) {
        Annotation[] annotations;
        Method javaMethod = this.getJavaMethod();
        if (javaMethod == null) {
            return null;
        }
        Annotation[] annotationArray = annotations = javaMethod.getParameterAnnotations()[this.getIndex()];
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation a = annotationArray[n2];
            if (annotationType.isInstance(a)) {
                return (T)((Annotation)annotationType.cast(a));
            }
            ++n2;
        }
        return AnnotationUtil.newInstanceWithDefaults(annotationType);
    }

    private Method getJavaMethod() {
        Method javaMethod;
        XjmXpectMethod xjmMethod;
        XpectInvocation statement = this.getStatement();
        if (statement != null && (xjmMethod = statement.getMethod()) != null && !xjmMethod.eIsProxy() && (javaMethod = xjmMethod.getJavaMethod()) != null) {
            return javaMethod;
        }
        return null;
    }

    @Override
    public Class<?> getJavaType() {
        Method javaMethod = this.getJavaMethod();
        if (javaMethod == null) {
            return null;
        }
        return javaMethod.getParameterTypes()[this.getIndex()];
    }

    @Override
    public Annotation getStateAnnotation() {
        Annotation[] candidates;
        Method method = this.getJavaMethod();
        if (method == null) {
            return null;
        }
        Annotation[] annotationArray = candidates = method.getParameterAnnotations()[this.getIndex()];
        int n = candidates.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation a = annotationArray[n2];
            if (a.annotationType().getAnnotation(XpectStateAnnotation.class) != null) {
                return a;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public XpectInvocation getStatement() {
        return (XpectInvocation)this.eContainer();
    }

    @Override
    public String toString() {
        return this.toTypeAndName();
    }

    @Override
    public String toString(boolean showClass, boolean showMethod) {
        Method javaMethod = this.getJavaMethod();
        if (javaMethod == null) {
            return "(unresolved)";
        }
        StringBuilder builder = new StringBuilder();
        if (showClass) {
            builder.append(javaMethod.getDeclaringClass().getName());
            builder.append(".");
        }
        if (showMethod || showClass) {
            builder.append(javaMethod.getName());
            builder.append("(");
            int i = this.getIndex();
            ArrayList args = Lists.newArrayList();
            if (i > 0) {
                args.add("...");
            }
            args.add(this.toTypeAndName());
            if (i < javaMethod.getParameterTypes().length - 1) {
                args.add("...");
            }
            builder.append(Joiner.on((String)", ").join((Iterable)args));
            builder.append(")");
            return builder.toString();
        }
        return this.toTypeAndName();
    }

    private String toTypeAndName() {
        String name = " arg" + this.getIndex();
        Class<?> javaType = this.getJavaType();
        if (javaType == null) {
            return name;
        }
        return String.valueOf(javaType.getSimpleName()) + name;
    }
}

