/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.quickfix;

import java.util.Collection;
import org.eclipse.core.resources.IMarker;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.ui.changes.ChangeManager;
import org.eclipse.n4js.ui.changes.IChange;
import org.eclipse.n4js.ui.quickfix.N4JSIssue;
import org.eclipse.n4js.ui.quickfix.N4Modification;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.edit.IModification;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.validation.Issue;

public class N4ModificationWrapper
implements IModification {
    private final N4Modification modification;
    private final Issue issue;
    private final ChangeManager changeManager;

    public N4ModificationWrapper(N4Modification modification, Issue issue, ChangeManager changeManager) {
        this.modification = modification;
        this.issue = issue;
        this.changeManager = changeManager;
    }

    public N4Modification getN4Modification() {
        return this.modification;
    }

    public Issue getIssue() {
        return this.issue;
    }

    public final void apply(final IModificationContext context) throws Exception {
        context.getXtextDocument().modify((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

            public void process(XtextResource resource) throws Exception {
                IMarker marker = N4ModificationWrapper.this.issue instanceof N4JSIssue ? ((N4JSIssue)N4ModificationWrapper.this.issue).getMarker() : null;
                EObject element = resource.getEObject(N4ModificationWrapper.this.issue.getUriToProblem().fragment());
                Collection<? extends IChange> changes = N4ModificationWrapper.this.modification.computeChanges(context, marker, N4ModificationWrapper.this.issue.getOffset(), N4ModificationWrapper.this.issue.getLength(), element);
                N4ModificationWrapper.this.modification.computeFinalChanges();
                N4ModificationWrapper.this.changeManager.applyAll(changes);
            }
        });
    }
}

