/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.ui.common;

import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringJoiner;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.N4JSGlobals;
import org.eclipse.n4js.generator.AbstractSubGenerator;
import org.eclipse.n4js.generator.GeneratorOption;
import org.eclipse.n4js.n4JS.AnnotableElement;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.IN4JSSourceContainer;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;
import org.eclipse.n4js.runner.RunConfiguration;
import org.eclipse.n4js.runner.RunnerFrontEnd;
import org.eclipse.n4js.runner.extension.RunnerRegistry;
import org.eclipse.n4js.runner.nodejs.NodeRunner;
import org.eclipse.n4js.test.helper.hlc.N4jsLibsAccess;
import org.eclipse.n4js.utils.io.FileCopier;
import org.eclipse.n4js.utils.io.FileDeleter;
import org.eclipse.n4js.utils.io.FileUtils;
import org.eclipse.n4js.xpect.common.ResourceTweaker;
import org.eclipse.n4js.xpect.ui.common.ReadOutConfiguration;
import org.eclipse.n4js.xpect.ui.common.ReadOutResourceSetConfiguration;
import org.eclipse.n4js.xpect.ui.common.ReadOutWorkspaceConfiguration;
import org.eclipse.n4js.xpect.ui.common.XpectN4JSES5GeneratorHelper;
import org.eclipse.n4js.xpect.ui.common.XpectOutputConfigRunner;
import org.eclipse.xpect.setup.ISetupInitializer;
import org.eclipse.xpect.xtext.lib.setup.FileSetupContext;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.junit.Assert;

public class XpectN4JSES5TranspilerHelper {
    @Inject
    private IN4JSCore core;
    @Inject
    private XpectN4JSES5GeneratorHelper xpectGenerator;
    @Inject
    private FileExtensionProvider fileExtensionProvider;
    @Inject
    private XpectOutputConfigRunner configRunner;
    @Inject
    private RunnerFrontEnd runnerFrontEnd;
    @Inject
    private RunnerRegistry runnerRegistry;
    private ReadOutConfiguration readOutConfiguration;

    @Inject
    private void init(NodeRunner.NodeRunnerDescriptorProvider descriptorProvider) {
        if (!this.runnerRegistry.isRegistered("org.eclipse.n4js.runner.nodejs.NODEJS")) {
            this.runnerRegistry.register(descriptorProvider.get());
        }
    }

    public String doCompileAndExecute(XtextResource resource, ISetupInitializer<Object> init, FileSetupContext fileSetupContext, boolean decorateStdStreams, ResourceTweaker resourceTweaker, GeneratorOption[] options) throws IOException {
        Path temporaryRoot = Files.createTempDirectory("n4jsXpectOutputTest", new FileAttribute[0]);
        try {
            String string = this.doCompileAndExecute(resource, init, fileSetupContext, decorateStdStreams, resourceTweaker, options, temporaryRoot);
            return string;
        }
        finally {
            FileDeleter.deleteOnExit((Path)temporaryRoot);
        }
    }

    private String doCompileAndExecute(XtextResource resource, ISetupInitializer<Object> init, FileSetupContext fileSetupContext, boolean decorateStdStreams, ResourceTweaker resourceTweaker, GeneratorOption[] options, Path root) throws IOException {
        RunConfiguration runConfig;
        if (resourceTweaker != null) {
            resourceTweaker.tweak(resource);
        }
        this.loadXpectConfiguration(init, fileSetupContext);
        if (Platform.isRunning()) {
            Path packagesPath = this.createTemporaryYarnWorkspace(root);
            boolean replaceQuotes = false;
            Script script = (Script)resource.getContents().get(0);
            this.createTempJsFileWithScript(packagesPath, script, options, replaceQuotes).toPath().getParent();
            String fileToRun = this.jsModulePathToRun(script);
            String artificialProjectName = script.getModule().getProjectName();
            runConfig = this.runnerFrontEnd.createXpectOutputTestConfiguration("org.eclipse.n4js.runner.nodejs.NODEJS", fileToRun, packagesPath.resolve(artificialProjectName), new N4JSProjectName(artificialProjectName));
        } else {
            FluentIterable dependencies = FluentIterable.from(this.getDependentResources());
            boolean replaceQuotes = false;
            StringBuilder errorResult = new StringBuilder();
            Script testScript = (Script)resource.getContents().get(0);
            for (Resource dep : FluentIterable.from((Iterable)dependencies).filter(r -> !r.getURI().equals(resource.getURI()))) {
                if ("n4jsd".equalsIgnoreCase(dep.getURI().fileExtension())) {
                    this.compileImplementationOfN4JSDFile(root, errorResult, dep, options, replaceQuotes);
                    continue;
                }
                if (!this.xpectGenerator.isCompilable(dep, errorResult)) continue;
                Script script = (Script)dep.getContents().get(0);
                this.createTempJsFileWithScript(root, script, options, replaceQuotes);
            }
            if (errorResult.length() != 0) {
                return errorResult.toString();
            }
            this.createTempJsFileWithScript(root, testScript, options, replaceQuotes);
            String fileToRun = this.jsModulePathToRun(testScript);
            String artificialProjectName = testScript.getModule().getProjectName();
            N4jsLibsAccess.installN4jsLibs((Path)root.resolve(artificialProjectName).resolve("node_modules"), (boolean)true, (boolean)false, (boolean)false, (N4JSProjectName[])new N4JSProjectName[]{N4JSGlobals.N4JS_RUNTIME});
            runConfig = this.runnerFrontEnd.createXpectOutputTestConfiguration("org.eclipse.n4js.runner.nodejs.NODEJS", fileToRun, root.resolve(artificialProjectName), new N4JSProjectName(artificialProjectName));
        }
        return this.configRunner.executeWithConfig(runConfig, decorateStdStreams);
    }

    private Path createTemporaryYarnWorkspace(Path location) throws IOException {
        Path nodeModulesPath = location.resolve("node_modules");
        Files.createDirectories(nodeModulesPath, new FileAttribute[0]);
        Path packagesPath = location.resolve("packages");
        Files.createDirectories(packagesPath, new FileAttribute[0]);
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            Path target = packagesPath.resolve(project.getName());
            FileCopier.copy((Path)project.getLocation().toFile().toPath(), (Path)target);
            Files.createSymbolicLink(nodeModulesPath.resolve(project.getName()), target, new FileAttribute[0]);
            ++n2;
        }
        Files.write(location.resolve("package.json"), (Iterable<? extends CharSequence>)Lists.newArrayList((Object[])new String[]{"{\n", "  \"private\": true,\n", "  \"workspaces\": [ \"packages/*\" ]\n", "}\n"}), new OpenOption[0]);
        N4jsLibsAccess.installN4jsLibs((Path)nodeModulesPath, (boolean)true, (boolean)false, (boolean)false, (N4JSProjectName[])new N4JSProjectName[]{N4JSGlobals.N4JS_RUNTIME});
        return packagesPath;
    }

    private void loadXpectConfiguration(ISetupInitializer<Object> init, FileSetupContext fileSetupContext) {
        this.readOutConfiguration = Platform.isRunning() ? new ReadOutWorkspaceConfiguration(fileSetupContext, this.core, this.fileExtensionProvider) : new ReadOutResourceSetConfiguration(fileSetupContext, this.core);
        init.initialize((Object)this.readOutConfiguration);
    }

    private List<Resource> getDependentResources() {
        Assert.assertNotNull((String)"Xpect configuration has not been loaded!", (Object)this.readOutConfiguration);
        List<Object> resourcesFromXpectConfiguredResourceSet = new ArrayList();
        resourcesFromXpectConfiguredResourceSet = this.readOutConfiguration.getResources();
        return Collections.unmodifiableList(new ArrayList(resourcesFromXpectConfiguredResourceSet));
    }

    private void compileImplementationOfN4JSDFile(Path root, StringBuilder errorResult, Resource dep, GeneratorOption[] options, boolean replaceQuotes) {
        Script script = (Script)dep.getContents().get(0);
        if (AnnotationDefinition.PROVIDED_BY_RUNTIME.hasAnnotation((AnnotableElement)script)) {
            return;
        }
        Optional sourceOpt = this.core.findN4JSSourceContainer(dep.getURI());
        if (sourceOpt.isPresent()) {
            IN4JSSourceContainer source = (IN4JSSourceContainer)sourceOpt.get();
            IN4JSProject project = source.getProject();
            for (IN4JSSourceContainer c : project.getSourceContainers()) {
                if (!c.isExternal()) continue;
                String sourceRelativePath = dep.getURI().toString().replace(source.getLocation().toString(), "");
                String[] potentialExternalSourceRelativeURISegments = null;
                String potentialExternalSourceRelativePath = sourceRelativePath.replace(".n4jsd", ".js");
                potentialExternalSourceRelativeURISegments = URI.createURI((String)potentialExternalSourceRelativePath).segments();
                if (potentialExternalSourceRelativeURISegments == null) continue;
                URI potentialExternalSourceURI = c.getLocation().appendSegments(potentialExternalSourceRelativeURISegments).toURI();
                try {
                    Resource externalDep = dep.getResourceSet().getResource(potentialExternalSourceURI, true);
                    script = (Script)externalDep.getContents().get(0);
                    if (!this.xpectGenerator.isCompilable(externalDep, errorResult)) continue;
                    this.createTempJsFileWithScript(root, script, options, replaceQuotes);
                }
                catch (Exception e) {
                    throw new RuntimeException("Couldn't load " + potentialExternalSourceURI + ".", e);
                }
            }
        }
    }

    private File createTempJsFileWithScript(Path root, Script script, GeneratorOption[] options, boolean replaceQuotes) throws IOException {
        String content = this.xpectGenerator.compile(script, options, replaceQuotes);
        String srcgenSegments = this.getCompiledFileBasePath(script, true);
        Path srcgenPath = FileUtils.createNestedDirectory((Path)root, (String)srcgenSegments);
        LinkedList<String> segments = this.moduleQualifiedNameSegments(script);
        String fileName = segments.removeLast();
        for (String folderName : segments) {
            srcgenPath = FileUtils.createDirectory((Path)srcgenPath, (String)folderName);
        }
        File file = new File(srcgenPath.toFile(), String.valueOf(fileName) + ".js");
        if (!file.exists() && !file.createNewFile()) {
            throw new RuntimeException("Exception when creating new file: " + file);
        }
        Object object = null;
        Object var12_13 = null;
        try (PrintWriter pw = new PrintWriter(file);){
            pw.print(content);
        }
        catch (Throwable throwable) {
            if (object == null) {
                object = throwable;
            } else if (object != throwable) {
                ((Throwable)object).addSuppressed(throwable);
            }
            throw object;
        }
        return file;
    }

    private LinkedList<String> moduleQualifiedNameSegments(Script script) {
        return Lists.newLinkedList((Iterable)Splitter.on((String)"/").split((CharSequence)script.getModule().getQualifiedName()));
    }

    private String jsModulePathToRun(Script script) {
        StringJoiner sj = new StringJoiner("/");
        sj.add(this.getCompiledFileBasePath(script, false));
        this.moduleQualifiedNameSegments(script).forEach(sj::add);
        return sj.toString();
    }

    private String getCompiledFileBasePath(Script script, boolean includeProjectName) {
        String path = includeProjectName ? String.valueOf(script.getModule().getProjectName()) + '/' + "src-gen" : "src-gen";
        IN4JSProject project = (IN4JSProject)this.core.findProject(script.eResource().getURI()).orNull();
        if (project != null) {
            path = AbstractSubGenerator.calculateProjectBasedOutputDirectory((IN4JSProject)project, (boolean)includeProjectName);
        }
        return path;
    }
}

