/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.ui.methods.contentassist;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.n4js.xpect.config.ValueList;
import org.eclipse.n4js.xpect.config.VarDef;
import org.eclipse.n4js.xpect.config.XpEnvironmentData;
import org.eclipse.xpect.expectation.impl.ExpectationCollection;

class VarSubstExpectationCollection
extends ExpectationCollection {
    static final Pattern pVar = Pattern.compile("<\\$(\\p{Alpha}*)>");
    private final XpEnvironmentData runData;

    public VarSubstExpectationCollection(XpEnvironmentData data) {
        Preconditions.checkNotNull((Object)data);
        this.runData = data;
    }

    protected List<ExpectationCollection.ExpectationItem> createItems(String item, boolean negated, boolean quoted2, boolean escaped) {
        Matcher m = pVar.matcher(item);
        boolean foundMatch = m.find();
        if (foundMatch) {
            String name = m.group(1);
            VarDef varDef = this.runData.getVar(name);
            ArrayList<ExpectationCollection.ExpectationItem> ret = new ArrayList<ExpectationCollection.ExpectationItem>();
            for (ValueList mem : varDef.mlist) {
                for (String s : mem.evaluate(this.runData.getResourceUnderTest())) {
                    ret.add(super.createItem(s, negated, quoted2, escaped));
                }
            }
            return ret;
        }
        return Arrays.asList(super.createItem(item, negated, quoted2, escaped));
    }

    public void init(String expectation) {
        this.items = this.createCollection();
        boolean esc = false;
        boolean escaped = true;
        boolean quote2 = false;
        boolean quoted2 = false;
        boolean neg = false;
        StringBuilder item = new StringBuilder();
        StringBuilder ws = new StringBuilder();
        int i = 0;
        while (i < expectation.length()) {
            block13: {
                char c;
                block16: {
                    block10: {
                        block15: {
                            block11: {
                                block14: {
                                    block12: {
                                        c = expectation.charAt(i);
                                        if (esc) break block10;
                                        if (quote2) break block11;
                                        if (c != this.separator) break block12;
                                        if (item.length() > 0) {
                                            this.items.addAll(this.createItems(item.toString(), neg, quoted2, escaped));
                                        }
                                        escaped = false;
                                        quoted2 = false;
                                        neg = false;
                                        item = new StringBuilder();
                                        ws = new StringBuilder();
                                        break block13;
                                    }
                                    if (!Character.isWhitespace(c)) break block14;
                                    ws.append(c);
                                    break block13;
                                }
                                if (c != '!' || item.length() != 0) break block11;
                                neg = true;
                                break block13;
                            }
                            if (!this.quoted || c != this.quote) break block15;
                            if (quote2) {
                                item.append((CharSequence)ws);
                            }
                            ws = new StringBuilder();
                            quote2 = !quote2;
                            quoted2 = true;
                            break block13;
                        }
                        if (c != 92) break block16;
                        esc = true;
                        escaped = true;
                        break block13;
                    }
                    esc = false;
                    switch (c) {
                        case 'n': {
                            c = '\n';
                            break;
                        }
                        case 'r': {
                            c = '\r';
                        }
                    }
                }
                if (ws.length() > 0) {
                    if (item.length() > 0) {
                        item.append((CharSequence)ws);
                    }
                    ws = new StringBuilder();
                }
                item.append(c);
            }
            ++i;
        }
        if (item.length() > 0) {
            this.items.addAll(this.createItems(item.toString(), neg, quoted2, escaped));
        }
    }
}

