/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.wizard.workspace;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.ui.wizard.generator.ContentBlock;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditor;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorFactory;
import org.eclipse.xtext.ui.editor.syntaxcoloring.DefaultHighlightingConfiguration;
import org.eclipse.xtext.ui.editor.syntaxcoloring.PreferenceStoreAccessor;
import org.eclipse.xtext.ui.editor.utils.TextStyle;

public class WizardPreviewProvider {
    private static final DefaultHighlightingConfiguration DEFAULT_HIGHLIGHTING_CONFIGURATION = new DefaultHighlightingConfiguration();
    private static Logger LOGGER = Logger.getLogger(WizardPreviewProvider.class);
    @Inject
    private EmbeddedEditorFactory editorFactory;
    @Inject
    private IN4JSCore n4jsCore;
    @Inject
    private PreferenceStoreAccessor preferenceStoreAccessor;

    public WizardPreview create(Composite parent, int style) {
        return new WizardPreview(parent, style);
    }

    public class WizardPreview
    extends Composite {
        private Document editorDocument;
        private SourceViewer sourceViewer;
        private Label infoLabel;
        private ContentBlock[] contentBlocks;
        private final Color inactiveColor;
        private final Font editorFont;

        public WizardPreview(Composite parent, int style) {
            super(parent, style);
            this.editorFont = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry().get("org.eclipse.jface.textfont");
            this.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(1).extendedMargins(0, 0, 0, 0).create());
            this.createEditor();
            this.createInfoBar();
            this.inactiveColor = this.createInactiveColor();
            this.sourceViewer.getTextWidget().setData("org.eclipse.e4.ui.css.CssClassName", (Object)"MPart active");
        }

        public void dispose() {
            this.inactiveColor.dispose();
            super.dispose();
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            if (!enabled) {
                this.unhighlightAll();
            }
        }

        public void setContent(ContentBlock[] blocks) {
            if (this.editorDocument == null) {
                return;
            }
            ArrayList<ContentBlock> blockList = new ArrayList<ContentBlock>(Arrays.asList(blocks));
            int replaceStart = 0;
            if (this.contentBlocks != null) {
                int index = 0;
                Iterator itr = blockList.iterator();
                while (itr.hasNext()) {
                    if (this.contentBlocks.length <= index) continue;
                    ContentBlock currentBlock = (ContentBlock)itr.next();
                    if (!this.contentBlocks[index].content.equals(currentBlock.content)) break;
                    replaceStart += currentBlock.content.length();
                    ++index;
                    itr.remove();
                }
            }
            this.contentBlocks = blocks;
            StringBuilder joinedContent = new StringBuilder();
            blockList.stream().forEach(block -> {
                StringBuilder stringBuilder2 = joinedContent.append(block.content);
            });
            try {
                this.editorDocument.replace(replaceStart, this.getContent().length() - replaceStart, joinedContent.toString());
            }
            catch (Exception e) {
                LOGGER.warn((Object)"Failed to insert changed blocks", (Throwable)e);
            }
            this.sourceViewer.invalidateTextPresentation();
            this.updateHighlighting();
        }

        public String getContent() {
            if (this.editorDocument != null) {
                return this.editorDocument.get();
            }
            return null;
        }

        public void revealContentBlock(ContentBlock block) {
            int accumulatedOffset = 0;
            ContentBlock blockToShow = null;
            ContentBlock[] contentBlockArray = this.contentBlocks;
            int n = this.contentBlocks.length;
            int n2 = 0;
            while (n2 < n) {
                ContentBlock contentBlock = contentBlockArray[n2];
                if (block == contentBlock) {
                    blockToShow = block;
                    break;
                }
                accumulatedOffset += contentBlock.content.length();
                ++n2;
            }
            if (blockToShow != null) {
                this.sourceViewer.revealRange(accumulatedOffset, blockToShow.content.length());
            }
        }

        public void setInfo(String info) {
            this.infoLabel.setText(info);
        }

        private Color createInactiveColor() {
            TextStyle commentTextStyle = new TextStyle();
            WizardPreviewProvider.this.preferenceStoreAccessor.populateTextStyle("comment", commentTextStyle, DEFAULT_HIGHLIGHTING_CONFIGURATION.commentTextStyle());
            return new Color((Device)this.getDisplay(), commentTextStyle.getColor());
        }

        private void createInfoBar() {
            Composite infoComposite = new Composite((Composite)this, 2048);
            infoComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
            infoComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(1).create());
            this.infoLabel = new Label(infoComposite, 0);
            this.infoLabel.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        }

        private void createEditor() {
            EmbeddedEditor editor = WizardPreviewProvider.this.editorFactory.newEditor(this::createTempResource).withParent((Composite)this);
            editor.getViewer().getControl().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
            editor.createPartialEditor(true);
            this.editorDocument = editor.getDocument();
            this.sourceViewer = editor.getViewer();
            this.configureSourceViewer(this.sourceViewer);
            this.editorDocument.set("");
        }

        private XtextResource createTempResource() {
            String partialUri = "/" + new Random().nextInt(Integer.MAX_VALUE) + "TempProject" + Instant.now().getNano() + "/temp.n4js";
            return (XtextResource)WizardPreviewProvider.this.n4jsCore.createResourceSet(Optional.absent()).createResource(URI.createPlatformResourceURI((String)partialUri, (boolean)true));
        }

        private void configureSourceViewer(SourceViewer viewer) {
            viewer.setEditable(false);
            viewer.addTextListener(new ITextListener(){

                public void textChanged(TextEvent event) {
                    WizardPreview.this.updateHighlighting();
                    WizardPreview.this.sourceViewer.getTextWidget().setFont(WizardPreview.this.editorFont);
                }
            });
        }

        private void unhighlightAll() {
            StyleRange[] styleRangeArray = this.sourceViewer.getTextWidget().getStyleRanges();
            int n = styleRangeArray.length;
            int n2 = 0;
            while (n2 < n) {
                StyleRange range = styleRangeArray[n2];
                if (range.foreground != this.inactiveColor) {
                    range.foreground = this.inactiveColor;
                    range.fontStyle = 0;
                    this.sourceViewer.getTextWidget().setStyleRange(range);
                }
                ++n2;
            }
        }

        private void updateHighlighting() {
            if (!this.getEnabled()) {
                this.unhighlightAll();
                return;
            }
            if (this.contentBlocks == null) {
                return;
            }
            int accumulatedOffset = 0;
            ContentBlock[] contentBlockArray = this.contentBlocks;
            int n = this.contentBlocks.length;
            int n2 = 0;
            while (n2 < n) {
                ContentBlock block = contentBlockArray[n2];
                if (!block.highlighted) {
                    StyleRange range = new StyleRange(accumulatedOffset, block.content.length(), this.inactiveColor, null);
                    this.sourceViewer.getTextWidget().setStyleRange(range);
                }
                accumulatedOffset += block.content.length();
                ++n2;
            }
        }
    }
}

