/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.metamodelimpl;

import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.css.core.internal.Logger;
import org.eclipse.wst.css.core.internal.metamodel.CSSProfile;
import org.eclipse.wst.css.core.internal.metamodelimpl.CSSProfileImpl;
import org.osgi.framework.Bundle;

public class RegistryReader {
    private String PLUGIN_ID = "org.eclipse.wst.sse.core";
    private String EXTENSION_POINT_ID = "cssprofile";
    private String TAG_NAME = "profile";
    private String ATT_ID = "id";
    private String ATT_NAME = "name";
    private String ATT_URI = "uri";
    private String ATT_DEFAULT = "default";
    private String ATT_LOGGING = "logging";

    protected CSSProfile readElement(IConfigurationElement element) {
        CSSProfileImpl info = null;
        if (element.getName().equals(this.TAG_NAME)) {
            String strID = element.getAttribute(this.ATT_ID);
            String strNAME = element.getAttribute(this.ATT_NAME);
            String strURI = element.getAttribute(this.ATT_URI);
            if (strID != null || strURI != null) {
                Path path;
                URL url;
                Bundle bundle = null;
                String pluginId = element.getContributor().getName();
                bundle = Platform.getBundle((String)pluginId);
                if (bundle != null && (url = FileLocator.find((Bundle)bundle, (IPath)(path = new Path(strURI)), null)) != null) {
                    try {
                        url = FileLocator.toFileURL((URL)url);
                        info = new CSSProfileImpl(strID, url, strURI);
                        info.setProfileName(strNAME);
                        info.setDefault(element.getAttribute(this.ATT_DEFAULT) != null);
                        info.setLogging(element.getAttribute(this.ATT_LOGGING) != null);
                        info.setOwnerPluginID(pluginId);
                    }
                    catch (IOException iOException) {}
                }
            }
            if (info == null) {
                Logger.log(4, "Error reading CSS Profile: " + strID);
            }
        }
        return info;
    }

    public Iterator enumProfiles() {
        HashSet<CSSProfile> set = new HashSet<CSSProfile>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(this.PLUGIN_ID, this.EXTENSION_POINT_ID);
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                CSSProfile info = this.readElement(elements[i]);
                if (info != null) {
                    set.add(info);
                }
                ++i;
            }
        }
        return set.iterator();
    }
}

