/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.decorator;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.n4js.projectDescription.ProjectType;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.ui.ImageDescriptorCache;

public class ProjectTypeLabelDecorator
implements ILightweightLabelDecorator {
    private static final Logger LOGGER = Logger.getLogger(ProjectTypeLabelDecorator.class);
    private static final Map<ProjectType, ImageDescriptorCache.ImageRef> IMAGE_REF_CACHE = ImmutableMap.builder().put((Object)ProjectType.TEST, (Object)ImageDescriptorCache.ImageRef.PROJECT_TYPE_TEST_DECOR).put((Object)ProjectType.APPLICATION, (Object)ImageDescriptorCache.ImageRef.PROJECT_TYPE_APP_DECOR).put((Object)ProjectType.API, (Object)ImageDescriptorCache.ImageRef.PROJECT_TYPE_APP_DECOR).put((Object)ProjectType.RUNTIME_ENVIRONMENT, (Object)ImageDescriptorCache.ImageRef.PROJECT_TYPE_RE_DECOR).put((Object)ProjectType.RUNTIME_LIBRARY, (Object)ImageDescriptorCache.ImageRef.PROJECT_TYPE_RL_DECOR).put((Object)ProjectType.LIBRARY, (Object)ImageDescriptorCache.ImageRef.PROJECT_TYPE_LIB_DECOR).put((Object)ProjectType.PROCESSOR, (Object)ImageDescriptorCache.ImageRef.PROJECT_TYPE_PROC_DECOR).build();
    @Inject
    private IN4JSCore core;

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void decorate(Object element, IDecoration decoration) {
        try {
            ImageDescriptor descriptor;
            ImageDescriptorCache.ImageRef imageRef;
            URI uri;
            IN4JSProject project;
            if (element instanceof IProject && (project = (IN4JSProject)this.core.findProject(uri = URI.createPlatformResourceURI((String)((IProject)element).getName(), (boolean)true)).orNull()) != null && (imageRef = IMAGE_REF_CACHE.get(project.getProjectType())) != null && (descriptor = (ImageDescriptor)imageRef.asImageDescriptor().orNull()) != null) {
                decoration.addOverlay(descriptor);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error while trying to get decorator for " + element), (Throwable)e);
        }
    }
}

