/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.analysis;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.n4js.flowgraphs.analysis.BranchWalkerInternal;
import org.eclipse.n4js.flowgraphs.analysis.EdgeGuide;
import org.eclipse.n4js.flowgraphs.analysis.EdgeGuideMerged;
import org.eclipse.n4js.flowgraphs.analysis.EdgeGuideQueue;
import org.eclipse.n4js.flowgraphs.analysis.NextEdgesProvider;
import org.eclipse.n4js.flowgraphs.model.ComplexNode;
import org.eclipse.n4js.flowgraphs.model.ControlFlowEdge;
import org.eclipse.n4js.flowgraphs.model.Node;

public class EdgeGuideWorklist {
    private final EdgeGuideQueue egQueue = new EdgeGuideQueue();
    private final Set<ControlFlowEdge> allVisitedEdges = new HashSet<ControlFlowEdge>();
    private EdgeGuide currEdgeGuide;
    private EdgeGuide nextEdgeGuide;

    boolean hasNext() {
        this.setNext();
        return this.nextEdgeGuide != null;
    }

    Iterable<EdgeGuide> getCurrentEdgeGuides() {
        return this.egQueue.getIterator();
    }

    EdgeGuide next() {
        this.setNext();
        this.currEdgeGuide = this.nextEdgeGuide;
        this.nextEdgeGuide = null;
        return this.currEdgeGuide;
    }

    void initialize(ComplexNode cn, NextEdgesProvider edgeProvider, Collection<BranchWalkerInternal> activatedPaths) {
        this.allVisitedEdges.clear();
        this.currEdgeGuide = null;
        this.nextEdgeGuide = null;
        this.egQueue.clear();
        List<EdgeGuide> nextEGs = EdgeGuide.getFirstEdgeGuides(cn, edgeProvider, activatedPaths);
        this.egQueue.addAll(nextEGs);
    }

    List<EdgeGuide> getJoinGroups() {
        this.allVisitedEdges.add(this.currEdgeGuide.getEdge());
        List<EdgeGuide> nextEGs = this.currEdgeGuide.getNextEdgeGuides();
        this.egQueue.addAll(nextEGs);
        List<EdgeGuide> joinGuideGroup = this.egQueue.removeFirstJoinGuide();
        return joinGuideGroup;
    }

    EdgeGuideMerged mergeJoinGroup(List<EdgeGuide> joinGuideGroup) {
        Preconditions.checkState((!joinGuideGroup.isEmpty() ? 1 : 0) != 0);
        EdgeGuideMerged remainingEdgeGuide = new EdgeGuideMerged(joinGuideGroup);
        for (EdgeGuide eg : joinGuideGroup) {
            this.allVisitedEdges.add(eg.getEdge());
        }
        List<EdgeGuide> nextEGs = remainingEdgeGuide.getNextEdgeGuides();
        this.egQueue.addAll(nextEGs);
        return remainingEdgeGuide;
    }

    boolean edgeVisited(ControlFlowEdge edge) {
        return this.allVisitedEdges.contains(edge);
    }

    Set<ControlFlowEdge> getAllVisitedEdges() {
        return this.allVisitedEdges;
    }

    Set<Node> getAllVisitedNodes(ComplexNode cn, NextEdgesProvider edgeProvider) {
        HashSet<Node> allVisitedNodes = new HashSet<Node>();
        for (ControlFlowEdge edge : this.allVisitedEdges) {
            allVisitedNodes.add(edge.start);
            allVisitedNodes.add(edge.end);
        }
        allVisitedNodes.add(edgeProvider.getStartNode(cn));
        return allVisitedNodes;
    }

    private void setNext() {
        if (this.nextEdgeGuide != null) {
            return;
        }
        this.nextEdgeGuide = null;
        while (!this.egQueue.isEmpty() && this.nextEdgeGuide == null) {
            this.nextEdgeGuide = this.egQueue.removeFirst();
            boolean alreadyVisitedAndObsolete = this.allVisitedEdges.contains(this.nextEdgeGuide.getEdge());
            alreadyVisitedAndObsolete &= this.nextEdgeGuide.isEmpty();
            if (!(alreadyVisitedAndObsolete &= !this.nextEdgeGuide.deadContext.isForwardDeadFlow())) continue;
            this.nextEdgeGuide = null;
        }
    }
}

