/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.util.List;
import java.util.function.Predicate;
import junit.framework.Test;
import junit.framework.TestResult;
import org.apache.tools.ant.taskdefs.optional.junit.CustomJUnit4TestAdapterCache;
import org.junit.runner.Description;
import org.junit.runner.Request;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;

public class JUnit4TestMethodAdapter
implements Test {
    private final Class<?> testClass;
    private final String[] methodNames;
    private final Runner runner;
    private final CustomJUnit4TestAdapterCache cache;

    public JUnit4TestMethodAdapter(Class<?> testClass, String[] methodNames) {
        if (testClass == null) {
            throw new IllegalArgumentException("testClass is <null>");
        }
        if (methodNames == null) {
            throw new IllegalArgumentException("methodNames is <null>");
        }
        for (int i = 0; i < methodNames.length; ++i) {
            if (methodNames[i] == null) {
                throw new IllegalArgumentException("method name #" + i + " is <null>");
            }
            if (!methodNames[i].isEmpty()) continue;
            throw new IllegalArgumentException("method name #" + i + " is empty");
        }
        this.testClass = testClass;
        this.methodNames = (String[])methodNames.clone();
        this.cache = CustomJUnit4TestAdapterCache.getInstance();
        Request request = methodNames.length == 1 ? Request.method(testClass, (String)methodNames[0]) : Request.aClass(testClass).filterWith((Filter)new MultipleMethodsFilter(testClass, methodNames));
        this.runner = request.getRunner();
    }

    public int countTestCases() {
        return this.runner.testCount();
    }

    public Description getDescription() {
        return this.runner.getDescription();
    }

    public List<Test> getTests() {
        return this.cache.asTestList(this.getDescription());
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    public void run(TestResult result) {
        this.runner.run(this.cache.getNotifier(result));
    }

    public String toString() {
        String testClassName = this.testClass.getName();
        StringBuilder buf = new StringBuilder(testClassName.length() + 12 * this.methodNames.length).append(':');
        if (this.methodNames.length != 0) {
            buf.append(this.methodNames[0]);
            for (int i = 1; i < this.methodNames.length; ++i) {
                buf.append(',').append(this.methodNames[i]);
            }
        }
        return buf.toString();
    }

    private static final class MultipleMethodsFilter
    extends Filter {
        private final Description methodsListDescription;
        private final Class<?> testClass;
        private final String[] methodNames;

        private MultipleMethodsFilter(Class<?> testClass, String[] methodNames) {
            if (testClass == null) {
                throw new IllegalArgumentException("testClass is <null>");
            }
            if (methodNames == null) {
                throw new IllegalArgumentException("methodNames is <null>");
            }
            this.methodsListDescription = Description.createSuiteDescription(testClass);
            for (String methodName : methodNames) {
                this.methodsListDescription.addChild(Description.createTestDescription(testClass, (String)methodName));
            }
            this.testClass = testClass;
            this.methodNames = methodNames;
        }

        public boolean shouldRun(Description description) {
            if (this.methodNames.length == 0) {
                return false;
            }
            if (description.isTest()) {
                return this.methodsListDescription.getChildren().stream().anyMatch(Predicate.isEqual(description));
            }
            return description.getChildren().stream().anyMatch(this::shouldRun);
        }

        public String describe() {
            StringBuilder buf = new StringBuilder(40);
            if (this.methodNames.length == 0) {
                buf.append("No methods");
            } else {
                buf.append(this.methodNames.length == 1 ? "Method " : "Methods ");
                for (String methodName : this.methodNames) {
                    buf.append(methodName).append(',');
                }
                buf.setLength(buf.length() - 1);
            }
            buf.append('(').append(this.testClass.getName()).append(')');
            return buf.toString();
        }
    }
}

