/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tester.server.resources;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.log4j.Logger;
import org.eclipse.jetty.servlet.ServletHolder;

@Singleton
public class ServletHolderBuilder {
    private static final Logger LOGGER = Logger.getLogger(ServletHolderBuilder.class);
    @Inject
    private Injector injectedInjector;

    public ServletHolder build(final Class<? extends Servlet> clazz) {
        ServletHolder servletHolder = new ServletHolder(clazz){

            protected Servlet newInstance() throws ServletException, IllegalAccessException, InstantiationException {
                try {
                    Servlet servlet = super.newInstance();
                    Injector injector = ServletHolderBuilder.this.injectedInjector;
                    injector.injectMembers((Object)servlet);
                    return servlet;
                }
                catch (Exception e) {
                    LOGGER.error((Object)("Error while creating servlet for class: " + clazz + ";"), (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        };
        return servletHolder;
    }
}

