/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.dataflow;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.n4js.flowgraphs.FlowAnalyser;
import org.eclipse.n4js.flowgraphs.analysis.TraverseDirection;
import org.eclipse.n4js.flowgraphs.dataflow.Assumption;
import org.eclipse.n4js.flowgraphs.dataflow.EffectInfo;
import org.eclipse.n4js.flowgraphs.dataflow.guards.Guard;
import org.eclipse.n4js.flowgraphs.dataflow.symbols.SymbolFactory;
import org.eclipse.n4js.n4JS.ControlFlowElement;

public abstract class DataFlowVisitor
implements FlowAnalyser {
    protected final TraverseDirection direction;
    Collection<Assumption> newAssumptions = new LinkedList<Assumption>();
    protected Collection<Assumption> allAssumptions = new LinkedList<Assumption>();
    protected Map<Object, Assumption> failedAssumptions = new HashMap<Object, Assumption>();
    protected SymbolFactory symbolFactory;

    public DataFlowVisitor() {
        this(TraverseDirection.Backward);
    }

    public DataFlowVisitor(TraverseDirection mode) {
        this.direction = mode;
    }

    public final TraverseDirection getDirection() {
        return this.direction;
    }

    final void setSymbolFactory(SymbolFactory symbolFactory) {
        this.symbolFactory = symbolFactory;
    }

    final Collection<Assumption> moveNewAssumptions() {
        if (this.newAssumptions.isEmpty()) {
            return Collections.emptyList();
        }
        this.allAssumptions.addAll(this.newAssumptions);
        LinkedList<Assumption> newAssumptionsTmp = new LinkedList<Assumption>(this.newAssumptions);
        this.newAssumptions.clear();
        return newAssumptionsTmp;
    }

    protected final SymbolFactory getSymbolFactory() {
        return this.symbolFactory;
    }

    protected final void assume(Assumption assumption) {
        assumption.setDataFlowVisitor(this);
        this.newAssumptions.add(assumption);
    }

    protected void visitEffect(EffectInfo effect, ControlFlowElement cfe) {
    }

    protected void visitGuard(Guard guard) {
    }
}

